/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.data.packs;

import einstein.jmc.JustMoreCakes;
import einstein.jmc.data.CakeOvenRecipeBuilder;
import einstein.jmc.data.MixingRecipeBuilder;
import einstein.jmc.data.packs.ModItemTags;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.init.ModItems;
import einstein.jmc.registration.family.CakeFamily;
import einstein.jmc.util.Util;
import java.util.function.Supplier;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ModRecipes {
    private static final String HAS = "has_item";

    public static void init(RecipeOutput output) {
        ModRecipes.craftingRecipes(output);
        ModRecipes.cakeOvenRecipes(output);
        ModRecipes.mixingRecipes(output);
    }

    private static void craftingRecipes(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ModBlocks.CAKE_OVEN.get().asItem()).pattern("###").pattern("#$#").pattern("~~~").define(Character.valueOf('#'), (ItemLike)Items.BRICK).define(Character.valueOf('$'), (ItemLike)Blocks.FURNACE).define(Character.valueOf('~'), (ItemLike)Blocks.SMOOTH_STONE).unlockedBy(HAS, RecipeProvider.has((ItemLike)Blocks.SMOOTH_STONE)).save(output, ModRecipes.craftingLoc(ModBlocks.CAKE_OVEN));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.CAKE_SPATULA.get())).pattern(" ##").pattern(" ##").pattern("$  ").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('$'), (ItemLike)Items.STICK).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(output, ModRecipes.craftingLoc(ModItems.CAKE_SPATULA));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.CAKE_STAND.get()), (int)2).pattern("###").pattern("$$$").pattern(" $ ").define(Character.valueOf('#'), (ItemLike)Blocks.GLASS).define(Character.valueOf('$'), (ItemLike)Blocks.QUARTZ_SLAB).unlockedBy(HAS, RecipeProvider.has((ItemLike)Blocks.QUARTZ_SLAB)).save(output, ModRecipes.craftingLoc(ModBlocks.CAKE_STAND));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.CERAMIC_BOWL.get())).pattern("# #").pattern("###").define(Character.valueOf('#'), (ItemLike)Blocks.TERRACOTTA).unlockedBy(HAS, RecipeProvider.has((ItemLike)Blocks.TERRACOTTA)).save(output, ModRecipes.craftingLoc(ModBlocks.CERAMIC_BOWL));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.WHISK.get())).pattern("#").pattern("$").pattern("~").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('$'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('~'), (ItemLike)Items.STICK).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(output, ModRecipes.craftingLoc(ModItems.WHISK));
    }

    private static void cakeOvenRecipes(RecipeOutput output) {
        CakeOvenRecipeBuilder.cakeBaking((ItemLike)Blocks.CAKE, 0.5f, 200, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.EGG)).save(output, JustMoreCakes.loc("cake_from_cake_oven"));
        CakeOvenRecipeBuilder.cakeBaking((ItemLike)ModBlocks.CUPCAKE_VARIANT.getCake().get(), 2, 0.5f, 200, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CUPCAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CUPCAKE_FROSTING.get()})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.EGG)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.CUPCAKE_VARIANT.getCake()));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.CARROT_CAKE_FAMILY, 0.6f, 300, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.CARROT)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.CARROT_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.CHEESECAKE_FAMILY, 0.7f, 250, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of(ModItemTags.CHEESE)).unlockedBy(HAS, RecipeProvider.has((ItemLike)((ItemLike)ModItems.CREAM_CHEESE.get()))).save(output, ModRecipes.cakeOvenLoc(ModBlocks.CHEESECAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.SWEET_BERRY_CAKE_FAMILY, 0.5f, 200, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.SWEET_BERRIES)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.SWEET_BERRY_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.CHOCOLATE_CAKE_FAMILY, 0.6f, 250, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.COCOA_BEANS})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.COCOA_BEANS)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.CHOCOLATE_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.HONEY_CAKE_FAMILY, 0.7f, 300, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.HONEY_BOTTLE)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.HONEY_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.APPLE_CAKE_FAMILY, 0.5f, 200, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.APPLE)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.APPLE_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((ItemLike)ModBlocks.POISON_CAKE_VARIANT.getCake().get(), 0.5f, 300, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.SPIDER_EYE)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.POISON_CAKE_VARIANT.getCake()));
        CakeOvenRecipeBuilder.cakeBaking((ItemLike)ModBlocks.TNT_CAKE_VARIANT.getCake().get(), 0.4f, 350, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.TNT})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Blocks.TNT)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.TNT_CAKE_VARIANT.getCake()));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.PUMPKIN_CAKE_FAMILY, 0.6f, 250, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.PUMPKIN})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Blocks.PUMPKIN)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.PUMPKIN_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.RED_VELVET_CAKE_FAMILY, 0.8f, 300, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of(ModItemTags.RED_DYE), Ingredient.of((ItemLike[])new ItemLike[]{Items.COCOA_BEANS})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.COCOA_BEANS)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.RED_VELVET_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.GLOW_BERRY_CAKE_FAMILY, 0.5f, 350, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.GLOW_BERRIES)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.GLOW_BERRY_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.BROWN_MUSHROOM_CAKE_FAMILY, 0.4f, 250, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BROWN_MUSHROOM}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BROWN_MUSHROOM})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Blocks.BROWN_MUSHROOM)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.BROWN_MUSHROOM_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.RED_MUSHROOM_CAKE_FAMILY, 0.4f, 250, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.RED_MUSHROOM}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.RED_MUSHROOM})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Blocks.RED_MUSHROOM)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.RED_MUSHROOM_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.REDSTONE_CAKE_FAMILY, 0.5f, 200, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.REDSTONE)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.REDSTONE_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.SEED_CAKE_FAMILY, 0.3f, 150, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of(ModItemTags.SEEDS), Ingredient.of(ModItemTags.SEEDS)).unlockedBy(HAS, RecipeProvider.has(ModItemTags.SEEDS)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.SEED_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.SLIME_CAKE_FAMILY, 0.8f, 300, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of(ModItemTags.SLIME_BALLS), Ingredient.of(ModItemTags.SLIME_BALLS)).unlockedBy(HAS, RecipeProvider.has(ModItemTags.SLIME_BALLS)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.SLIME_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.CHORUS_CAKE_FAMILY, 0.7f, 250, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHORUS_FRUIT})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.CHORUS_FRUIT)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.CHORUS_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.COOKIE_CAKE_FAMILY, 0.6f, 200, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.COOKIE})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.COOKIE)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.COOKIE_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.ENDER_CAKE_FAMILY, 0.8f, 350, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_PEARL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BLAZE_POWDER})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.ENDER_PEARL)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.ENDER_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.GLOWSTONE_CAKE_FAMILY, 0.5f, 200, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.GLOWSTONE_DUST)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.GLOWSTONE_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.GOLDEN_APPLE_CAKE_FAMILY, 0.8f, 400, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.GOLDEN_APPLE)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.GOLDEN_APPLE_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.ICE_CAKE_FAMILY, 0.5f, 250, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ICE})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Blocks.ICE)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.ICE_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.CRIMSON_FUNGUS_CAKE_FAMILY, 0.5f, 250, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CRIMSON_FUNGUS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CRIMSON_FUNGUS})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Blocks.CRIMSON_FUNGUS)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.CRIMSON_FUNGUS_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.WARPED_FUNGUS_CAKE_FAMILY, 0.5f, 250, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_FUNGUS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_FUNGUS})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.WARPED_FUNGUS)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.WARPED_FUNGUS_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.MELON_CAKE_FAMILY, 0.5f, 200, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON_SLICE})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.MELON_SLICE)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.MELON_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.BEETROOT_CAKE_FAMILY, 0.4f, 300, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BEETROOT})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.BEETROOT)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.BEETROOT_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.LAVA_CAKE_FAMILY, 0.4f, 200, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.LAVA_BUCKET)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.LAVA_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.FIREY_CAKE_FAMILY, 0.5f, 200, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MAGMA_CREAM})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.MAGMA_CREAM)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.FIREY_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.OBSIDIAN_CAKE_FAMILY, 1.0f, 800, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.OBSIDIAN})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Blocks.OBSIDIAN)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.OBSIDIAN_CAKE_FAMILY));
        CakeOvenRecipeBuilder.cakeBaking((CakeFamily)ModBlocks.SCULK_CAKE_FAMILY, 0.7f, 350, RecipeCategory.FOOD, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_DOUGH.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CAKE_FROSTING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ECHO_SHARD})).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.ECHO_SHARD)).save(output, ModRecipes.cakeOvenLoc(ModBlocks.SCULK_CAKE_FAMILY));
    }

    private static void mixingRecipes(RecipeOutput output) {
        MixingRecipeBuilder.mixing(RecipeCategory.FOOD, (ItemLike)ModItems.CAKE_DOUGH.get(), JustMoreCakes.loc("cake_dough"), 12, new ItemLike[]{Items.WHEAT, Items.WHEAT, Items.EGG, Items.SUGAR}).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.EGG)).save(output, ModRecipes.mixingLoc(ModItems.CAKE_DOUGH));
        MixingRecipeBuilder.mixing(RecipeCategory.FOOD, (ItemLike)ModItems.CUPCAKE_DOUGH.get(), JustMoreCakes.loc("cake_dough"), 2, 5, new ItemLike[]{Items.WHEAT, Items.EGG, Items.SUGAR}).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.EGG)).save(output, ModRecipes.mixingLoc(ModItems.CUPCAKE_DOUGH));
        MixingRecipeBuilder.mixing(RecipeCategory.FOOD, (ItemLike)ModItems.CREAM_CHEESE.get(), JustMoreCakes.loc("cream_cheese"), 2, 9, new ItemLike[]{Items.MILK_BUCKET, Items.MILK_BUCKET, Items.MILK_BUCKET, Items.MILK_BUCKET}).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.MILK_BUCKET)).save(output, ModRecipes.mixingLoc(ModItems.CREAM_CHEESE));
        MixingRecipeBuilder.mixing(RecipeCategory.FOOD, (ItemLike)ModItems.CAKE_FROSTING.get(), JustMoreCakes.loc("frosting"), 12, new ItemLike[]{Items.MILK_BUCKET, Items.MILK_BUCKET, Items.SUGAR}).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.MILK_BUCKET)).save(output, ModRecipes.mixingLoc(ModItems.CAKE_FROSTING));
        MixingRecipeBuilder.mixing(RecipeCategory.FOOD, (ItemLike)ModItems.CUPCAKE_FROSTING.get(), JustMoreCakes.loc("frosting"), 2, 7, new ItemLike[]{Items.MILK_BUCKET, Items.SUGAR}).unlockedBy(HAS, RecipeProvider.has((ItemLike)Items.MILK_BUCKET)).save(output, ModRecipes.mixingLoc(ModItems.CUPCAKE_FROSTING));
    }

    private static ResourceLocation craftingLoc(Supplier<? extends ItemLike> item) {
        return Util.getItemId(item.get().asItem()).withSuffix("_from_crafting");
    }

    private static ResourceLocation cakeOvenLoc(Supplier<? extends ItemLike> item) {
        return Util.getItemId(item.get().asItem()).withSuffix("_from_cake_oven");
    }

    private static ResourceLocation cakeOvenLoc(CakeFamily family) {
        return ModRecipes.cakeOvenLoc(family.getBaseItem());
    }

    private static ResourceLocation mixingLoc(Supplier<? extends ItemLike> item) {
        return Util.getItemId(item.get().asItem()).withSuffix("_from_mixing");
    }
}

