/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.data.packs.providers;

import com.mojang.datafixers.util.Pair;
import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.block.cake.BaseThreeTieredCakeBlock;
import einstein.jmc.block.cake.BaseTwoTieredCakeBlock;
import einstein.jmc.block.cake.candle.BaseCandleCakeBlock;
import einstein.jmc.block.cake.candle.BaseThreeTieredCandleCakeBlock;
import einstein.jmc.block.cake.candle.BaseTwoTieredCandleCakeBlock;
import einstein.jmc.data.CakeModel;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.registration.CakeVariant;
import einstein.jmc.util.CakeUtil;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "jmc", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock(ModBlocks.ENCASING_ICE.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("encasing_ice", this.mcLoc("ice"))).renderType("translucent"));
        CakeVariant.VARIANT_BY_CAKE.forEach((cake, variant) -> {
            String texturePrefix;
            BaseCakeBlock cakeBlock = (BaseCakeBlock)cake.get();
            CakeVariant.Type variantType = variant.getType();
            CakeModel cakeModel = variant.getCakeModel();
            CakeModel candleCakeModel = variant.getCandleCakeModel();
            String cakeName = variant.getCakeName();
            String string = texturePrefix = variant.getFamily() != null ? variant.getFamily().getBaseCakeName() : variant.getCakeName();
            if (cakeModel != CakeModel.CUSTOM) {
                if (cakeModel == CakeModel.DEFAULT) {
                    switch (variantType) {
                        case BASE: {
                            this.createCake(cakeBlock, texturePrefix, cakeName, null);
                            break;
                        }
                        case TWO_TIERED: {
                            this.createTwoTieredCake(cakeBlock, texturePrefix, cakeName, null);
                            break;
                        }
                        case THREE_TIERED: {
                            this.createThreeTieredCake(cakeBlock, texturePrefix, cakeName, null);
                        }
                    }
                } else if (cakeModel == CakeModel.FROM_VANILLA) {
                    switch (variantType) {
                        case BASE: {
                            this.createFromVanillaCake(cakeBlock, 7, this.mcLoc("cake"));
                            break;
                        }
                        case TWO_TIERED: {
                            this.createFromVanillaCake(cakeBlock, 10, this.modLoc("two_tiered_cake"));
                            break;
                        }
                        case THREE_TIERED: {
                            VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(cakeBlock);
                            List<Pair> halves = List.of(Pair.of((Object)DoubleBlockHalf.UPPER, (Object)5), Pair.of((Object)DoubleBlockHalf.LOWER, (Object)11));
                            for (Pair halfPair : halves) {
                                DoubleBlockHalf half = (DoubleBlockHalf)halfPair.getFirst();
                                VariantBlockStateBuilder.PartialBlockstate halfBuilder = variantBuilder.partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(this.modLoc("three_tiered_cake_" + String.valueOf(half))))});
                                if (cakeBlock.hasBites()) {
                                    halfBuilder.with((Property)BaseThreeTieredCakeBlock.BITES, (Comparable)Integer.valueOf(0));
                                    for (int i = 1; i < (Integer)halfPair.getSecond(); ++i) {
                                        variantBuilder.partialState().with((Property)BaseThreeTieredCakeBlock.BITES, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(this.modLoc("three_tiered_cake_" + String.valueOf(half) + "_slice" + (half == DoubleBlockHalf.LOWER ? i - 5 : i))))});
                                    }
                                    continue;
                                }
                                halfBuilder.with(BaseThreeTieredCakeBlock.HALF, (Comparable)half);
                            }
                            break;
                        }
                    }
                } else if (cakeModel instanceof CakeModel.CrossCakeModel) {
                    CakeModel.CrossCakeModel crossModel = (CakeModel.CrossCakeModel)cakeModel;
                    switch (variantType) {
                        case BASE: {
                            this.createCake(cakeBlock, texturePrefix, cakeName, crossModel.crossTexture());
                            break;
                        }
                        case TWO_TIERED: {
                            this.createTwoTieredCake(cakeBlock, texturePrefix, cakeName, crossModel.crossTexture());
                            break;
                        }
                        case THREE_TIERED: {
                            this.createThreeTieredCake(cakeBlock, texturePrefix, cakeName, crossModel.crossTexture());
                        }
                    }
                }
            }
            if (candleCakeModel != CakeModel.CUSTOM && variant.allowsCandles()) {
                variant.getCandleCakeByCandle().forEach((candle, candleCake) -> {
                    ResourceLocation candleType = CakeUtil.SUPPORTED_CANDLES.get(candle);
                    BaseCandleCakeBlock candleCakeBlock = (BaseCandleCakeBlock)((Object)((Object)((Object)candleCake.get())));
                    VariantBlockStateBuilder variantBuilder = this.getVariantBuilder((Block)candleCakeBlock);
                    if (candleCakeModel == CakeModel.FROM_VANILLA) {
                        switch (variantType) {
                            case BASE: {
                                this.createFromVanillaCandleCake(variantBuilder.partialState(), candleType, candleType.getNamespace(), "cake", true);
                                this.createFromVanillaCandleCake(variantBuilder.partialState(), candleType, candleType.getNamespace(), "cake", false);
                                break;
                            }
                            case TWO_TIERED: {
                                this.createFromVanillaCandleCake(variantBuilder.partialState(), candleType, "jmc", "two_tiered_cake", true);
                                this.createFromVanillaCandleCake(variantBuilder.partialState(), candleType, "jmc", "two_tiered_cake", false);
                                break;
                            }
                            case THREE_TIERED: {
                                this.createFromVanillaThreeTieredCandleCake(variantBuilder.partialState(), candleType, DoubleBlockHalf.UPPER, true);
                                this.createFromVanillaThreeTieredCandleCake(variantBuilder.partialState(), candleType, DoubleBlockHalf.UPPER, false);
                                this.createFromVanillaThreeTieredCandleCake(variantBuilder.partialState(), candleType, DoubleBlockHalf.LOWER, true);
                                this.createFromVanillaThreeTieredCandleCake(variantBuilder.partialState(), candleType, DoubleBlockHalf.LOWER, false);
                            }
                        }
                    } else {
                        if (candleCakeModel instanceof CakeModel.CrossCakeModel) {
                            throw new IllegalArgumentException("Cannot have a cross model candle cake");
                        }
                        switch (variantType) {
                            case BASE: {
                                this.addVariant(variantBuilder, candleType, texturePrefix, cakeName, true);
                                this.addVariant(variantBuilder, candleType, texturePrefix, cakeName, false);
                                break;
                            }
                            case TWO_TIERED: {
                                this.addTwoTieredVariant(variantBuilder, candleType, texturePrefix, cakeName, true);
                                this.addTwoTieredVariant(variantBuilder, candleType, texturePrefix, cakeName, false);
                                break;
                            }
                            case THREE_TIERED: {
                                this.addThreeTieredVariant(variantBuilder, candleType, texturePrefix, cakeName, true, DoubleBlockHalf.LOWER);
                                this.addThreeTieredVariant(variantBuilder, candleType, texturePrefix, cakeName, false, DoubleBlockHalf.LOWER);
                                this.addThreeTieredVariant(variantBuilder, candleType, texturePrefix, cakeName, true, DoubleBlockHalf.UPPER);
                                this.addThreeTieredVariant(variantBuilder, candleType, texturePrefix, cakeName, false, DoubleBlockHalf.UPPER);
                            }
                        }
                    }
                });
            }
        });
    }

    private void addVariant(VariantBlockStateBuilder builder, ResourceLocation candleType, String texturePrefix, String name, boolean isLit) {
        String litName = isLit ? "_lit" : "";
        builder.partialState().with((Property)AbstractCandleBlock.LIT, (Comparable)Boolean.valueOf(isLit)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(candleType.getPath() + "candle_" + name + litName, this.mcLoc("template_cake_with_candle"))).texture("candle", ModBlockStateProvider.getCandleTexture(candleType, litName))).texture("side", ModBlockStateProvider.blockLoc(texturePrefix + "_side"))).texture("top", ModBlockStateProvider.blockLoc(texturePrefix + "_top"))).texture("bottom", ModBlockStateProvider.blockLoc(texturePrefix + "_bottom"))).texture("particle", "#side"))});
    }

    private void addTwoTieredVariant(VariantBlockStateBuilder builder, ResourceLocation candleType, String texturePrefix, String name, boolean isLit) {
        String litName = isLit ? "_lit" : "";
        builder.partialState().with((Property)BaseTwoTieredCandleCakeBlock.LIT, (Comparable)Boolean.valueOf(isLit)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(candleType.getPath() + "candle_" + name + litName, this.modLoc("template_two_tiered_candle_cake"))).texture("candle", ModBlockStateProvider.getCandleTexture(candleType, litName))).texture("bottom", ModBlockStateProvider.blockLoc(texturePrefix + "_bottom"))).texture("top_side", ModBlockStateProvider.blockLoc(texturePrefix + "_medium_side"))).texture("top", ModBlockStateProvider.blockLoc(texturePrefix + "_medium_top"))).texture("lower_side", ModBlockStateProvider.blockLoc(texturePrefix + "_side"))).texture("lower_top", ModBlockStateProvider.blockLoc(texturePrefix + "_top_covered")))});
    }

    private void addThreeTieredVariant(VariantBlockStateBuilder builder, ResourceLocation candleType, String texturePrefix, String name, boolean isLit, DoubleBlockHalf half) {
        String litName = isLit ? "_lit" : "";
        String halfName = "_" + String.valueOf(half);
        BlockModelBuilder modelBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(candleType.getPath() + "candle_" + name + halfName + litName, this.modLoc("template_three_tiered_candle_cake" + halfName))).texture("candle", ModBlockStateProvider.getCandleTexture(candleType, litName))).texture("bottom", ModBlockStateProvider.blockLoc(texturePrefix + "_bottom"));
        if (half == DoubleBlockHalf.LOWER) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)modelBuilder.texture("middle_side", ModBlockStateProvider.blockLoc(texturePrefix + "_medium_side"))).texture("middle_top", ModBlockStateProvider.blockLoc(texturePrefix + "_medium_top_covered"))).texture("lower_side", ModBlockStateProvider.blockLoc(texturePrefix + "_side"))).texture("lower_top", ModBlockStateProvider.blockLoc(texturePrefix + "_top_covered"));
        } else {
            ((BlockModelBuilder)modelBuilder.texture("top_side", ModBlockStateProvider.blockLoc(texturePrefix + "_small_side"))).texture("top", ModBlockStateProvider.blockLoc(texturePrefix + "_small_top"));
        }
        builder.partialState().with((Property)BaseThreeTieredCandleCakeBlock.LIT, (Comparable)Boolean.valueOf(isLit)).with(BaseThreeTieredCandleCakeBlock.HALF, (Comparable)half).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelBuilder)});
    }

    private static ResourceLocation getCandleTexture(ResourceLocation candleType, String litName) {
        return ResourceLocation.fromNamespaceAndPath((String)candleType.getNamespace(), (String)ModBlockStateProvider.blockLoc(candleType.getPath() + "candle" + litName));
    }

    private void createCake(BaseCakeBlock cake, String texturePrefix, String name, @Nullable ResourceLocation crossTexture) {
        boolean addCross = crossTexture != null;
        String parentModel = addCross ? "template_cross_cake" : "template_cake";
        String side = ModBlockStateProvider.blockLoc(texturePrefix + "_side");
        String top = ModBlockStateProvider.blockLoc(texturePrefix + "_top");
        String bottom = ModBlockStateProvider.blockLoc(texturePrefix + "_bottom");
        String inside = ModBlockStateProvider.blockLoc(texturePrefix + "_inner");
        if (cake.hasBites()) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(cake);
            BlockModelBuilder modelBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc(parentModel))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
            this.addCrossTexture(modelBuilder, crossTexture);
            builder.partialState().with((Property)BaseCakeBlock.BITES, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelBuilder)});
            for (int i = 1; i < 7; ++i) {
                modelBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_slice" + i, this.modLoc(parentModel + "_slice" + i))).texture("side", side)).texture("top", top)).texture("bottom", bottom)).texture("inside", inside);
                if (i < 4) {
                    this.addCrossTexture(modelBuilder, crossTexture);
                }
                builder.partialState().with((Property)BaseCakeBlock.BITES, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelBuilder)});
            }
        } else {
            BlockModelBuilder modelBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc(parentModel))).texture("side", side)).texture("top", top)).texture("bottom", bottom);
            this.addCrossTexture(modelBuilder, crossTexture);
            this.simpleBlock(cake, (ModelFile)modelBuilder);
        }
    }

    private void createTwoTieredCake(BaseCakeBlock cake, String texturePrefix, String name, @Nullable ResourceLocation crossTexture) {
        boolean addCross = crossTexture != null;
        String parentModel = addCross ? "template_cross_two_tiered_cake" : "template_two_tiered_cake";
        String mediumTop = ModBlockStateProvider.blockLoc(texturePrefix + "_medium_top");
        String mediumSide = ModBlockStateProvider.blockLoc(texturePrefix + "_medium_side");
        String mediumInner = ModBlockStateProvider.blockLoc(texturePrefix + "_medium_inner");
        String top = ModBlockStateProvider.blockLoc(texturePrefix + "_top_covered");
        String side = ModBlockStateProvider.blockLoc(texturePrefix + "_side");
        String inner = ModBlockStateProvider.blockLoc(texturePrefix + "_inner_covered");
        String bottom = ModBlockStateProvider.blockLoc(texturePrefix + "_bottom");
        if (cake.hasBites()) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(cake);
            BlockModelBuilder modelBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc(parentModel))).texture("top", mediumTop)).texture("top_side", mediumSide)).texture("lower_side", side)).texture("lower_top", top)).texture("bottom", bottom);
            this.addCrossTexture(modelBuilder, crossTexture);
            builder.partialState().with((Property)BaseTwoTieredCakeBlock.BITES, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelBuilder)});
            for (int i = 1; i < 11; ++i) {
                modelBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_slice" + i, this.modLoc(parentModel + "_slice" + i))).texture("lower_side", side)).texture("lower_top", top)).texture("bottom", bottom);
                if (i < 5) {
                    ((BlockModelBuilder)((BlockModelBuilder)modelBuilder.texture("top", mediumTop)).texture("top_side", mediumSide)).texture("top_inner", mediumInner);
                }
                if (i > 5) {
                    modelBuilder.texture("lower_inner", inner);
                }
                if (i < 3) {
                    this.addCrossTexture(modelBuilder, crossTexture);
                }
                builder.partialState().with((Property)BaseTwoTieredCakeBlock.BITES, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelBuilder)});
            }
        } else {
            BlockModelBuilder modelBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc(parentModel))).texture("top", mediumTop)).texture("top_side", mediumSide)).texture("lower_side", side)).texture("lower_top", top)).texture("bottom", bottom);
            this.addCrossTexture(modelBuilder, crossTexture);
            this.simpleBlock(cake, (ModelFile)modelBuilder);
        }
    }

    private void createThreeTieredCake(BaseCakeBlock cake, String texturePrefix, String name, @Nullable ResourceLocation crossTexture) {
        boolean addCross = crossTexture != null;
        String parentModel = addCross ? "template_cross_three_tiered_cake" : "template_three_tiered_cake";
        String smallTop = ModBlockStateProvider.blockLoc(texturePrefix + "_small_top");
        String smallSide = ModBlockStateProvider.blockLoc(texturePrefix + "_small_side");
        String smallInner = ModBlockStateProvider.blockLoc(texturePrefix + "_small_inner");
        String mediumTop = ModBlockStateProvider.blockLoc(texturePrefix + "_medium_top_covered");
        String mediumSide = ModBlockStateProvider.blockLoc(texturePrefix + "_medium_side");
        String mediumInner = ModBlockStateProvider.blockLoc(texturePrefix + "_medium_inner_covered");
        String top = ModBlockStateProvider.blockLoc(texturePrefix + "_top_covered");
        String side = ModBlockStateProvider.blockLoc(texturePrefix + "_side");
        String inner = ModBlockStateProvider.blockLoc(texturePrefix + "_inner_covered");
        String bottom = ModBlockStateProvider.blockLoc(texturePrefix + "_bottom");
        VariantBlockStateBuilder builder = this.getVariantBuilder(cake);
        VariantBlockStateBuilder.PartialBlockstate upperBuilder = builder.partialState();
        VariantBlockStateBuilder.PartialBlockstate lowerBuilder = builder.partialState();
        if (cake.hasBites()) {
            BlockModelBuilder modelBuilder;
            int i;
            upperBuilder = upperBuilder.with((Property)BaseThreeTieredCakeBlock.BITES, (Comparable)Integer.valueOf(0));
            lowerBuilder = lowerBuilder.with((Property)BaseThreeTieredCakeBlock.BITES, (Comparable)Integer.valueOf(5));
            for (i = 1; i < 5; ++i) {
                modelBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_upper_slice" + i, this.modLoc(parentModel + "_upper_slice" + i))).texture("top", smallTop)).texture("top_side", smallSide)).texture("top_inner", smallInner)).texture("bottom", bottom);
                if (i < 3) {
                    this.addCrossTexture(modelBuilder, crossTexture);
                }
                builder.partialState().with((Property)BaseThreeTieredCakeBlock.BITES, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelBuilder)});
            }
            for (i = 1; i < 11; ++i) {
                modelBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_lower_slice" + i, this.modLoc(parentModel + "_lower_slice" + i))).texture("lower_top", top)).texture("lower_side", side)).texture("bottom", bottom);
                if (i < 5) {
                    ((BlockModelBuilder)((BlockModelBuilder)modelBuilder.texture("middle_top", mediumTop)).texture("middle_side", mediumSide)).texture("middle_inner", mediumInner);
                } else if (i > 5) {
                    modelBuilder.texture("lower_inner", inner);
                }
                builder.partialState().with((Property)BaseThreeTieredCakeBlock.BITES, (Comparable)Integer.valueOf(i + 5)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelBuilder)});
            }
        } else {
            upperBuilder = upperBuilder.with(BaseThreeTieredCakeBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
            lowerBuilder = lowerBuilder.with(BaseThreeTieredCakeBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        BlockModelBuilder upperModelBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_upper", this.modLoc(parentModel + "_upper"))).texture("top", smallTop)).texture("top_side", smallSide)).texture("bottom", bottom);
        this.addCrossTexture(upperModelBuilder, crossTexture);
        upperBuilder.addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)upperModelBuilder)});
        BlockModelBuilder lowerModelBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_lower", this.modLoc(parentModel + "_lower"))).texture("middle_top", mediumTop)).texture("middle_side", mediumSide)).texture("lower_top", top)).texture("lower_side", side)).texture("bottom", bottom);
        lowerBuilder.addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)lowerModelBuilder)});
    }

    private void addCrossTexture(BlockModelBuilder modelBuilder, @Nullable ResourceLocation texture) {
        if (texture != null) {
            modelBuilder.texture("cross", texture);
        }
    }

    private void createFromVanillaCake(BaseCakeBlock cake, int bites, ResourceLocation parentModel) {
        if (cake.hasBites()) {
            VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(cake);
            variantBuilder.partialState().with((Property)BaseCakeBlock.BITES, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(parentModel))});
            for (int i = 1; i < bites; ++i) {
                variantBuilder.partialState().with((Property)BaseCakeBlock.BITES, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(parentModel.withSuffix("_slice" + i)))});
            }
        } else {
            this.simpleBlock(cake, (ModelFile)this.models().getExistingFile(parentModel));
        }
    }

    private void createFromVanillaCandleCake(VariantBlockStateBuilder.PartialBlockstate partialState, ResourceLocation candleType, String modId, String name, boolean isLit) {
        String litName = isLit ? "_lit" : "";
        partialState.with((Property)AbstractCandleBlock.LIT, (Comparable)Boolean.valueOf(isLit)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)modId, (String)(candleType.getPath() + "candle_" + name + litName))))});
    }

    private void createFromVanillaThreeTieredCandleCake(VariantBlockStateBuilder.PartialBlockstate partialState, ResourceLocation candleType, DoubleBlockHalf half, boolean isLit) {
        String litName = isLit ? "_lit" : "";
        partialState.with((Property)AbstractCandleBlock.LIT, (Comparable)Boolean.valueOf(isLit)).with(BaseThreeTieredCandleCakeBlock.HALF, (Comparable)half).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(this.modLoc(candleType.getPath() + "candle_three_tiered_cake" + String.valueOf(half) + litName)))});
    }

    private static String blockLoc(String string) {
        return "block/" + string;
    }
}

