/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.data.packs.providers;

import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.block.cake.candle.BaseCandleCakeBlock;
import einstein.jmc.data.packs.ModBlockTags;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.registration.CakeVariant;
import einstein.jmc.util.Util;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockTagsProvider
extends BlockTagsProvider {
    public ModBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "jmc", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])new Block[]{ModBlocks.CAKE_OVEN.get(), ModBlocks.CAKE_STAND.get(), ModBlocks.CERAMIC_BOWL.get()});
        ModBlocks.OBSIDIAN_CAKE_FAMILY.forEach(cake -> this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)((Block)cake.get())));
        this.tag(BlockTags.ICE).add((Object)ModBlocks.ENCASING_ICE.get());
        Map<Supplier<BaseCakeBlock>, CakeVariant> sortedCakes = Util.createValueSortedMap(CakeVariant.VARIANT_BY_CAKE, Comparator.comparing(CakeVariant::getCakeName));
        sortedCakes.forEach((cake, variant) -> {
            CakeVariant.Type variantType = variant.getType();
            switch (variantType) {
                case BASE: {
                    this.tag(ModBlockTags.BASE_CAKES).add((Object)((Block)cake.get()));
                    break;
                }
                case TWO_TIERED: {
                    this.tag(ModBlockTags.TWO_TIERED_CAKES).add((Object)((Block)cake.get()));
                    break;
                }
                case THREE_TIERED: {
                    this.tag(ModBlockTags.THREE_TIERED_CAKES).add((Object)((Block)cake.get()));
                }
            }
            Map<Block, Supplier<BaseCandleCakeBlock>> sortedCandleCakes = Util.createKeySortedMap(variant.getCandleCakeByCandle(), Comparator.comparing(o -> o.getName().toString()));
            sortedCandleCakes.forEach((candle, candleCake) -> {
                switch (variantType) {
                    case BASE: {
                        this.tag(ModBlockTags.BASE_CANDLE_CAKES).add((Object)((Block)candleCake.get()));
                        break;
                    }
                    case TWO_TIERED: {
                        this.tag(ModBlockTags.TWO_TIERED_CANDLE_CAKES).add((Object)((Block)candleCake.get()));
                        break;
                    }
                    case THREE_TIERED: {
                        this.tag(ModBlockTags.THREE_TIERED_CANDLE_CAKES).add((Object)((Block)candleCake.get()));
                    }
                }
            });
        });
        this.tag(ModBlockTags.CAKES).addTag(ModBlockTags.BASE_CAKES).addTag(ModBlockTags.TWO_TIERED_CAKES).addTag(ModBlockTags.THREE_TIERED_CAKES);
        this.tag(ModBlockTags.CANDLE_CAKES).addTag(ModBlockTags.BASE_CANDLE_CAKES).addTag(ModBlockTags.TWO_TIERED_CANDLE_CAKES).addTag(ModBlockTags.THREE_TIERED_CANDLE_CAKES);
        this.tag(ModBlockTags.C_CAKES).add((Object)Blocks.CAKE).addTag(ModBlockTags.CAKES);
        this.tag(ModBlockTags.C_CANDLE_CAKES).addTag(ModBlockTags.CANDLE_CAKES).addTag(BlockTags.CANDLE_CAKES);
        this.tag(ModBlockTags.CAKE_SPATULA_USABLE).addTag(ModBlockTags.C_CAKES).addTag(ModBlockTags.C_CANDLE_CAKES);
        this.tag(ModBlockTags.CAKE_STAND_STORABLES).add((Object)Blocks.CAKE).addTag(ModBlockTags.BASE_CAKES);
        this.tag(BlockTags.CANDLE_CAKES).addTag(ModBlockTags.CANDLE_CAKES);
    }
}

