/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.data.packs.providers;

import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.init.ModItems;
import einstein.jmc.registration.CakeVariant;
import einstein.jmc.util.Util;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "jmc", existingFileHelper);
    }

    protected void registerModels() {
        this.generatedItem(this.getItemName(ModItems.CUPCAKE), this.modLoc("item/" + this.getItemName(ModItems.CUPCAKE)));
        this.generatedItem(this.getItemName(ModItems.CREAM_CHEESE), this.modLoc("item/" + this.getItemName(ModItems.CREAM_CHEESE)));
        this.layeredItem(this.getItemName(ModItems.WHISK), this.mcLoc("handheld"), this.modLoc("item/" + this.getItemName(ModItems.WHISK)));
        this.generatedItem(this.getItemName(ModItems.CAKE_DOUGH), this.modLoc("item/" + this.getItemName(ModItems.CAKE_DOUGH)));
        this.generatedItem(this.getItemName(ModItems.CUPCAKE_DOUGH), this.modLoc("item/" + this.getItemName(ModItems.CUPCAKE_DOUGH)));
        this.generatedItem(this.getItemName(ModItems.CAKE_FROSTING), this.modLoc("item/" + this.getItemName(ModItems.CAKE_FROSTING)));
        this.generatedItem(this.getItemName(ModItems.CUPCAKE_FROSTING), this.modLoc("item/" + this.getItemName(ModItems.CUPCAKE_FROSTING)));
        this.generatedItem("poison_cake", this.mcLoc("item/cake"));
        this.generatedItem("tnt_cake", this.mcLoc("item/cake"));
        ((ItemModelBuilder)this.getBuilder("encasing_ice")).parent((ModelFile)this.getExistingFile(this.mcLoc("block/ice")));
        ((ItemModelBuilder)this.getBuilder("cake_oven")).parent((ModelFile)this.getExistingFile(this.modLoc("block/cake_oven")));
        ((ItemModelBuilder)this.getBuilder("cake_stand")).parent((ModelFile)this.getExistingFile(this.modLoc("block/cake_stand")));
        ((ItemModelBuilder)this.getBuilder("ceramic_bowl")).parent((ModelFile)this.getExistingFile(this.modLoc("block/ceramic_bowl")));
        CakeVariant.VARIANT_BY_CAKE.forEach((cake, variant) -> {
            if (variant.hasItem() && !variant.hasCustomItemModel()) {
                this.generatedItem(this.getItemName((Supplier<? extends ItemLike>)cake), this.modLoc("item/" + Util.getItemId(((BaseCakeBlock)cake.get()).asItem()).getPath()));
            }
        });
    }

    private void generatedItem(String name, ResourceLocation ... layers) {
        this.layeredItem(name, this.mcLoc("item/generated"), layers);
    }

    private void layeredItem(String name, ResourceLocation parent, ResourceLocation ... layers) {
        ItemModelBuilder model = (ItemModelBuilder)this.withExistingParent(name, parent);
        for (int i = 0; i < layers.length; ++i) {
            model = (ItemModelBuilder)model.texture("layer" + i, layers[i]);
        }
    }

    private String getItemName(Supplier<? extends ItemLike> item) {
        return Util.getItemId(item.get().asItem()).getPath();
    }
}

