/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.item;

import einstein.jmc.block.cake.BaseThreeTieredCakeBlock;
import einstein.jmc.block.cake.candle.BaseThreeTieredCandleCakeBlock;
import einstein.jmc.data.packs.ModBlockTags;
import einstein.jmc.util.CakeUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CakeSpatulaItem
extends Item {
    public CakeSpatulaItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && player.isShiftKeyDown()) {
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            BlockState state = level.getBlockState(pos);
            ItemStack stack = context.getItemInHand();
            Block block = state.getBlock();
            if (state.is(ModBlockTags.CAKE_SPATULA_USABLE)) {
                if (!CakeUtil.isUneaten(state, pos, level)) {
                    return InteractionResult.PASS;
                }
                if (!level.isClientSide) {
                    if (block instanceof BaseThreeTieredCakeBlock || block instanceof BaseThreeTieredCandleCakeBlock) {
                        CakeUtil.destroyOppositeHalf(state, pos, level, stack, !player.isCreative());
                    }
                    level.destroyBlock(pos, false, (Entity)player);
                    stack.hurtAndBreak(1, (LivingEntity)player, context.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
                    if (!player.isCreative()) {
                        BlockEntity blockEntity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
                        Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)stack);
                    }
                }
                player.awardStat(Stats.BLOCK_MINED.get((Object)block));
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"item.jmc.cake_spatula.desc").withStyle(ChatFormatting.GRAY));
    }
}

