/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.item.crafting;

import einstein.jmc.init.ModBlocks;
import einstein.jmc.init.ModRecipes;
import einstein.jmc.item.crafting.ContainerRecipeInput;
import einstein.jmc.util.CakeOvenConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CakeOvenRecipe
implements Recipe<ContainerRecipeInput>,
CakeOvenConstants {
    protected final ItemStack result;
    protected final float experience;
    protected final int cookingTime;
    protected final NonNullList<Ingredient> ingredients;

    public CakeOvenRecipe(NonNullList<Ingredient> ingredients, ItemStack result, float experience, int cookingTime) {
        this.ingredients = ingredients;
        this.result = result;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    public boolean matches(ContainerRecipeInput input, Level level) {
        StackedContents contents = new StackedContents();
        int stacks = 0;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack;
            if (i == 5 || i == 4 || (stack = input.getItem(i)).isEmpty()) continue;
            ++stacks;
            contents.accountStack(stack, 1);
        }
        return stacks == this.ingredients.size() && contents.canCraft((Recipe)this, null);
    }

    public ItemStack assemble(ContainerRecipeInput input, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int x, int y) {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.CAKE_OVEN_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ModRecipes.CAKE_OVEN_RECIPE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.CAKE_OVEN.get());
    }

    public void consumeIngredients(Container container, NonNullList<ItemStack> remainingItems) {
        for (Ingredient ingredient : this.ingredients) {
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack stack;
                if (i == 5 || i == 4 || (stack = container.getItem(i)).isEmpty() || !ingredient.test(stack)) continue;
                boolean hasRemainingItem = stack.getItem().hasCraftingRemainingItem();
                Item v = stack.getItem().getCraftingRemainingItem();
                ItemStack remainingStack = v == null ? ItemStack.EMPTY : new ItemStack((ItemLike)v);
                int i2 = 0;
                for (int i3 = 0; i3 < remainingItems.size(); ++i3) {
                    ItemStack remainingItem = (ItemStack)remainingItems.get(i3);
                    if (!remainingItem.isEmpty()) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)remainingStack, (ItemStack)remainingItem)) continue;
                        remainingItem.grow(remainingStack.getCount());
                        remainingItems.set(i3, (Object)remainingItem);
                        remainingStack = (ItemStack)remainingItems.get(i3);
                        i2 = i3;
                        break;
                    }
                    remainingItem = remainingStack.copy();
                    remainingItems.set(i3, (Object)remainingItem);
                    remainingStack = (ItemStack)remainingItems.get(i3);
                    i2 = i3;
                    break;
                }
                stack.shrink(1);
                if (stack.isEmpty() && hasRemainingItem) {
                    container.setItem(i, remainingStack.copy());
                    remainingItems.set(i2, (Object)ItemStack.EMPTY);
                    continue;
                }
                if (!stack.isEmpty()) continue;
                container.setItem(i, ItemStack.EMPTY);
            }
        }
    }
}

