/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.item.crafting;

import einstein.jmc.block.entity.CeramicBowlBlockEntity;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.init.ModRecipes;
import einstein.jmc.item.crafting.ContainerRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MixingRecipe
implements Recipe<ContainerRecipeInput> {
    protected final NonNullList<Ingredient> ingredients;
    protected final ItemStack result;
    protected final ResourceLocation contentsId;
    protected final int mixingTime;

    public MixingRecipe(NonNullList<Ingredient> ingredients, ItemStack result, ResourceLocation contentsId, int mixingTime) {
        this.ingredients = ingredients;
        this.result = result;
        this.contentsId = contentsId;
        this.mixingTime = mixingTime;
    }

    public boolean matches(ContainerRecipeInput input, Level level) {
        StackedContents contents = new StackedContents();
        int stacks = 0;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack;
            if (i == 4 || (stack = input.getItem(i)).isEmpty()) continue;
            ++stacks;
            contents.accountStack(stack, 1);
        }
        return stacks == this.ingredients.size() && contents.canCraft((Recipe)this, null);
    }

    public ItemStack assemble(ContainerRecipeInput input, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int x, int y) {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.MIXING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ModRecipes.MIXING_RECIPE.get();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.CERAMIC_BOWL.get());
    }

    public boolean isSpecial() {
        return true;
    }

    public int getMixingTime() {
        return this.mixingTime;
    }

    public ResourceLocation getContentsId() {
        return this.contentsId;
    }

    public void consumeIngredients(CeramicBowlBlockEntity container) {
        for (Ingredient ingredient : this.ingredients) {
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack stack;
                if (i == 4 || (stack = container.getItem(i)).isEmpty() || !ingredient.test(stack)) continue;
                container.setItem(i, ItemStack.EMPTY);
            }
        }
    }
}

