/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.mixin;

import einstein.jmc.block.CakeEffectsHolder;
import einstein.jmc.data.effects.CakeEffects;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.init.ModTriggerTypes;
import einstein.jmc.util.CakeUtil;
import einstein.jmc.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CakeBlock.class})
public class CakeBlockMixin
implements CakeEffectsHolder {
    @Unique
    @Nullable
    private CakeEffects justMoreCakes$cakeEffects;
    @Unique
    private final CakeBlock justMoreCakes$me = (CakeBlock)this;

    @Inject(method={"useItemOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void use(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<ItemInteractionResult> cir) {
        Block block;
        Item item = stack.getItem();
        if (stack.is(ItemTags.CANDLES) && (Integer)state.getValue((Property)CakeBlock.BITES) == 0 && (block = Block.byItem((Item)item)) instanceof CandleBlock) {
            CandleBlock candleBlock = (CandleBlock)block;
            Block.pushEntitiesUp((BlockState)state, (BlockState)CandleCakeBlock.byCandle((CandleBlock)candleBlock), (LevelAccessor)level, (BlockPos)pos);
        }
        if (this.justMoreCakes$me.equals(Blocks.CAKE) && stack.is(Items.CAKE) && CakeUtil.convertToTwoTiered(ModBlocks.VANILLA_CAKE_FAMILY, state, pos, level, player, stack, false).consumesAction()) {
            cir.setReturnValue((Object)ItemInteractionResult.SUCCESS);
        }
    }

    @Inject(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;eat(IF)V")})
    private static void eat(LevelAccessor accessor, BlockPos pos, BlockState state, Player player, CallbackInfoReturnable<InteractionResult> cir) {
        CakeBlock cake = (CakeBlock)state.getBlock();
        CakeEffectsHolder holder = (CakeEffectsHolder)cake;
        CakeEffects cakeEffects = holder.justMoreCakes$getCakeEffects();
        if (!player.level().isClientSide && cakeEffects != null) {
            for (MobEffectInstance instance : cakeEffects.mobEffects()) {
                Util.applyEffect(instance, (LivingEntity)player);
            }
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModTriggerTypes.CAKE_EATEN.get().trigger(serverPlayer, holder);
        }
    }

    @Inject(method={"getAnalogOutputSignal"}, at={@At(value="HEAD")}, cancellable=true)
    private void getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)CakeUtil.getMultipliedSignal(true, 7));
    }

    @Override
    @Nullable
    public CakeEffects justMoreCakes$getCakeEffects() {
        if (this.justMoreCakes$cakeEffects != null) {
            return this.justMoreCakes$cakeEffects;
        }
        if (this.justMoreCakes$me.equals(Blocks.CAKE)) {
            return ModBlocks.VANILLA_CAKE_FAMILY.justMoreCakes$getCakeEffects();
        }
        return null;
    }

    @Override
    public void justMoreCakes$setCakeEffects(CakeEffects effects) {
        this.justMoreCakes$cakeEffects = effects;
    }
}

