/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.registration;

import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.block.cake.BaseThreeTieredCakeBlock;
import einstein.jmc.block.cake.BaseTwoTieredCakeBlock;
import einstein.jmc.block.cake.candle.BaseCandleCakeBlock;
import einstein.jmc.block.cake.candle.BaseThreeTieredCandleCakeBlock;
import einstein.jmc.block.cake.candle.BaseTwoTieredCandleCakeBlock;
import einstein.jmc.data.CakeModel;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.platform.Services;
import einstein.jmc.registration.family.CakeFamily;
import einstein.jmc.util.CakeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.Nullable;

public class CakeVariant {
    public static final Map<Supplier<BaseCakeBlock>, CakeVariant> VARIANT_BY_CAKE = new HashMap<Supplier<BaseCakeBlock>, CakeVariant>();
    private final String cakeName;
    private final Type type;
    private final Map<Block, Supplier<BaseCandleCakeBlock>> candleCakeByCandle = new HashMap<Block, Supplier<BaseCandleCakeBlock>>();
    private boolean canAlwaysEat;
    private boolean allowsCandles = true;
    private boolean noItem = false;
    private boolean customItemModel;
    private int nutrition = 2;
    private float saturationModifier = 0.1f;
    private BlockBehaviour.Properties cakeProperties;
    private BlockBehaviour.Properties candleCakeProperties;
    private CakeModel cakeModel = CakeModel.DEFAULT;
    private CakeModel candleCakeModel = CakeModel.DEFAULT;
    private CakeFamily family;
    private Supplier<BaseCakeBlock> cake;
    private Supplier<Item> item = () -> Items.AIR;

    private CakeVariant(String cakeName, Type type) {
        this.cakeName = cakeName;
        this.type = type;
    }

    public static Builder create(String cakeName) {
        return CakeVariant.create(cakeName, Type.BASE);
    }

    public static Builder create(String cakeName, Type type) {
        return new Builder(cakeName, type);
    }

    public String getCakeName() {
        return this.cakeName;
    }

    public Type getType() {
        return this.type;
    }

    public Map<Block, Supplier<BaseCandleCakeBlock>> getCandleCakeByCandle() {
        return this.candleCakeByCandle;
    }

    public boolean canAlwaysEat() {
        return this.canAlwaysEat;
    }

    public boolean allowsCandles() {
        return this.allowsCandles;
    }

    public boolean hasItem() {
        return !this.noItem;
    }

    public boolean hasCustomItemModel() {
        return this.customItemModel;
    }

    public BlockBehaviour.Properties getCakeProperties() {
        return this.cakeProperties;
    }

    public int getNutrition() {
        return this.nutrition;
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public CakeModel getCakeModel() {
        return this.cakeModel;
    }

    public CakeModel getCandleCakeModel() {
        return this.candleCakeModel;
    }

    @Nullable
    public CakeFamily getFamily() {
        return this.family;
    }

    public Supplier<BaseCakeBlock> getCake() {
        return this.cake;
    }

    public Supplier<Item> getItem() {
        return this.item;
    }

    public static enum Type {
        BASE,
        TWO_TIERED,
        THREE_TIERED;

    }

    public static class Builder {
        private final CakeVariant variant;
        private CakeSupplier<?> cakeSupplier;
        private CandleCakeSupplier<?> candleCakeSupplier;

        private Builder(String cakeName, Type type) {
            this.variant = new CakeVariant(cakeName, type);
        }

        public <T extends BaseCakeBlock> Builder cakeSupplier(CakeSupplier<T> supplier) {
            this.cakeSupplier = supplier;
            return this;
        }

        public <T extends BaseCandleCakeBlock> Builder candleCakeSupplier(CandleCakeSupplier<T> supplier) {
            this.candleCakeSupplier = supplier;
            return this;
        }

        public <T extends BaseCakeBlock, V extends BaseCandleCakeBlock> Builder bothSuppliers(CakeSupplier<T> cakeSupplier, CandleCakeSupplier<V> candleCakeSupplier) {
            this.cakeSupplier = cakeSupplier;
            this.candleCakeSupplier = candleCakeSupplier;
            return this;
        }

        public Builder cakeProperties(BlockBehaviour.Properties properties) {
            this.variant.cakeProperties = properties;
            return this;
        }

        public Builder candleCakeProperties(BlockBehaviour.Properties properties) {
            this.variant.candleCakeProperties = properties;
            return this;
        }

        public Builder alwaysEat() {
            this.variant.canAlwaysEat = true;
            return this;
        }

        public Builder disallowCandles() {
            this.variant.allowsCandles = false;
            return this;
        }

        public Builder noItem() {
            this.variant.noItem = true;
            return this;
        }

        public Builder customItemModel() {
            this.variant.customItemModel = true;
            return this;
        }

        public Builder nutrition(int nutrition) {
            this.variant.nutrition = nutrition;
            return this;
        }

        public Builder saturationModifier(float modifier) {
            this.variant.saturationModifier = modifier;
            return this;
        }

        public Builder model(CakeModel cakeModel) {
            return this.models(cakeModel, CakeModel.DEFAULT);
        }

        public Builder models(CakeModel cakeModel, CakeModel candleCakeModel) {
            this.variant.cakeModel = cakeModel;
            this.variant.candleCakeModel = candleCakeModel;
            return this;
        }

        public Builder setFamily(CakeFamily family) {
            this.variant.family = family;
            return this;
        }

        public CakeVariant build() {
            if (this.cakeSupplier == null) {
                switch (this.variant.type.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        CakeSupplier<BaseCakeBlock> cakeSupplier = BaseCakeBlock::new;
                        break;
                    }
                    case 1: {
                        CakeSupplier<BaseCakeBlock> cakeSupplier = BaseTwoTieredCakeBlock::new;
                        break;
                    }
                    case 2: {
                        CakeSupplier<BaseCakeBlock> cakeSupplier = this.cakeSupplier = BaseThreeTieredCakeBlock::new;
                    }
                }
            }
            if (this.variant.cakeProperties == null) {
                this.variant.cakeProperties = ModBlocks.cakeProperties();
            }
            Supplier<BaseCakeBlock> cake = Services.REGISTRY.registerBlockNoItem(this.variant.cakeName, () -> this.cakeSupplier.create(this.variant));
            if (this.variant.hasItem()) {
                this.variant.item = Services.REGISTRY.registerItem(this.variant.cakeName, () -> new BlockItem((Block)cake.get(), new Item.Properties()));
            }
            if (this.variant.allowsCandles) {
                if (this.candleCakeSupplier == null) {
                    switch (this.variant.type.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            CandleCakeSupplier<BaseCandleCakeBlock> candleCakeSupplier = BaseCandleCakeBlock::new;
                            break;
                        }
                        case 1: {
                            CandleCakeSupplier<BaseCandleCakeBlock> candleCakeSupplier = BaseTwoTieredCandleCakeBlock::new;
                            break;
                        }
                        case 2: {
                            CandleCakeSupplier<BaseCandleCakeBlock> candleCakeSupplier = this.candleCakeSupplier = BaseThreeTieredCandleCakeBlock::new;
                        }
                    }
                }
                if (this.variant.candleCakeProperties == null) {
                    this.variant.candleCakeProperties = ModBlocks.candleCakeProperties();
                }
                for (Block candle : CakeUtil.SUPPORTED_CANDLES.keySet()) {
                    String type = CakeUtil.SUPPORTED_CANDLES.get(candle).getPath();
                    Supplier<BaseCandleCakeBlock> candleCake = Services.REGISTRY.registerBlockNoItem(type + "candle_" + this.variant.cakeName, () -> this.candleCakeSupplier.create((BaseCakeBlock)cake.get(), candle, this.variant.candleCakeProperties));
                    this.variant.candleCakeByCandle.put(candle, candleCake);
                }
            }
            this.variant.cake = cake;
            VARIANT_BY_CAKE.put(cake, this.variant);
            return this.variant;
        }
    }

    @FunctionalInterface
    public static interface CandleCakeSupplier<T extends BaseCandleCakeBlock> {
        public T create(BaseCakeBlock var1, Block var2, BlockBehaviour.Properties var3);
    }

    @FunctionalInterface
    public static interface CakeSupplier<T extends BaseCakeBlock> {
        public T create(CakeVariant var1);
    }
}

