/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.registration.family;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import einstein.jmc.block.CakeEffectsHolder;
import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.data.CakeModel;
import einstein.jmc.data.effects.CakeEffects;
import einstein.jmc.registration.CakeVariant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class CakeFamily
implements CakeEffectsHolder {
    public static final Map<ResourceLocation, CakeFamily> REGISTERED_CAKE_FAMILIES = new HashMap<ResourceLocation, CakeFamily>();
    public static final Codec<CakeFamily> CODEC = ResourceLocation.CODEC.flatXmap(key -> {
        if (REGISTERED_CAKE_FAMILIES.containsKey(key)) {
            return DataResult.success((Object)REGISTERED_CAKE_FAMILIES.get(key));
        }
        return DataResult.error(() -> "Could not find cake family with registry key: {" + String.valueOf(key) + "}");
    }, family -> DataResult.success((Object)family.getRegistryKey()));
    private final ResourceLocation registryKey;
    private final String baseCakeName;
    @Nullable
    protected CakeVariant baseVariant;
    protected CakeVariant twoTieredVariant;
    protected CakeVariant threeTieredVariant;
    protected Supplier<BaseCakeBlock> baseCake;
    protected Supplier<BaseCakeBlock> twoTieredCake;
    protected Supplier<BaseCakeBlock> threeTieredCake;
    protected int nutrition = 2;
    protected float saturationModifier = 0.1f;
    protected boolean canAlwaysEat;
    protected CakeModel cakeModel = CakeModel.DEFAULT;
    protected CakeModel candleCakeModel = CakeModel.DEFAULT;
    @Nullable
    protected CakeEffects cakeEffects;

    public CakeFamily(ResourceLocation registryKey, String baseCakeName) {
        this.registryKey = registryKey;
        this.baseCakeName = baseCakeName;
    }

    public final ResourceLocation getRegistryKey() {
        return this.registryKey;
    }

    public String getBaseCakeName() {
        return this.baseCakeName;
    }

    @Nullable
    public CakeVariant getBaseVariant() {
        return this.baseVariant;
    }

    public CakeVariant getTwoTieredVariant() {
        return this.twoTieredVariant;
    }

    public CakeVariant getThreeTieredVariant() {
        return this.threeTieredVariant;
    }

    public Supplier<? extends Block> getBaseCake() {
        return this.baseCake;
    }

    public Supplier<BaseCakeBlock> getTwoTieredCake() {
        return this.twoTieredCake;
    }

    public Supplier<BaseCakeBlock> getThreeTieredCake() {
        return this.threeTieredCake;
    }

    public int getNutrition() {
        return this.nutrition;
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public CakeModel getCakeModel() {
        return this.cakeModel;
    }

    public CakeModel getCandleCakeModel() {
        return this.candleCakeModel;
    }

    public void forEach(Consumer<Supplier<BaseCakeBlock>> consumer) {
        consumer.accept(this.baseCake);
        consumer.accept(this.twoTieredCake);
        consumer.accept(this.threeTieredCake);
    }

    public Supplier<Item> getBaseItem() {
        if (this.baseVariant != null) {
            return this.baseVariant.getItem();
        }
        return () -> Items.AIR;
    }

    @Override
    @Nullable
    public CakeEffects justMoreCakes$getCakeEffects() {
        return this.cakeEffects;
    }

    @Override
    public void justMoreCakes$setCakeEffects(@Nullable CakeEffects effects) {
        this.cakeEffects = effects;
    }

    public String toString() {
        return "CakeFamily{" + String.valueOf(this.getRegistryKey()) + "}";
    }

    protected static abstract class Builder<T extends CakeFamily> {
        protected final T family;
        protected final CakeVariant.Builder baseVariantBuilder;
        protected final CakeVariant.Builder twoTieredVariantBuilder;
        protected final CakeVariant.Builder threeTieredVariantBuilder;

        protected Builder(T family) {
            this.family = family;
            this.baseVariantBuilder = CakeVariant.create(((CakeFamily)family).getBaseCakeName()).setFamily((CakeFamily)family);
            this.twoTieredVariantBuilder = CakeVariant.create("two_tiered_" + ((CakeFamily)family).getBaseCakeName(), CakeVariant.Type.TWO_TIERED).setFamily((CakeFamily)family);
            this.threeTieredVariantBuilder = CakeVariant.create("three_tiered_" + ((CakeFamily)family).getBaseCakeName(), CakeVariant.Type.THREE_TIERED).setFamily((CakeFamily)family);
        }

        public T build() {
            if (((CakeFamily)this.family).baseVariant != null) {
                ((CakeFamily)this.family).baseCake = ((CakeFamily)this.family).baseVariant.getCake();
            }
            ((CakeFamily)this.family).twoTieredCake = ((CakeFamily)this.family).twoTieredVariant.getCake();
            ((CakeFamily)this.family).threeTieredCake = ((CakeFamily)this.family).threeTieredVariant.getCake();
            REGISTERED_CAKE_FAMILIES.put(((CakeFamily)this.family).getRegistryKey(), (CakeFamily)this.family);
            return this.family;
        }
    }
}

