/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import einstein.jmc.JustMoreCakes;
import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.block.cake.BaseThreeTieredCakeBlock;
import einstein.jmc.block.cake.candle.BaseThreeTieredCandleCakeBlock;
import einstein.jmc.init.ModCommonConfigs;
import einstein.jmc.registration.CakeVariant;
import einstein.jmc.registration.family.CakeFamily;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class CakeUtil {
    public static final int DEFAULT_NUTRITION = 2;
    public static final float DEFAULT_SATURATION_MODIFIER = 0.1f;
    public static final ImmutableMap<Block, Block> VANILLA_CANDLE_CAKES_BY_CANDLE = new ImmutableMap.Builder().put((Object)Blocks.CANDLE, (Object)Blocks.CANDLE_CAKE).put((Object)Blocks.WHITE_CANDLE, (Object)Blocks.WHITE_CANDLE_CAKE).put((Object)Blocks.ORANGE_CANDLE, (Object)Blocks.ORANGE_CANDLE_CAKE).put((Object)Blocks.MAGENTA_CANDLE, (Object)Blocks.MAGENTA_CANDLE_CAKE).put((Object)Blocks.LIGHT_BLUE_CANDLE, (Object)Blocks.LIGHT_BLUE_CANDLE_CAKE).put((Object)Blocks.YELLOW_CANDLE, (Object)Blocks.YELLOW_CANDLE_CAKE).put((Object)Blocks.LIME_CANDLE, (Object)Blocks.LIME_CANDLE_CAKE).put((Object)Blocks.PINK_CANDLE, (Object)Blocks.PINK_CANDLE_CAKE).put((Object)Blocks.GRAY_CANDLE, (Object)Blocks.GRAY_CANDLE_CAKE).put((Object)Blocks.LIGHT_GRAY_CANDLE, (Object)Blocks.LIGHT_GRAY_CANDLE_CAKE).put((Object)Blocks.CYAN_CANDLE, (Object)Blocks.CYAN_CANDLE_CAKE).put((Object)Blocks.PURPLE_CANDLE, (Object)Blocks.PURPLE_CANDLE_CAKE).put((Object)Blocks.BLUE_CANDLE, (Object)Blocks.BLUE_CANDLE_CAKE).put((Object)Blocks.BROWN_CANDLE, (Object)Blocks.BROWN_CANDLE_CAKE).put((Object)Blocks.GREEN_CANDLE, (Object)Blocks.GREEN_CANDLE_CAKE).put((Object)Blocks.RED_CANDLE, (Object)Blocks.RED_CANDLE_CAKE).put((Object)Blocks.BLACK_CANDLE, (Object)Blocks.BLACK_CANDLE_CAKE).buildOrThrow();
    public static final Map<Block, ResourceLocation> SUPPORTED_CANDLES = (Map)Util.make(new HashMap(), map -> {
        map.put(Blocks.CANDLE, JustMoreCakes.mcLoc(""));
        map.put(Blocks.WHITE_CANDLE, JustMoreCakes.mcLoc("white_"));
        map.put(Blocks.ORANGE_CANDLE, JustMoreCakes.mcLoc("orange_"));
        map.put(Blocks.MAGENTA_CANDLE, JustMoreCakes.mcLoc("magenta_"));
        map.put(Blocks.LIGHT_BLUE_CANDLE, JustMoreCakes.mcLoc("light_blue_"));
        map.put(Blocks.YELLOW_CANDLE, JustMoreCakes.mcLoc("yellow_"));
        map.put(Blocks.LIME_CANDLE, JustMoreCakes.mcLoc("lime_"));
        map.put(Blocks.PINK_CANDLE, JustMoreCakes.mcLoc("pink_"));
        map.put(Blocks.GRAY_CANDLE, JustMoreCakes.mcLoc("gray_"));
        map.put(Blocks.LIGHT_GRAY_CANDLE, JustMoreCakes.mcLoc("light_gray_"));
        map.put(Blocks.CYAN_CANDLE, JustMoreCakes.mcLoc("cyan_"));
        map.put(Blocks.PURPLE_CANDLE, JustMoreCakes.mcLoc("purple_"));
        map.put(Blocks.BLUE_CANDLE, JustMoreCakes.mcLoc("blue_"));
        map.put(Blocks.BROWN_CANDLE, JustMoreCakes.mcLoc("brown_"));
        map.put(Blocks.GREEN_CANDLE, JustMoreCakes.mcLoc("green_"));
        map.put(Blocks.RED_CANDLE, JustMoreCakes.mcLoc("red_"));
        map.put(Blocks.BLACK_CANDLE, JustMoreCakes.mcLoc("black_"));
    });

    public static boolean inFamily(BlockState state, CakeFamily family) {
        Block block = state.getBlock();
        return block.equals(family.getBaseCake().get()) || block.equals(family.getTwoTieredCake().get()) || block.equals(family.getThreeTieredCake().get());
    }

    public static boolean isUneaten(BlockState state, BlockPos pos, Level level) {
        BaseCakeBlock cakeBlock;
        Block block = state.getBlock();
        if (block instanceof BaseThreeTieredCakeBlock) {
            BaseThreeTieredCakeBlock threeTieredCakeBlock = (BaseThreeTieredCakeBlock)block;
            if (state.getValue(BaseThreeTieredCakeBlock.HALF) == DoubleBlockHalf.UPPER) {
                return CakeUtil.isUneaten(state, threeTieredCakeBlock);
            }
            BlockState aboveState = level.getBlockState(pos.above());
            Block block2 = aboveState.getBlock();
            if (block2 instanceof BaseThreeTieredCakeBlock) {
                BaseThreeTieredCakeBlock aboveThreeTieredCakeBlock = (BaseThreeTieredCakeBlock)block2;
                if (aboveState.getValue(BaseThreeTieredCakeBlock.HALF) == DoubleBlockHalf.UPPER) {
                    return CakeUtil.isUneaten(aboveState, aboveThreeTieredCakeBlock);
                }
            }
            return false;
        }
        if (block instanceof BaseCakeBlock && (cakeBlock = (BaseCakeBlock)block).hasBites()) {
            return CakeUtil.isUneaten(state, cakeBlock);
        }
        return !(block instanceof CakeBlock) || (Integer)state.getValue((Property)CakeBlock.BITES) == 0;
    }

    private static boolean isUneaten(BlockState state, BaseCakeBlock cakeBlock) {
        return cakeBlock.getSlices() <= 0 || (Integer)state.getValue((Property)cakeBlock.getBites()) == 0;
    }

    public static int getComparatorOutput(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof BaseCakeBlock) {
            BaseCakeBlock cakeBlock = (BaseCakeBlock)block;
            if (cakeBlock.hasBites()) {
                return CakeUtil.getMultipliedSignal(cakeBlock.isBaseVariant(), cakeBlock.getSlices() + 1 - (Integer)state.getValue((Property)cakeBlock.getBites()));
            }
            CakeVariant.Type variant = cakeBlock.getVariant().getType();
            boolean bl = cakeBlock.isBaseVariant();
            return CakeUtil.getMultipliedSignal(bl, switch (variant) {
                default -> throw new MatchException(null, null);
                case CakeVariant.Type.BASE -> 7;
                case CakeVariant.Type.TWO_TIERED -> 11;
                case CakeVariant.Type.THREE_TIERED -> 16;
            });
        }
        return 0;
    }

    public static int getMultipliedSignal(boolean isBaseVariant, int signal) {
        return signal * ((Boolean)ModCommonConfigs.DOUBLE_BASE_CAKE_COMPARATOR_OUTPUT.get() != false && isBaseVariant ? 2 : 1);
    }

    public static BlockState createLowerState(Block block, boolean hasBites) {
        BaseCakeBlock cakeBlock;
        BlockState newState = (BlockState)block.defaultBlockState().setValue(BaseThreeTieredCakeBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
        if (hasBites && (cakeBlock = (BaseCakeBlock)block).hasBites()) {
            newState = (BlockState)newState.setValue((Property)cakeBlock.getBites(), (Comparable)Integer.valueOf(5));
        }
        return newState;
    }

    public static void destroyOppositeHalf(BlockState state, BlockPos pos, Level level, ItemStack toolStack, boolean dropResources) {
        boolean isLower = state.getValue(BaseThreeTieredCakeBlock.HALF) == DoubleBlockHalf.LOWER;
        BlockPos otherPos = isLower ? pos.above() : pos.below();
        BlockState otherState = level.getBlockState(otherPos);
        if (otherState.is(state.getBlock()) && otherState.getValue(BaseThreeTieredCakeBlock.HALF) == (isLower ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER)) {
            level.setBlock(otherPos, Blocks.AIR.defaultBlockState(), 19);
            level.levelEvent(2001, otherPos, Block.getId((BlockState)otherState));
            otherState.updateNeighbourShapes((LevelAccessor)level, otherPos, 2, 511);
            otherState.updateIndirectNeighbourShapes((LevelAccessor)level, otherPos, 2, 511);
            if (dropResources) {
                BlockEntity otherBlockEntity = otherState.hasBlockEntity() ? level.getBlockEntity(otherPos) : null;
                Block.dropResources((BlockState)otherState, (Level)level, (BlockPos)otherPos, (BlockEntity)otherBlockEntity, null, (ItemStack)toolStack);
            }
        }
    }

    public static InteractionResult convertToThreeTiered(CakeFamily family, BlockState state, BlockPos pos, Level level, Player player, ItemStack stack, boolean ignoreUneaten) {
        BlockPos abovePos;
        if ((ignoreUneaten || CakeUtil.isUneaten(state, pos, level)) && level.getBlockState(abovePos = pos.above()).canBeReplaced()) {
            BlockState newState = family.getThreeTieredCake().get().defaultBlockState();
            level.setBlockAndUpdate(abovePos, newState);
            level.setBlockAndUpdate(pos, CakeUtil.createLowerState(newState.getBlock(), true));
            Block.pushEntitiesUp((BlockState)Blocks.AIR.defaultBlockState(), (BlockState)newState, (LevelAccessor)level, (BlockPos)abovePos);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, abovePos);
            level.playSound(null, abovePos, newState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult convertToTwoTiered(CakeFamily family, BlockState state, BlockPos pos, Level level, Player player, ItemStack stack, boolean ignoreUneaten) {
        if (ignoreUneaten || CakeUtil.isUneaten(state, pos, level)) {
            BlockState newState = family.getTwoTieredCake().get().defaultBlockState();
            level.setBlockAndUpdate(pos, newState);
            Block.pushEntitiesUp((BlockState)state, (BlockState)newState, (LevelAccessor)level, (BlockPos)pos);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            level.playSound(null, pos, newState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static ImmutableList<Block> getVanillaCandleCakes() {
        return VANILLA_CANDLE_CAKES_BY_CANDLE.values().asList();
    }

    public static <T> T redirectUse(Block block, BlockState state, Level level, BlockPos pos, BiFunction<BlockState, BlockPos, T> aboveResult, Supplier<T> superResult) {
        BlockPos abovePos;
        BlockState aboveState;
        if (state.getValue(BaseThreeTieredCandleCakeBlock.HALF) == DoubleBlockHalf.LOWER && (aboveState = level.getBlockState(abovePos = pos.above())).is(block) && aboveState.getValue(BaseThreeTieredCandleCakeBlock.HALF) == DoubleBlockHalf.UPPER) {
            return aboveResult.apply(aboveState, abovePos);
        }
        return superResult.get();
    }
}

