/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.TFPlantBlock;

public class PatchBlock
extends TFPlantBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final MapCodec<PatchBlock> CODEC = PatchBlock.simpleCodec(PatchBlock::new);
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(directionPropertyPair -> ((Direction)directionPropertyPair.getKey()).getAxis().isHorizontal()).collect(Util.toMap());

    public PatchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape shapeFromLong(BlockState state, long seed) {
        boolean xConnect0 = (Boolean)state.getValue((Property)EAST);
        boolean xConnect1 = (Boolean)state.getValue((Property)WEST);
        boolean zConnect0 = (Boolean)state.getValue((Property)SOUTH);
        boolean zConnect1 = (Boolean)state.getValue((Property)NORTH);
        int xOff0 = (int)(seed >> 12 & 3L);
        int xOff1 = (int)(seed >> 15 & 3L);
        int zOff0 = (int)(seed >> 18 & 3L);
        int zOff1 = (int)(seed >> 21 & 3L);
        return Block.box((double)(xConnect1 ? 0.0 : (double)(1.0f + (float)xOff1)), (double)0.0, (double)(zConnect1 ? 0.0 : (double)(1.0f + (float)zOff1)), (double)(xConnect0 ? 16.0 : (double)(15.0f - (float)xOff0)), (double)1.0, (double)(zConnect0 ? 16.0 : (double)(15.0f - (float)zOff0)));
    }

    public static VoxelShape shapeFromRandom(BlockState state, Random random) {
        return PatchBlock.shapeFromLong(state, random.nextLong());
    }

    public static VoxelShape shapeFromPos(BlockState state, BlockPos pos) {
        return PatchBlock.shapeFromRandom(state, new Random(state.getSeed(pos)));
    }

    public static BoundingBox AABBFromLong(long seed) {
        int xOff0 = (int)(seed >> 12 & 3L);
        int xOff1 = (int)(seed >> 15 & 3L);
        int zOff0 = (int)(seed >> 18 & 3L);
        int zOff1 = (int)(seed >> 21 & 3L);
        int x0 = 1 + xOff1;
        int z0 = 1 + zOff1;
        int x1 = 15 - xOff0;
        int z1 = 15 - zOff0;
        return new BoundingBox(x0, 0, z0, x1, 1, z1);
    }

    public static BoundingBox AABBFromRandom(RandomSource random) {
        return PatchBlock.AABBFromLong(random.nextLong());
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighborUpdated, LevelAccessor accessor, BlockPos pos, BlockPos posNeighbor) {
        return dir.getAxis().isHorizontal() ? (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(dir), (Comparable)Boolean.valueOf(neighborUpdated.getBlock() == this)) : super.updateShape(state, dir, neighborUpdated, accessor, pos, posNeighbor);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return PatchBlock.shapeFromPos(state, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST});
    }
}

