/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.block.BuilderBlock;
import twilightforest.init.TFSounds;

public class TranslucentBuiltBlock
extends Block {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public TranslucentBuiltBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            level.removeBlock(pos, false);
            level.playSound(null, pos, (SoundEvent)TFSounds.BUILDER_REPLACE.get(), SoundSource.BLOCKS, 0.3f, 0.5f);
            for (Direction e : Direction.values()) {
                BuilderBlock.activateBuiltBlocks((Level)level, pos.relative(e));
            }
        }
    }
}

