/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.event;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import twilightforest.TwilightForestMod;
import twilightforest.beanification.Autowired;
import twilightforest.block.TFPortalBlock;
import twilightforest.components.entity.FortificationShieldAttachment;
import twilightforest.components.entity.TFPortalAttachment;
import twilightforest.components.item.OreScannerData;
import twilightforest.config.TFConfig;
import twilightforest.entity.passive.QuestRam;
import twilightforest.entity.passive.quest.ram.QuestingRamCurrentContext;
import twilightforest.events.HostileMountEvents;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFItems;
import twilightforest.item.OreMeterItem;
import twilightforest.util.ComponentAlignment;

public class OverlayHandler {
    private static final ResourceLocation QUESTING_RAM_CHECK_SPRITE = TwilightForestMod.prefix("questing_ram_check");
    private static final ResourceLocation QUESTING_RAM_X_SPRITE = TwilightForestMod.prefix("questing_ram_x");
    private static final ResourceLocation FORTIFICATION_SHIELD_SPRITE = TwilightForestMod.prefix("fortification_shield");
    public static final Map<Long, OreMeterInfoCache> ORE_METER_STAT_CACHE = new HashMap<Long, OreMeterInfoCache>();
    @Autowired(dist={Dist.CLIENT})
    private static QuestingRamCurrentContext questingRamCurrentContext;
    private static final DecimalFormat FORMAT;

    protected static void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, TwilightForestMod.prefix("quest_ram_indicator"), (graphics, partialTicks) -> {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            Gui gui = minecraft.gui;
            if (player != null && !minecraft.options.hideGui && TFConfig.showQuestRamCrosshairIndicator) {
                RenderSystem.enableBlend();
                OverlayHandler.renderIndicator(minecraft, graphics, gui, (Player)player, graphics.guiWidth(), graphics.guiHeight());
                RenderSystem.disableBlend();
            }
        });
        event.registerAbove(VanillaGuiLayers.VEHICLE_HEALTH, TwilightForestMod.prefix("hostile_mount_hunger_bar"), (graphics, partialTicks) -> {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            Gui gui = minecraft.gui;
            if (!minecraft.options.hideGui && minecraft.gameMode.canHurtPlayer() && player != null && HostileMountEvents.isRidingUnfriendly((LivingEntity)player)) {
                int xPos = graphics.guiWidth() / 2 + 91;
                int yPos = graphics.guiHeight() - gui.rightHeight;
                gui.renderFood(graphics, (Player)player, yPos, xPos);
                gui.rightHeight += 10;
            }
        });
        event.registerAboveAll(TwilightForestMod.prefix("ore_meter_stats"), (graphics, partialTicks) -> {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            Gui gui = minecraft.gui;
            if (player != null && !minecraft.options.hideGui && !gui.getDebugOverlay().showDebugScreen() && minecraft.screen == null) {
                OverlayHandler.renderOreMeterStats(graphics, (Player)player);
            }
        });
        event.registerAbove(VanillaGuiLayers.ARMOR_LEVEL, TwilightForestMod.prefix("fortification_shield_count"), (graphics, partialTick) -> {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            Gui gui = minecraft.gui;
            if (player != null && !minecraft.options.hideGui && (minecraft.gameMode.canHurtPlayer() || TFConfig.showFortificationShieldIndicatorInCreative) && player.hasData(TFDataAttachments.FORTIFICATION_SHIELDS) && ((FortificationShieldAttachment)player.getData(TFDataAttachments.FORTIFICATION_SHIELDS)).shieldsLeft() > 0 && TFConfig.showFortificationShieldIndicator) {
                OverlayHandler.renderShieldCount(graphics, gui, graphics.guiWidth(), graphics.guiHeight(), ((FortificationShieldAttachment)player.getData(TFDataAttachments.FORTIFICATION_SHIELDS)).shieldsLeft());
            }
        });
        event.registerAboveAll(TwilightForestMod.prefix("portal_overlay"), (graphics, partialTick) -> {
            TFPortalAttachment portal;
            Minecraft minecraft = Minecraft.getInstance();
            Window window = minecraft.getWindow();
            LocalPlayer player = minecraft.player;
            if (player != null && (portal = (TFPortalAttachment)player.getData(TFDataAttachments.TF_PORTAL_COOLDOWN)).getPortalTimer() > 0) {
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                graphics.setColor(1.0f, 1.0f, 1.0f, (float)portal.getPortalTimer() / (float)TFPortalAttachment.MAX_TICKS);
                TextureAtlasSprite textureatlassprite = minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(((TFPortalBlock)((Object)((Object)TFBlocks.TWILIGHT_PORTAL.get()))).defaultBlockState());
                graphics.blit(0, 0, -90, window.getGuiScaledWidth(), window.getGuiScaledHeight(), textureatlassprite);
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
        });
    }

    private static void renderIndicator(Minecraft minecraft, GuiGraphics graphics, Gui gui, Player player, int screenWidth, int screenHeight) {
        Entity entity;
        if (minecraft.options.getCameraType().isFirstPerson() && (minecraft.gameMode.getPlayerMode() != GameType.SPECTATOR || gui.canRenderCrosshairForSpectator(minecraft.hitResult)) && (entity = minecraft.crosshairPickEntity) instanceof QuestRam) {
            QuestRam ram = (QuestRam)entity;
            ItemStack stack = player.getInventory().getItem(player.getInventory().selected);
            if (!stack.isEmpty()) {
                for (Map.Entry<DyeColor, Ingredient> questEntry : questingRamCurrentContext.getContext().questItems().entrySet()) {
                    if (!questEntry.getValue().test(stack)) continue;
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    int j = (screenHeight - 1) / 2 - 11;
                    int k = (screenWidth - 1) / 2 - 3;
                    if (!ram.isColorPresent(questEntry.getKey())) {
                        graphics.blitSprite(QUESTING_RAM_X_SPRITE, k, j, 7, 7);
                    } else {
                        graphics.blitSprite(QUESTING_RAM_CHECK_SPRITE, k, j, 7, 7);
                    }
                    RenderSystem.defaultBlendFunc();
                    break;
                }
            }
        }
    }

    private static void renderShieldCount(GuiGraphics graphics, Gui gui, int screenWidth, int screenHeight, int shieldCount) {
        for (int i = 0; i < Math.min(shieldCount, 10); ++i) {
            graphics.blitSprite(FORTIFICATION_SHIELD_SPRITE, screenWidth / 2 - 91 + i * 8, screenHeight - gui.leftHeight, 9, 9);
        }
        gui.leftHeight += 10;
    }

    private static void renderOreMeterStats(GuiGraphics graphics, Player player) {
        if (player.isHolding((Item)TFItems.ORE_METER.get())) {
            InteractionHand handToUse = player.getItemInHand(InteractionHand.MAIN_HAND).is((Item)TFItems.ORE_METER.get()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            ItemStack selectedMeter = player.getItemInHand(handToUse);
            if (OreMeterItem.isLoading(selectedMeter)) {
                int dots = OreMeterItem.getLoadProgress(selectedMeter) / 5 % 3;
                MutableComponent component = Component.translatable((String)"misc.twilightforest.ore_meter_loading");
                for (int i = 0; i <= dots; ++i) {
                    component = component.copy().append(".");
                }
                graphics.fill(0, 0, 56, 16, -1694498816);
                graphics.drawString(Minecraft.getInstance().font, (Component)component, 4, 4, 0xFFFFFF, false);
            } else {
                OreMeterInfoCache info;
                OreScannerData oreScannerData = (OreScannerData)selectedMeter.get(TFDataComponents.ORE_DATA);
                if (oreScannerData == null) {
                    return;
                }
                long identifier = oreScannerData.universalId();
                if (identifier != 0L && !ORE_METER_STAT_CACHE.containsKey(identifier)) {
                    OverlayHandler.initTooltips(identifier, (Integer)selectedMeter.getOrDefault(TFDataComponents.ORE_RANGE, (Object)1), oreScannerData);
                }
                if (ORE_METER_STAT_CACHE.containsKey(identifier) && (info = ORE_METER_STAT_CACHE.get(identifier)) != null) {
                    info.renderData(graphics);
                }
            }
        }
    }

    private static void initTooltips(long id, int range, OreScannerData data) {
        ChunkPos pos = data.scannedChunk();
        int totalScanned = data.totalScannedBlocks();
        ImmutableList headerRowTexts = ImmutableList.of((Object)Component.translatable((String)"misc.twilightforest.ore_meter_range", (Object[])new Object[]{range, pos.x, pos.z}), (Object)Component.translatable((String)"misc.twilightforest.ore_meter_total", (Object[])new Object[]{totalScanned}));
        ArrayList<ComponentColumn> columns = new ArrayList<ComponentColumn>();
        List<Pair<String, Integer>> scanData = data.counts().entrySet().stream().map(e -> Pair.of((Object)((String)e.getKey()), (Object)((Integer)e.getValue()))).sorted(Comparator.comparing(Pair::getSecond)).toList();
        if (TFConfig.prettifyOreMeterGui) {
            ComponentColumn padding = ComponentColumn.padding(1);
            List<Integer> counts = scanData.stream().map(Pair::getSecond).toList();
            columns.add(OverlayHandler.nameColumn(scanData.stream().map(Pair::getFirst).toList()));
            columns.add(padding);
            columns.add(OverlayHandler.dashColumn(scanData.size()));
            columns.add(padding);
            columns.add(OverlayHandler.countColumn(counts));
            columns.add(padding);
            columns.add(OverlayHandler.ratioColumn(totalScanned, counts));
        } else {
            columns.add(OverlayHandler.withoutPrettyPrinting(totalScanned, scanData));
        }
        ORE_METER_STAT_CACHE.put(id, OreMeterInfoCache.build((List<Component>)headerRowTexts, columns));
    }

    private static ComponentColumn withoutPrettyPrinting(int totalScanned, List<Pair<String, Integer>> entries) {
        ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
        for (Pair<String, Integer> entry : entries) {
            String percentage = FORMAT.format((float)((Integer)entry.getSecond()).intValue() * 100.0f / (float)totalScanned);
            MutableComponent formattedEntry = Component.translatable((String)((String)entry.getFirst())).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)"misc.twilightforest.ore_meter_separator")).append((Component)Component.literal((String)(" " + String.valueOf(entry.getSecond()) + " "))).append((Component)Component.translatable((String)"misc.twilightforest.ore_meter_ratio", (Object[])new Object[]{percentage}));
            tooltips.add(formattedEntry);
        }
        return ComponentColumn.build(tooltips, ComponentAlignment.LEFT);
    }

    private static ComponentColumn nameColumn(List<String> oreNameKeys) {
        ImmutableList.Builder toList = ImmutableList.builder();
        toList.add((Object)Component.translatable((String)"misc.twilightforest.ore_meter_header_block").withStyle(ChatFormatting.GRAY));
        for (String oreNameKey : oreNameKeys) {
            MutableComponent translatable = Component.translatable((String)oreNameKey);
            toList.add((Object)translatable);
        }
        return ComponentColumn.build((List<? extends Component>)toList.build(), ComponentAlignment.LEFT);
    }

    private static ComponentColumn dashColumn(int size) {
        ImmutableList.Builder toList = ImmutableList.builder();
        toList.add((Object)Component.empty());
        MutableComponent dash = Component.translatable((String)"misc.twilightforest.ore_meter_separator");
        for (int i = 0; i < size; ++i) {
            toList.add((Object)dash);
        }
        return ComponentColumn.build((List<? extends Component>)toList.build(), ComponentAlignment.CENTER);
    }

    private static ComponentColumn countColumn(List<Integer> oreCounts) {
        ImmutableList.Builder toList = ImmutableList.builder();
        toList.add((Object)Component.translatable((String)"misc.twilightforest.ore_meter_header_count").withStyle(ChatFormatting.GRAY));
        oreCounts.stream().mapToInt(count -> count).mapToObj(count -> Component.literal((String)String.valueOf(count))).forEach(arg_0 -> ((ImmutableList.Builder)toList).add(arg_0));
        return ComponentColumn.build((List<? extends Component>)toList.build(), ComponentAlignment.RIGHT);
    }

    private static ComponentColumn ratioColumn(int totalScanned, List<Integer> oreCounts) {
        ImmutableList.Builder toList = ImmutableList.builder();
        toList.add((Object)Component.translatable((String)"misc.twilightforest.ore_meter_header_ratio").withStyle(ChatFormatting.GRAY));
        for (int count : oreCounts) {
            String percentage = FORMAT.format((float)count * 100.0f / (float)totalScanned);
            toList.add((Object)Component.translatable((String)"misc.twilightforest.ore_meter_ratio", (Object[])new Object[]{percentage}));
        }
        return ComponentColumn.build((List<? extends Component>)toList.build(), ComponentAlignment.RIGHT);
    }

    static {
        FORMAT = new DecimalFormat("0.000");
    }

    public record OreMeterInfoCache(int totalPixelWidth, int totalRowCount, List<Component> headerRows, List<ComponentColumn> textColumns) {
        public static OreMeterInfoCache build(List<Component> headers, List<ComponentColumn> columns) {
            int summedColumnMaxWidths = columns.stream().mapToInt(ComponentColumn::maxPixelWidth).sum();
            int maxHeaderWidth = headers.stream().mapToInt(c -> Minecraft.getInstance().font.width((FormattedText)c)).max().orElse(0);
            int maxPixelWidth = Math.max(summedColumnMaxWidths, maxHeaderWidth);
            int totalRowCount = headers.size() + columns.stream().mapToInt(column -> column.textRows.size()).max().orElse(0);
            return new OreMeterInfoCache(maxPixelWidth, totalRowCount, (List<Component>)ImmutableList.copyOf(headers), (List<ComponentColumn>)ImmutableList.copyOf(columns));
        }

        public void renderData(GuiGraphics graphics) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            int verticalTextPixelsAdvance = 9 + 1;
            graphics.fill(0, 0, this.totalPixelWidth + 8, this.totalRowCount * verticalTextPixelsAdvance + 6, -1694498816);
            int xOff = 4;
            int yOff = 4;
            for (Component headerRowText : this.headerRows) {
                graphics.drawString(Minecraft.getInstance().font, headerRowText, xOff, yOff, 0xFFFFFF, false);
                yOff += verticalTextPixelsAdvance;
            }
            for (ComponentColumn column : this.textColumns) {
                xOff += column.renderColumn(graphics, column, xOff, yOff, verticalTextPixelsAdvance);
            }
        }
    }

    public record ComponentColumn(List<? extends Component> textRows, int maxPixelWidth, ComponentAlignment textAlignment) {
        public static ComponentColumn build(List<? extends Component> rowTexts, ComponentAlignment textAlignment) {
            int maxColumnPixelWidth = rowTexts.stream().mapToInt(c -> Minecraft.getInstance().font.width((FormattedText)c)).max().orElse(0);
            return new ComponentColumn(rowTexts, maxColumnPixelWidth, textAlignment);
        }

        public static ComponentColumn padding(int forcedExtraMaxWidthBySpaces) {
            return new ComponentColumn(List.of(), forcedExtraMaxWidthBySpaces * Minecraft.getInstance().font.width(" "), ComponentAlignment.LEFT);
        }

        private int renderColumn(GuiGraphics graphics, ComponentColumn column, int xOff, int yOff, int verticalTextPixelsAdvance) {
            for (Component component : column.textRows) {
                int textPixelWidth = Minecraft.getInstance().font.width((FormattedText)component);
                int textXPos = xOff + this.textAlignment.getTextOffset(textPixelWidth, this.maxPixelWidth);
                graphics.drawString(Minecraft.getInstance().font, component, textXPos, yOff, 0xFFFFFF, false);
                yOff += verticalTextPixelsAdvance;
            }
            return column.maxPixelWidth;
        }
    }
}

