/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.entity.passive.Penguin;

public class PenguinModel
extends HumanoidModel<Penguin> {
    public PenguinModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 9.0f, 8.0f), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -4.0f, -3.5f, 7.0f, 5.0f, 7.0f), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(0, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)-1.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(34, 18).addBox(-1.0f, -1.0f, -2.0f, 1.0f, 8.0f, 4.0f), PartPose.offset((float)-4.0f, (float)15.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(24, 18).addBox(0.0f, -1.0f, -2.0f, 1.0f, 8.0f, 4.0f), PartPose.offset((float)4.0f, (float)15.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -5.0f, 4.0f, 1.0f, 8.0f), PartPose.offset((float)-2.0f, (float)23.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -5.0f, 4.0f, 1.0f, 8.0f), PartPose.offset((float)2.0f, (float)23.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer builder, int light, int overlay, int color) {
        if (this.young) {
            float f = 2.0f;
            stack.pushPose();
            stack.scale(1.0f / f, 1.0f / f, 1.0f / f);
            stack.translate(0.0f, 1.5f, 0.0f);
            this.headParts().forEach(renderer -> renderer.render(stack, builder, light, overlay, color));
            stack.popPose();
            stack.pushPose();
            stack.scale(1.0f / f, 1.0f / f, 1.0f / f);
            stack.translate(0.0f, 1.5f, 0.0f);
            this.bodyParts().forEach(renderer -> renderer.render(stack, builder, light, overlay, color));
            stack.popPose();
        } else {
            this.headParts().forEach(renderer -> renderer.render(stack, builder, light, overlay, color));
            this.bodyParts().forEach(renderer -> renderer.render(stack, builder, light, overlay, color));
        }
    }

    public void setupAnim(Penguin entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightLeg.xRot = Mth.cos((float)limbSwing) * 0.7f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing + (float)Math.PI)) * 0.7f * limbSwingAmount;
        this.rightArm.zRot = ageInTicks;
        this.leftArm.zRot = -ageInTicks;
    }
}

