/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;

public class TransformationParticle
extends TextureSheetParticle {
    private final double xStart;
    private final double yStart;
    private final double zStart;

    public TransformationParticle(ClientLevel level, double x, double y, double z, double x2, double y2, double z2) {
        super(level, x, y, z);
        this.xd = x2;
        this.yd = y2;
        this.zd = z2;
        this.xStart = x;
        this.yStart = y;
        this.zStart = z;
        this.xo = x + x2;
        this.yo = y + y2;
        this.zo = z + z2;
        this.x = this.xo;
        this.y = this.yo;
        this.z = this.zo;
        this.quadSize = 0.5f * (this.random.nextFloat() * 0.3f + 0.2f);
        this.hasPhysics = false;
        this.lifetime = ((int)(Math.random() * 10.0) + 10) * 2;
        this.alpha = 0.0f;
        this.rCol = 0.38f;
        this.gCol = 0.82f;
        this.bCol = 0.82f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void move(double x, double y, double z) {
        this.setBoundingBox(this.getBoundingBox().move(x, y, z));
        this.setLocationFromBoundingbox();
    }

    public int getLightColor(float partialTicks) {
        float f = ((float)this.age + partialTicks) / (float)this.lifetime;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(partialTicks);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            float f = (float)this.age / (float)this.lifetime;
            this.alpha = Math.min(f * 1.35f, 1.0f);
            f = 1.0f - f;
            float f1 = 1.0f - f;
            f1 *= f1;
            f1 *= f1;
            this.x = this.xStart + this.xd * (double)f;
            this.y = this.yStart + this.yd * (double)f - (double)(f1 * 1.2f);
            this.z = this.zStart + this.zd * (double)f;
        }
    }

    public AABB getRenderBoundingBox(float partialTicks) {
        return AABB.INFINITE;
    }

    public record Factory(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double x2, double y2, double z2) {
            TransformationParticle sortingParticle = new TransformationParticle(level, x, y, z, x2, y2, z2);
            sortingParticle.pickSprite(this.sprite);
            return sortingParticle;
        }
    }
}

