/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.passive.QuestRam;

public class QuestRamEatWoolGoal
extends Goal {
    private final QuestRam ram;
    private final PathNavigation navigation;
    @Nullable
    private ItemEntity targetItem = null;

    public QuestRamEatWoolGoal(QuestRam ram) {
        this.ram = ram;
        this.navigation = ram.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        List items = this.ram.level().getEntitiesOfClass(ItemEntity.class, this.ram.getBoundingBox().inflate(16.0), item -> (item.onGround() || item.isInWater()) && item.isAlive() && !item.getItem().isEmpty() && this.ram.hasLineOfSight((Entity)item) && this.ram.isItemTempting(item.getItem()));
        items.sort(Comparator.comparingDouble(arg_0 -> ((QuestRam)this.ram).distanceToSqr(arg_0)));
        if (!items.isEmpty()) {
            this.targetItem = (ItemEntity)items.getFirst();
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.ram.isAlive() && !this.navigation.isStuck() && !this.navigation.isDone() && this.targetItem != null && this.targetItem.isAlive() && this.ram.isItemTempting(this.targetItem.getItem());
    }

    public void start() {
        if (this.targetItem != null) {
            this.navigation.stop();
            this.ram.getLookControl().setLookAt((Entity)this.targetItem, (float)(this.ram.getMaxHeadYRot() + 20), (float)this.ram.getMaxHeadXRot());
            this.navigation.moveTo((Entity)this.targetItem, 1.0);
        }
    }

    public void tick() {
        super.tick();
        if (!this.ram.level().isClientSide() && this.targetItem != null && this.ram.isItemTempting(this.targetItem.getItem())) {
            this.ram.getLookControl().setLookAt((Entity)this.targetItem, (float)(this.ram.getMaxHeadYRot() + 20), (float)this.ram.getMaxHeadXRot());
            if (this.ram.distanceToSqr(this.targetItem.position()) < 6.25 && this.ram.tryAccept(this.targetItem.getItem())) {
                this.targetItem.discard();
                this.ram.gameEvent((Holder)GameEvent.EAT);
            }
        }
    }
}

