/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import java.lang.invoke.LambdaMetafactory;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;
import twilightforest.components.entity.SmashBlocksEnchantmentAttachment;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;

public class ChainBlock
extends ThrowableProjectile
implements IEntityWithComplexSpawn {
    private static final int MAX_STUCK_TICKS = 100;
    private static final int MAX_CHAIN = 16;
    private static final EntityDataAccessor<Boolean> HAND = SynchedEntityData.defineId(ChainBlock.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_FOIL = SynchedEntityData.defineId(ChainBlock.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_RETURNING = SynchedEntityData.defineId(ChainBlock.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean hitEntity = false;
    private int stuckTime;
    @Nullable
    private ItemStack stack;
    private double velX;
    private double velY;
    private double velZ;

    public ChainBlock(EntityType<? extends ChainBlock> type, Level level) {
        super(type, level);
    }

    public ChainBlock(EntityType<? extends ChainBlock> type, Level level, LivingEntity thrower, InteractionHand hand, ItemStack stack) {
        super(type, thrower, level);
        this.stack = stack;
        this.setHand(hand);
        this.shootFromRotation((Entity)thrower, thrower.getXRot(), thrower.getYRot(), 0.0f, 1.5f, 1.0f);
        this.getEntityData().set(IS_FOIL, (Object)stack.hasFoil());
    }

    public AABB getBoundingBoxForCulling() {
        if (this.getOwner() != null) {
            AABB dis = super.getBoundingBoxForCulling();
            AABB owner = this.getOwner().getBoundingBoxForCulling();
            return dis.minmax(owner);
        }
        return super.getBoundingBoxForCulling();
    }

    private void setHand(InteractionHand hand) {
        this.getEntityData().set(HAND, (Object)(hand == InteractionHand.MAIN_HAND ? 1 : 0));
    }

    public InteractionHand getHand() {
        return (Boolean)this.getEntityData().get(HAND) != false ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public boolean isFoil() {
        return (Boolean)this.getEntityData().get(IS_FOIL);
    }

    public void setIsReturning(boolean returning) {
        this.getEntityData().set(IS_RETURNING, (Object)returning);
    }

    public boolean isReturning() {
        return (Boolean)this.getEntityData().get(IS_RETURNING);
    }

    public boolean canUsePortal(boolean p_352918_) {
        return false;
    }

    public void shoot(double x, double y, double z, float speed, float accuracy) {
        super.shoot(x, y, z, speed, accuracy);
        this.velX = this.getDeltaMovement().x();
        this.velY = this.getDeltaMovement().y();
        this.velZ = this.getDeltaMovement().z();
    }

    protected void updateRotation() {
        Entity entity;
        Vec3 vec3 = this.getDeltaMovement();
        if (this.isReturning() && (entity = this.getOwner()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            vec3 = vec3.normalize().scale(-1.0).lerp(this.getEyePosition().subtract(living.getEyePosition()).normalize(), 0.5);
        }
        double d0 = vec3.horizontalDistance();
        this.setXRot(ChainBlock.lerpRotation((float)this.xRotO, (float)((float)(Mth.atan2((double)vec3.y, (double)d0) * 180.0 / 3.1415927410125732))));
        this.setYRot(ChainBlock.lerpRotation((float)this.yRotO, (float)((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732))));
    }

    protected double getDefaultGravity() {
        return 0.05f;
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Level level = this.level();
        if (!level.isClientSide() && result.getEntity() != this.getOwner() && level.getWorldBorder().isWithinBounds(result.getEntity().blockPosition())) {
            Player player;
            Entity entity;
            LivingEntity living;
            float damage = 10.0f;
            DamageSource source = TFDamageTypes.getIndirectEntityDamageSource(level, TFDamageTypes.SPIKED, (Entity)this, this.getOwner(), new EntityType[0]);
            if (this.stack != null) {
                Entity entity2 = result.getEntity();
                if (entity2 instanceof LivingEntity) {
                    living = (LivingEntity)entity2;
                    damage = EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)level), (ItemStack)this.stack, (Entity)living, (DamageSource)source, (float)damage);
                } else {
                    PartEntity part;
                    entity2 = result.getEntity();
                    if (entity2 instanceof PartEntity && (entity2 = (part = (PartEntity)entity2).getParent()) instanceof LivingEntity) {
                        LivingEntity living2 = (LivingEntity)entity2;
                        damage = EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)level), (ItemStack)this.stack, (Entity)living2, (DamageSource)source, (float)damage);
                    }
                }
            }
            if ((entity = result.getEntity()) instanceof Player && (player = (Player)entity).isUsingItem() && player.getUseItem().canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
                player.getUseItem().hurtAndBreak(5, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                player.disableShield();
            }
            if (damage > 0.0f && result.getEntity().hurt(source, damage)) {
                this.playSound((SoundEvent)TFSounds.BLOCK_AND_CHAIN_HIT.get(), 1.0f, this.random.nextFloat());
                this.hitEntity = true;
                this.setIsReturning(true);
                this.tickCount += 60;
                entity = this.getOwner();
                if (entity instanceof LivingEntity) {
                    living = (LivingEntity)entity;
                    this.stack.hurtAndBreak(1, living, LivingEntity.getSlotForHand((InteractionHand)this.getHand()));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onHitBlock(BlockHitResult result) {
        block3: {
            super.onHitBlock(result);
            pos = result.getBlockPos();
            var4_3 = this.level();
            if (!(var4_3 instanceof ServerLevel)) break block3;
            level = (ServerLevel)var4_3;
            if (this.stack == null || (state = level.getBlockState(pos)).isAir()) break block3;
            var7_5 = this.getOwner();
            if (!(var7_5 instanceof ServerPlayer)) ** GOTO lbl-1000
            player = (ServerPlayer)var7_5;
            if (player.gameMode.getGameModeForPlayer().isBlockPlacingRestricted()) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = restrictedPlaceMode = false;
            }
            if (!ChainBlock.canBreakBlockAt((Level)level, pos, state, this.stack, restrictedPlaceMode) || ((SmashBlocksEnchantmentAttachment)this.getData((Supplier)TFDataAttachments.SMASH_BLOCKS)).getBlocksSmashed() >= 12) {
                this.bounce(result.getDirection());
            }
            vec3 = result.getBlockPos().clampLocationWithin(result.getLocation().add(-0.5, 0.0, 0.0));
            var8_8 = this.getOwner();
            EnchantmentHelper.onHitBlock((ServerLevel)level, (ItemStack)this.stack, (LivingEntity)(var8_8 instanceof LivingEntity != false ? (livingentity = (LivingEntity)var8_8) : null), (Entity)this, null, (Vec3)vec3, (BlockState)level.getBlockState(result.getBlockPos()), (Consumer<Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$onHitBlock$0(net.minecraft.world.item.Item ), (Lnet/minecraft/world/item/Item;)V)((ChainBlock)this));
        }
    }

    public void bounce(Direction direction) {
        if (!this.isReturning() && !this.hitEntity) {
            this.playSound((SoundEvent)TFSounds.BLOCK_AND_CHAIN_COLLIDE.get(), 0.125f, this.random.nextFloat());
            this.gameEvent((Holder)GameEvent.HIT_GROUND);
        }
        this.setIsReturning(true);
        double bounce = 0.6;
        this.velX *= bounce;
        this.velY *= bounce;
        this.velZ *= bounce;
        switch (direction) {
            case DOWN: {
                if (!(this.velY > 0.0)) break;
                this.velY *= -bounce;
                break;
            }
            case UP: {
                if (!(this.velY < 0.0)) break;
                this.velY *= -bounce;
                break;
            }
            case NORTH: {
                if (!(this.velZ > 0.0)) break;
                this.velZ *= -bounce;
                break;
            }
            case SOUTH: {
                if (!(this.velZ < 0.0)) break;
                this.velZ *= -bounce;
                break;
            }
            case WEST: {
                if (!(this.velX > 0.0)) break;
                this.velX *= -bounce;
                break;
            }
            case EAST: {
                if (!(this.velX < 0.0)) break;
                this.velX *= -bounce;
            }
        }
    }

    public static boolean canBreakBlockAt(Level level, BlockPos pos, BlockState state, ItemStack stack, boolean restrictedPlaceMode) {
        return level.getWorldBorder().isWithinBounds(pos) && stack.isCorrectToolForDrops(state) && !state.is(BlockTagGenerator.BLOCK_AND_CHAIN_NEVER_BREAKS) && (!restrictedPlaceMode || stack.canBreakBlockInAdventureMode(new BlockInWorld((LevelReader)level, pos, false)));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.getOwner() == null) {
                this.discard();
            } else {
                if (!this.isReturning()) {
                    if (this.xOld != this.getX() || this.zOld != this.getZ()) {
                        double d0 = Math.abs(this.getX() - this.xOld);
                        double d1 = Math.abs(this.getZ() - this.zOld);
                        if (d0 < (double)0.003f && d1 < (double)0.003f) {
                            ++this.stuckTime;
                        }
                    }
                    if (this.stuckTime >= 100) {
                        this.setIsReturning(true);
                    }
                }
                double distToPlayer = this.distanceTo(this.getOwner());
                if (!this.isReturning() && distToPlayer > 16.0) {
                    this.setIsReturning(true);
                }
                if (this.isReturning()) {
                    if (distToPlayer < 2.0) {
                        LivingEntity living;
                        Entity entity;
                        if (this.stack != null && (entity = this.getOwner()) instanceof LivingEntity && ((SmashBlocksEnchantmentAttachment)(living = (LivingEntity)entity).getData(TFDataAttachments.SMASH_BLOCKS)).getBlocksSmashed() > 0) {
                            this.stack.hurtAndBreak(Math.min(((SmashBlocksEnchantmentAttachment)living.getData(TFDataAttachments.SMASH_BLOCKS)).getBlocksSmashed(), 3), living, LivingEntity.getSlotForHand((InteractionHand)this.getHand()));
                        }
                        this.discard();
                    }
                    LivingEntity returnTo = (LivingEntity)this.getOwner();
                    Vec3 back = new Vec3(returnTo.getX(), returnTo.getY() + (double)returnTo.getEyeHeight(), returnTo.getZ()).subtract(this.position()).normalize();
                    float age = Math.min((float)this.tickCount * 0.03f, 1.0f);
                    this.setDeltaMovement(new Vec3(this.velX * (1.0 - (double)age) + back.x() * 2.0 * (double)age, this.velY * (1.0 - (double)age) + back.y() * 2.0 * (double)age - this.getGravity(), this.velZ * (1.0 - (double)age) + back.z() * 2.0 * (double)age));
                }
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(HAND, (Object)true);
        builder.define(IS_FOIL, (Object)false);
        builder.define(IS_RETURNING, (Object)false);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        LivingEntity thrower = (LivingEntity)this.getOwner();
        if (thrower != null && thrower.getUseItem().is((Item)TFItems.BLOCK_AND_CHAIN.get())) {
            thrower.stopUsingItem();
        }
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("BlockAndChainStack", 10)) {
            this.stack = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)pCompound.getCompound("BlockAndChainStack"));
        }
        this.setIsReturning(pCompound.getBoolean("IsReturning"));
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.put("BlockAndChainStack", this.stack.save((HolderLookup.Provider)this.registryAccess()));
        pCompound.putBoolean("IsReturning", this.isReturning());
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.getOwner() != null ? this.getOwner().getId() : -1);
        buffer.writeBoolean(this.getHand() == InteractionHand.MAIN_HAND);
    }

    public void readSpawnData(RegistryFriendlyByteBuf buf) {
        Entity e = this.level().getEntity(buf.readInt());
        if (e instanceof LivingEntity) {
            this.setOwner(e);
        }
        this.setHand(buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }

    private /* synthetic */ void lambda$onHitBlock$0(Item item) {
        this.kill();
    }
}

