/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.JukeboxSong;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFSounds;

public class TFJukeboxSongs {
    public static final ResourceKey<JukeboxSong> RADIANCE = TFJukeboxSongs.registerKey("radiance");
    public static final ResourceKey<JukeboxSong> STEPS = TFJukeboxSongs.registerKey("steps");
    public static final ResourceKey<JukeboxSong> SUPERSTITIOUS = TFJukeboxSongs.registerKey("superstitious");
    public static final ResourceKey<JukeboxSong> HOME = TFJukeboxSongs.registerKey("home");
    public static final ResourceKey<JukeboxSong> WAYFARER = TFJukeboxSongs.registerKey("warfarer");
    public static final ResourceKey<JukeboxSong> FINDINGS = TFJukeboxSongs.registerKey("findings");
    public static final ResourceKey<JukeboxSong> MAKER = TFJukeboxSongs.registerKey("maker");
    public static final ResourceKey<JukeboxSong> THREAD = TFJukeboxSongs.registerKey("thread");
    public static final ResourceKey<JukeboxSong> MOTION = TFJukeboxSongs.registerKey("motion");

    private static ResourceKey<JukeboxSong> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.JUKEBOX_SONG, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void bootstrap(BootstrapContext<JukeboxSong> context) {
        TFJukeboxSongs.register(context, RADIANCE, TFSounds.MUSIC_DISC_RADIANCE, 123.0f, 15);
        TFJukeboxSongs.register(context, STEPS, TFSounds.MUSIC_DISC_STEPS, 195.0f, 15);
        TFJukeboxSongs.register(context, SUPERSTITIOUS, TFSounds.MUSIC_DISC_SUPERSTITIOUS, 192.0f, 15);
        TFJukeboxSongs.register(context, HOME, TFSounds.MUSIC_DISC_HOME, 215.0f, 15);
        TFJukeboxSongs.register(context, WAYFARER, TFSounds.MUSIC_DISC_WAYFARER, 173.0f, 15);
        TFJukeboxSongs.register(context, FINDINGS, TFSounds.MUSIC_DISC_FINDINGS, 196.0f, 15);
        TFJukeboxSongs.register(context, MAKER, TFSounds.MUSIC_DISC_MAKER, 207.0f, 15);
        TFJukeboxSongs.register(context, THREAD, TFSounds.MUSIC_DISC_THREAD, 201.0f, 15);
        TFJukeboxSongs.register(context, MOTION, TFSounds.MUSIC_DISC_MOTION, 169.0f, 15);
    }

    private static void register(BootstrapContext<JukeboxSong> context, ResourceKey<JukeboxSong> key, Holder<SoundEvent> sound, float length, int output) {
        context.register(key, (Object)new JukeboxSong(sound, (Component)Component.translatable((String)Util.makeDescriptionId((String)"jukebox_song", (ResourceLocation)key.location())), length, output));
    }
}

