/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;

public class LampOfCindersItem
extends Item {
    private static final int FIRING_TIME = 12;

    public LampOfCindersItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isEnchantable(ItemStack pStack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @Nonnull InteractionHand hand) {
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (this.burnBlock(world, pos)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, pos, player.getItemInHand(context.getHand()));
            }
            if (player != null) {
                player.playSound((SoundEvent)TFSounds.LAMP_BURN.get(), 0.5f, 1.5f);
            }
            for (int i = 0; i < 10; ++i) {
                float dx = (float)pos.getX() + 0.5f + (world.getRandom().nextFloat() - world.getRandom().nextFloat()) * 0.75f;
                float dy = (float)pos.getY() + 0.5f + (world.getRandom().nextFloat() - world.getRandom().nextFloat()) * 0.75f;
                float dz = (float)pos.getZ() + 0.5f + (world.getRandom().nextFloat() - world.getRandom().nextFloat()) * 0.75f;
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)dx, (double)dy, (double)dz, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)dx, (double)dy, (double)dz, 0.0, 0.0, 0.0);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean burnBlock(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.is(TFBlocks.BROWN_THORNS) || state.is(TFBlocks.GREEN_THORNS)) {
            level.setBlockAndUpdate(pos, ((Block)TFBlocks.BURNT_THORNS.get()).withPropertiesOf(state));
            return true;
        }
        return false;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity living, int useRemaining) {
        int useTime = this.getUseDuration(stack, living) - useRemaining;
        if (useTime > 12 && stack.getDamageValue() + 1 < this.getMaxDamage(stack)) {
            this.doBurnEffect(level, living);
        }
    }

    private void doBurnEffect(Level level, LivingEntity living) {
        BlockPos pos = BlockPos.containing((Position)living.getEyePosition().add(living.getLookAngle().scale(2.0)));
        int range = 4;
        if (!level.isClientSide()) {
            level.playSound(null, living.getX(), living.getY(), living.getZ(), (SoundEvent)TFSounds.LAMP_BURN.get(), living.getSoundSource(), 1.5f, 0.8f);
            for (int dx = -range; dx <= range; ++dx) {
                for (int dy = -range; dy <= range; ++dy) {
                    for (int dz = -range; dz <= range; ++dz) {
                        this.burnBlock(level, pos.offset(dx, dy, dz));
                    }
                }
            }
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            for (int i = 0; i < 6; ++i) {
                BlockPos rPos = pos.offset(level.getRandom().nextInt(range) - level.getRandom().nextInt(range), level.getRandom().nextInt(2), level.getRandom().nextInt(range) - level.getRandom().nextInt(range));
                level.levelEvent(player, 2004, rPos, 0);
            }
            for (LivingEntity targets : level.getEntitiesOfClass(LivingEntity.class, new AABB(pos.below(2)).inflate(4.0))) {
                if (targets instanceof Player) continue;
                targets.igniteForSeconds(5.0f);
            }
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }
}

