/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import twilightforest.init.TFRecipes;

public class UncraftingRecipe
extends ShapedRecipe {
    private final int cost;
    private final Ingredient input;
    private final int count;
    private final ShapedRecipePattern pattern;

    public UncraftingRecipe(int cost, Ingredient input, int count, ShapedRecipePattern pattern) {
        super("uncrafting", CraftingBookCategory.MISC, pattern, new ItemStack((ItemLike)Items.AIR, count));
        this.cost = cost;
        this.input = input;
        this.count = count;
        this.pattern = pattern;
    }

    public boolean matches(CraftingInput input, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean isItemStackAnIngredient(ItemStack stack) {
        return Arrays.stream(this.input.getItems()).anyMatch(i -> stack.getItem() == i.getItem() && stack.getCount() >= this.count);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFRecipes.UNCRAFTING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFRecipes.UNCRAFTING_RECIPE.get();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getCount() {
        return this.count;
    }

    public int getCost() {
        return this.cost;
    }

    public static class Serializer
    implements RecipeSerializer<UncraftingRecipe> {
        public static final MapCodec<UncraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("cost", (Object)-1).forGetter(o -> o.cost), (App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(o -> o.input), (App)Codec.INT.optionalFieldOf("input_count", (Object)1).forGetter(o -> o.count), (App)ShapedRecipePattern.MAP_CODEC.forGetter(o -> o.pattern)).apply((Applicative)instance, UncraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, UncraftingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<UncraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, UncraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static UncraftingRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            int cost = buf.readInt();
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            int count = buf.readInt();
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buf);
            return new UncraftingRecipe(cost, input, count, pattern);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, UncraftingRecipe recipe) {
            buf.writeInt(recipe.cost);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.input);
            buf.writeInt(recipe.count);
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buf, (Object)recipe.pattern);
        }
    }
}

