/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.world.PieceBeardifierModifier;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.beanification.Autowired;
import twilightforest.block.ChiseledCanopyShelfBlock;
import twilightforest.block.JarBlock;
import twilightforest.block.LightableBlock;
import twilightforest.block.MasonJarBlock;
import twilightforest.block.SkullCandleBlock;
import twilightforest.block.WroughtIronFenceBlock;
import twilightforest.block.entity.MasonJarBlockEntity;
import twilightforest.block.entity.bookshelf.ChiseledCanopyShelfBlockEntity;
import twilightforest.block.entity.spawner.SinisterSpawnerBlockEntity;
import twilightforest.entity.monster.DeathTome;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFEntities;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.loot.TFLootTables;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.util.DirectionUtil;
import twilightforest.util.RotationUtil;
import twilightforest.util.WorldUtil;
import twilightforest.util.entities.EntityUtil;
import twilightforest.util.jigsaw.JigsawPlaceContext;
import twilightforest.util.jigsaw.JigsawRecord;
import twilightforest.util.jigsaw.JigsawUtil;
import twilightforest.world.components.structures.SpawnIndexProvider;
import twilightforest.world.components.structures.TwilightJigsawPiece;
import twilightforest.world.components.structures.TwilightTemplateStructurePiece;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerRoomDecor;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerUtil;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerWingBeard;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerWingBridge;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerWingRoof;

public final class LichTowerWingRoom
extends TwilightJigsawPiece
implements PieceBeardifierModifier,
SpawnIndexProvider {
    @Autowired
    private static LichTowerUtil lichTowerUtil;
    private final int roomSize;
    private final boolean generateGround;
    private final int ladderIndex;
    private final String jigsawLadderTarget;
    private final int roofFallback;
    private final int[] allowedCeilingPlacements;

    public LichTowerWingRoom(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
        super((StructurePieceType)TFStructurePieceTypes.LICH_WING_ROOM.get(), compoundTag, ctx, LichTowerWingRoom.readSettings(compoundTag));
        LichTowerUtil.addDefaultProcessors(this.placeSettings.addProcessor(lichTowerUtil.getRoomSpawnerProcessor()));
        this.placeSettings().setLiquidSettings(LiquidSettings.IGNORE_WATERLOGGING);
        this.roomSize = compoundTag.getInt("room_size");
        this.generateGround = compoundTag.getBoolean("gen_ground");
        this.ladderIndex = compoundTag.getInt("ladder_index");
        this.jigsawLadderTarget = this.shouldLadderUpwards() ? this.getSpareJigsaws().get(this.ladderIndex).target() : "";
        this.roofFallback = compoundTag.getInt("roof_index");
        this.allowedCeilingPlacements = compoundTag.getIntArray("allowed_ceiling_placements");
    }

    public LichTowerWingRoom(StructureTemplateManager structureManager, int genDepth, JigsawPlaceContext jigsawContext, ResourceLocation roomId, int roomSize, boolean generateGround, boolean canGenerateLadder, RandomSource random) {
        super((StructurePieceType)TFStructurePieceTypes.LICH_WING_ROOM.get(), genDepth, structureManager, roomId, jigsawContext);
        Set ladderPlacements;
        LichTowerUtil.addDefaultProcessors(this.placeSettings.addProcessor(lichTowerUtil.getRoomSpawnerProcessor()));
        this.placeSettings().setLiquidSettings(LiquidSettings.IGNORE_WATERLOGGING);
        this.roomSize = roomSize;
        this.generateGround = generateGround;
        Set<Object> set = ladderPlacements = canGenerateLadder ? lichTowerUtil.getLadderPlacementsForSize(this.roomSize) : Collections.emptySet();
        this.ladderIndex = canGenerateLadder ? this.pickFirstIndex(this.getSpareJigsaws(), ladderPlacements::contains) : -1;
        this.jigsawLadderTarget = this.shouldLadderUpwards() ? this.getSpareJigsaws().get(this.ladderIndex).target() : "";
        this.roofFallback = canGenerateLadder ? this.pickFirstIndex(this.getSpareJigsaws(), "twilightforest:lich_tower/roof"::equals) : -1;
        this.allowedCeilingPlacements = LichTowerWingRoom.generateCeilingPlacements(random, this.template, this.boundingBox, this.placeSettings);
    }

    private static int[] generateCeilingPlacements(RandomSource random, StructureTemplate template, BoundingBox box, StructurePlaceSettings placeSettings) {
        int width = Math.max(box.getXSpan(), box.getZSpan());
        if (width <= 0) {
            return new int[0];
        }
        ObjectArrayList blockInfos = template.filterBlocks(BlockPos.ZERO, placeSettings, Blocks.STRUCTURE_BLOCK, false);
        blockInfos.removeIf(info -> {
            CompoundTag nbt = info.nbt();
            if (nbt == null || nbt.isEmpty()) {
                return false;
            }
            String metadata = nbt.getString("metadata");
            return !metadata.startsWith("rope") && !metadata.startsWith("chain");
        });
        if (blockInfos.isEmpty()) {
            return new int[0];
        }
        LichTowerWingRoom.filterAlignedPieces(random, (ObjectArrayList<StructureTemplate.StructureBlockInfo>)blockInfos);
        int[] xIndexedZOffsets = new int[width];
        Arrays.fill(xIndexedZOffsets, -1);
        for (int i = 0; i < blockInfos.size(); ++i) {
            BlockPos pos = ((StructureTemplate.StructureBlockInfo)blockInfos.get(i)).pos();
            xIndexedZOffsets[pos.getX()] = pos.getZ();
        }
        return xIndexedZOffsets;
    }

    private static void filterAlignedPieces(RandomSource random, ObjectArrayList<StructureTemplate.StructureBlockInfo> blockInfos) {
        Util.shuffle(blockInfos, (RandomSource)random);
        IntArraySet xDistinct = new IntArraySet();
        IntArraySet zDistinct = new IntArraySet();
        for (int i = 0; i < blockInfos.size(); ++i) {
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)blockInfos.get(i);
            if (blockInfo.nbt() == null || LichTowerWingRoom.filterMetadata(random, blockInfo.nbt())) continue;
            BlockPos pos = blockInfo.pos();
            if (xDistinct.contains(pos.getX()) || zDistinct.contains(pos.getZ())) {
                blockInfos.remove(i);
                --i;
                continue;
            }
            xDistinct.add(pos.getX());
            zDistinct.add(pos.getZ());
        }
    }

    private static boolean filterMetadata(RandomSource random, CompoundTag nbt) {
        if (nbt.isEmpty() || !nbt.contains("metadata", 8)) {
            return true;
        }
        String metadata = nbt.getString("metadata").split("%", 1)[0];
        String chance = metadata.startsWith("rope") ? metadata.substring("rope".length()) : metadata.substring("chain".length());
        return chance.isBlank() || StringUtils.isNumeric((CharSequence)chance) && random.nextFloat() > (float)Integer.parseInt(chance) * 0.01f;
    }

    private int pickFirstIndex(List<JigsawRecord> spareJigsaws, Predicate<String> filter) {
        for (int i = 0; i < spareJigsaws.size(); ++i) {
            if (!filter.test(spareJigsaws.get(i).target())) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext ctx, CompoundTag structureTag) {
        super.addAdditionalSaveData(ctx, structureTag);
        structureTag.putInt("room_size", this.roomSize);
        structureTag.putBoolean("gen_ground", this.generateGround);
        structureTag.putInt("ladder_index", this.ladderIndex);
        structureTag.putInt("roof_index", this.roofFallback);
        structureTag.putIntArray("allowed_ceiling_placements", this.allowedCeilingPlacements);
    }

    @Override
    protected void processJigsaw(StructurePiece parent, StructurePieceAccessor pieceAccessor, RandomSource random, JigsawRecord connection, int jigsawIndex) {
        switch (connection.target()) {
            case "twilightforest:lich_tower/bridge": {
                boolean tooCloseToGround;
                if (this.roomSize < 1) {
                    return;
                }
                boolean terminate = this.genDepth > 30 || random.nextInt(this.towerStackIndex() * 2 + 1) == 0;
                boolean bl = tooCloseToGround = this.generateGround || this.boundingBox.getYSpan() > 11 && connection.pos().getY() < 7;
                if (terminate || tooCloseToGround) {
                    LichTowerWingBridge.putCover(this, pieceAccessor, random, connection.pos(), connection.orientation(), this.structureManager, true, this.genDepth + 1);
                } else {
                    LichTowerWingBridge.tryRoomAndBridge(this, pieceAccessor, random, connection, this.structureManager, false, this.roomSize - random.nextInt(2), false, this.genDepth + 1, null);
                }
                return;
            }
            case "twilightforest:lich_tower/roof": {
                if (!this.shouldLadderUpwards()) {
                    this.putRoof(pieceAccessor, random, connection);
                }
                return;
            }
            case "twilightforest:lich_tower/beard": {
                if (this.hasLadderBelowRoom()) {
                    return;
                }
                FrontAndTop orientationToMatch = LichTowerWingRoom.getVerticalOrientation(connection, Direction.DOWN, this);
                if (this.generateGround) {
                    ResourceLocation trim = lichTowerUtil.getTrim(random, this.roomSize);
                    this.tryBeard(pieceAccessor, random, connection, trim, orientationToMatch, true, true);
                    break;
                }
                for (ResourceLocation beardLocation : lichTowerUtil.shuffledBeards(random, this.roomSize)) {
                    if (!this.tryBeard(pieceAccessor, random, connection, beardLocation, orientationToMatch, false, false)) continue;
                    return;
                }
                ResourceLocation fallbackBeard = lichTowerUtil.getFallbackBeard(random, this.roomSize);
                this.tryBeard(pieceAccessor, random, connection, fallbackBeard, orientationToMatch, true, false);
                break;
            }
            case "twilightforest:lich_tower/decor": {
                LichTowerRoomDecor.addDecor(this, pieceAccessor, random, connection, this.genDepth + 1, this.structureManager);
            }
        }
        if (this.ladderIndex == jigsawIndex && this.jigsawLadderTarget.equals(connection.target())) {
            boolean canFitRoomAbove;
            boolean canGenerateLadder;
            LichTowerWingRoom room;
            BoundingBox boundingBox;
            TwilightTemplateStructurePiece twilightTemplate;
            int ladderOffset = Integer.parseInt(this.jigsawLadderTarget.substring(this.jigsawLadderTarget.length() - 1));
            ResourceLocation roomId = lichTowerUtil.getRoomUpwards(random, this.roomSize, ladderOffset);
            if (roomId != null && (this.templateName.equals(roomId.toString()) || parent instanceof TwilightTemplateStructurePiece && (twilightTemplate = (TwilightTemplateStructurePiece)parent).getTemplateName().equals(roomId.toString()))) {
                roomId = lichTowerUtil.getRoomUpwards(random, this.roomSize, ladderOffset);
            }
            BlockPos topPos = connection.pos().offset(0, this.boundingBox.getYSpan() - connection.pos().getY() - 1, 0);
            JigsawPlaceContext placeableJunction = JigsawPlaceContext.pickPlaceableJunction(this.templatePosition(), topPos, connection.orientation(), this.structureManager, roomId, connection.target(), random);
            if (placeableJunction != null && pieceAccessor.findCollisionPiece(boundingBox = BoundingBoxUtils.cloneWithAdjustments((room = new LichTowerWingRoom(this.structureManager, this.genDepth + 1, placeableJunction, roomId, this.roomSize, false, canGenerateLadder = (canFitRoomAbove = placeableJunction.isWithoutCollision(this.structureManager, pieceAccessor, box -> BoundingBoxUtils.extrusionFrom(box, Direction.UP, Mth.ceil((float)((float)box.getYSpan() * 1.5f))))) && this.getSourceJigsaw().orientation().front().getAxis().isHorizontal() && random.nextBoolean(), random)).getBoundingBox(), 1, 0, 1, -1, 0, -1)) == null) {
                pieceAccessor.addPiece((StructurePiece)room);
                room.addChildren(parent, pieceAccessor, random);
                return;
            }
            Direction front = connection.orientation().front();
            if (front != Direction.UP) {
                TwilightForestMod.LOGGER.error("Jigsaw {} was facing {} inside of {}", (Object)connection.name(), (Object)front, (Object)this.templateName);
            }
            if (this.roofFallback >= 0) {
                this.putRoof(pieceAccessor, random, this.getSpareJigsaws().get(this.roofFallback));
            }
        }
    }

    private int towerStackIndex() {
        boolean hasRoomAbove = this.shouldLadderUpwards();
        boolean hasRoomBelow = this.hasLadderBelowRoom();
        return hasRoomAbove && !hasRoomBelow ? 0 : (hasRoomAbove ? 1 : 2);
    }

    private boolean putRoof(StructurePieceAccessor pieceAccessor, RandomSource random, JigsawRecord connection) {
        FrontAndTop orientationToMatch = LichTowerWingRoom.getVerticalOrientation(connection, Direction.UP, this);
        BoundingBox roofExtension = BoundingBoxUtils.extrusionFrom(this.boundingBox.minX(), this.boundingBox.maxY() + 1, this.boundingBox.minZ(), this.boundingBox.maxX(), this.boundingBox.maxY() + 1, this.boundingBox.maxZ(), orientationToMatch.top().getOpposite(), 1);
        boolean doSideAttachment = connection.orientation().front().getAxis().isHorizontal() && pieceAccessor.findCollisionPiece(roofExtension) != null;
        for (ResourceLocation roofLocation : lichTowerUtil.shuffledRoofs(random, this.roomSize, doSideAttachment)) {
            if (!LichTowerWingRoom.tryRoof(pieceAccessor, random, connection, roofLocation, orientationToMatch, false, this, this.genDepth + 1, this.structureManager)) continue;
            return true;
        }
        ResourceLocation fallbackRoof = lichTowerUtil.getFallbackRoof(random, this.roomSize, doSideAttachment);
        LichTowerWingRoom.tryRoof(pieceAccessor, random, connection, fallbackRoof, orientationToMatch, true, this, this.genDepth + 1, this.structureManager);
        return false;
    }

    @NotNull
    public static FrontAndTop getVerticalOrientation(JigsawRecord connection, Direction vertical, TwilightJigsawPiece towerRoom) {
        JigsawRecord sourceJigsaw = towerRoom.getSourceJigsaw();
        Direction sourceDirection = JigsawUtil.getAbsoluteHorizontal(sourceJigsaw != null ? sourceJigsaw.orientation() : connection.orientation());
        return FrontAndTop.fromFrontAndTop((Direction)vertical, (Direction)sourceDirection.getOpposite());
    }

    public static boolean tryRoof(StructurePieceAccessor pieceAccessor, RandomSource random, JigsawRecord connection, @Nullable ResourceLocation roofLocation, FrontAndTop orientationToMatch, boolean allowClipping, TwilightJigsawPiece parent, int newDepth, StructureTemplateManager structureManager) {
        JigsawPlaceContext placeableJunction = JigsawPlaceContext.pickPlaceableJunction(parent.templatePosition(), connection.pos(), orientationToMatch, structureManager, roofLocation, "twilightforest:lich_tower/roof", random);
        if (placeableJunction != null) {
            LichTowerWingRoof roofPiece = new LichTowerWingRoof(newDepth, structureManager, roofLocation, placeableJunction);
            if (allowClipping || pieceAccessor.findCollisionPiece(roofPiece.generationCollisionBox()) == null) {
                pieceAccessor.addPiece((StructurePiece)roofPiece);
                roofPiece.addChildren((StructurePiece)parent, pieceAccessor, random);
                return true;
            }
        }
        return false;
    }

    private boolean tryBeard(StructurePieceAccessor pieceAccessor, RandomSource random, JigsawRecord connection, @Nullable ResourceLocation beardLocation, FrontAndTop orientationToMatch, boolean allowClipping, boolean generateGround) {
        JigsawPlaceContext placeableJunction = JigsawPlaceContext.pickPlaceableJunction(this.templatePosition(), connection.pos(), orientationToMatch, this.structureManager, beardLocation, "twilightforest:lich_tower/beard", random);
        if (placeableJunction != null) {
            LichTowerWingBeard beardPiece = new LichTowerWingBeard(this.genDepth + 1, this.structureManager, beardLocation, placeableJunction, generateGround);
            if (allowClipping || pieceAccessor.findCollisionPiece(beardPiece.generationCollisionBox()) == null) {
                pieceAccessor.addPiece((StructurePiece)beardPiece);
                beardPiece.addChildren((StructurePiece)this, pieceAccessor, random);
                return true;
            }
        }
        return false;
    }

    @Override
    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox chunkBounds, ChunkPos chunkPos, BlockPos structureCenterPos) {
        JigsawRecord ladderJigsaw;
        BlockPos ladderOffset;
        BlockPos startPos;
        BlockPos placeAt;
        super.postProcess(level, structureManager, chunkGen, random, chunkBounds, chunkPos, structureCenterPos);
        JigsawRecord sourceJigsaw = this.getSourceJigsaw();
        if (this.hasLadderBelowRoom() && chunkBounds.isInside((Vec3i)(placeAt = this.templatePosition.offset((Vec3i)sourceJigsaw.pos())))) {
            BlockState ladderBlock = (BlockState)Blocks.LADDER.defaultBlockState().setValue((Property)LadderBlock.FACING, (Comparable)sourceJigsaw.orientation().top());
            level.setBlock(placeAt.below(), ladderBlock, 2);
            level.setBlock(placeAt, ladderBlock, 2);
            level.setBlock(placeAt.above(), ladderBlock, 2);
            BlockState airBlock = Blocks.AIR.defaultBlockState();
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)placeAt.above(2), (BlockPos)placeAt.above(5))) {
                level.setBlock(pos, airBlock, 2);
            }
        }
        if (this.shouldLadderUpwards() && chunkBounds.isInside((Vec3i)(startPos = this.templatePosition.offset((Vec3i)(ladderOffset = (ladderJigsaw = this.getSpareJigsaws().get(this.ladderIndex)).pos()))))) {
            BlockPos endPos = startPos.above(this.boundingBox.getYSpan() - ladderOffset.getY() - 1);
            BlockState ladderBlock = (BlockState)Blocks.LADDER.defaultBlockState().setValue((Property)LadderBlock.FACING, (Comparable)ladderJigsaw.orientation().top());
            for (BlockPos placeAt2 : BlockPos.betweenClosed((BlockPos)startPos, (BlockPos)endPos.below())) {
                level.setBlock(placeAt2, ladderBlock, 2);
            }
            level.setBlock(endPos, Blocks.COBBLESTONE.defaultBlockState(), 2);
        }
        if (this.generateGround) {
            LichTowerWingRoom.fillCorner(level, new BlockPos(this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ()), chunkBounds);
            LichTowerWingRoom.fillCorner(level, new BlockPos(this.boundingBox.maxX(), this.boundingBox.minY(), this.boundingBox.minZ()), chunkBounds);
            LichTowerWingRoom.fillCorner(level, new BlockPos(this.boundingBox.maxX(), this.boundingBox.minY(), this.boundingBox.maxZ()), chunkBounds);
            LichTowerWingRoom.fillCorner(level, new BlockPos(this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.maxZ()), chunkBounds);
        }
    }

    private static void fillCorner(WorldGenLevel level, BlockPos pos, BoundingBox chunkBounds) {
        if (chunkBounds.isInside((Vec3i)pos)) {
            level.setBlock(pos, Blocks.STONE_BRICKS.defaultBlockState(), 3);
            level.setBlock(pos.above(), Blocks.STONE_BRICKS.defaultBlockState(), 3);
        }
    }

    private boolean hasLadderBelowRoom() {
        return this.getSourceJigsaw().orientation().front() == Direction.DOWN;
    }

    private boolean shouldLadderUpwards() {
        return this.ladderIndex >= 0;
    }

    private boolean canHangBlock(BlockPos pos) {
        int dX = pos.getX() - this.boundingBox.minX();
        int dZ = pos.getZ() - this.boundingBox.minZ();
        return dX >= 0 && dX < this.allowedCeilingPlacements.length && this.allowedCeilingPlacements[dX] == dZ;
    }

    @Override
    protected void handleDataMarker(String label, BlockPos pos, WorldGenLevel level, RandomSource random, BoundingBox chunkBounds, ChunkGenerator chunkGen) {
        String[] directionSplit;
        String variety;
        String[] modifiedLabel = label.split(">");
        String string = variety = modifiedLabel.length == 2 ? modifiedLabel[1] : label;
        if (modifiedLabel.length == 2) {
            if (modifiedLabel[0].startsWith("rope") && (pos = this.danglingBlock(pos, level, random, ((Block)TFBlocks.ROPE.value()).defaultBlockState(), modifiedLabel[0].substring("rope".length()))) == null) {
                return;
            }
            if (modifiedLabel[0].startsWith("chain")) {
                if ((pos = this.danglingBlock(pos, level, random, Blocks.CHAIN.defaultBlockState(), modifiedLabel[0].substring("chain".length()))) == null) {
                    return;
                }
            } else if (modifiedLabel[0].equals("pedestal")) {
                level.setBlock(pos, ((Block)TFBlocks.TWISTED_STONE_PILLAR.value()).defaultBlockState(), 2);
                pos = pos.above();
            } else if (modifiedLabel[0].equals("below")) {
                pos = pos.below();
            }
        }
        if ((directionSplit = variety.split("@")).length == 0) {
            return;
        }
        Rotation dataRotation = directionSplit.length == 1 ? Rotation.CLOCKWISE_180 : RotationUtil.getRelativeRotation(Direction.NORTH, DirectionUtil.fromStringOrElse(directionSplit[1], Direction.SOUTH));
        Object[] permutationSplit = directionSplit[0].split("\\|");
        if (permutationSplit.length == 0) {
            return;
        }
        String chosenLabel = (String)Util.getRandom((Object[])permutationSplit, (RandomSource)random);
        String[] parameters = chosenLabel.split(":");
        if (parameters.length == 0) {
            return;
        }
        level.removeBlock(pos, false);
        this.handleDataParams(pos, level, WorldUtil.getRegistryAccess(), random, parameters, dataRotation);
    }

    @Nullable
    private BlockPos danglingBlock(BlockPos pos, WorldGenLevel level, RandomSource random, BlockState binding, String parameters) {
        String[] ropeChance = parameters.split("%");
        if (ropeChance.length == 0 || !this.canHangBlock(pos)) {
            return null;
        }
        String ropeParams = ropeChance[ropeChance.length - 1];
        int ropeLength = this.parseRange(ropeParams, random, 1, 2);
        if (ropeLength > 0) {
            for (BlockPos hangSupportAt : BlockPos.betweenClosed((BlockPos)pos, (BlockPos)pos.below(ropeLength - 1))) {
                level.setBlock(hangSupportAt, binding, 2);
            }
            pos = pos.below(ropeLength);
        }
        return pos;
    }

    private void handleDataParams(BlockPos pos, WorldGenLevel level, RegistryAccess registryAccess, RandomSource random, String[] parameters, Rotation dataRotation) {
        switch (parameters[0]) {
            case "air": 
            case "empty": {
                break;
            }
            case "bookshelf": {
                level.setBlock(pos, Blocks.BOOKSHELF.defaultBlockState(), 2);
                break;
            }
            case "canopy_shelf": 
            case "canopy_bookshelf": {
                level.setBlock(pos, ((Block)TFBlocks.CANOPY_BOOKSHELF.value()).defaultBlockState(), 2);
                break;
            }
            case "stone_brick_slab": {
                level.setBlock(pos, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 2);
                break;
            }
            case "lava": {
                level.setBlock(pos, Blocks.LAVA.defaultBlockState(), 2);
                break;
            }
            case "water": {
                level.setBlock(pos, Blocks.WATER.defaultBlockState(), 2);
                break;
            }
            case "firefly_jar": {
                level.setBlock(pos, ((JarBlock)((Object)TFBlocks.FIREFLY_JAR.value())).defaultBlockState(), 2);
                break;
            }
            case "terrorcotta_arcs": {
                level.setBlock(pos, ((RotatedPillarBlock)TFBlocks.TERRORCOTTA_ARCS.value()).defaultBlockState(), 2);
                break;
            }
            case "mason_jar": {
                this.putMasonJar(pos, level, random, parameters);
                break;
            }
            case "canopy_slab": {
                level.setBlock(pos, ((Block)TFBlocks.CANOPY_SLAB.value()).defaultBlockState(), 2);
                break;
            }
            case "canopy_stairs": {
                level.setBlock(pos, ((StairBlock)TFBlocks.CANOPY_STAIRS.value()).defaultBlockState(), 2);
                break;
            }
            case "creeper_head": {
                this.putHead(pos, level, random, parameters, Blocks.CREEPER_HEAD, dataRotation);
                break;
            }
            case "skeleton_skull": {
                this.putHead(pos, level, random, parameters, Blocks.SKELETON_SKULL, dataRotation);
                break;
            }
            case "wither_skull": {
                this.putHead(pos, level, random, parameters, Blocks.WITHER_SKELETON_SKULL, dataRotation);
                break;
            }
            case "zombie_head": {
                this.putHead(pos, level, random, parameters, Blocks.ZOMBIE_HEAD, dataRotation);
                break;
            }
            case "creeper_candle": {
                this.putHeadCandles(pos, level, random, parameters, (Block)TFBlocks.CREEPER_SKULL_CANDLE.value(), dataRotation);
                break;
            }
            case "skeleton_candle": {
                this.putHeadCandles(pos, level, random, parameters, (Block)TFBlocks.SKELETON_SKULL_CANDLE.value(), dataRotation);
                break;
            }
            case "wither_candle": {
                this.putHeadCandles(pos, level, random, parameters, (Block)TFBlocks.WITHER_SKELE_SKULL_CANDLE.value(), dataRotation);
                break;
            }
            case "zombie_candle": {
                this.putHeadCandles(pos, level, random, parameters, (Block)TFBlocks.ZOMBIE_SKULL_CANDLE.value(), dataRotation);
                break;
            }
            case "spawner": {
                this.putSpawner(pos, level, random, parameters);
                break;
            }
            case "sinister_spawner": {
                this.putSinisterSpawner(pos, level, random, parameters);
                break;
            }
            case "brewing_stand": {
                this.putBrewingStand(pos, level, random);
                break;
            }
            case "lectern": {
                this.putTrappableLectern(pos, level, dataRotation, random.nextBoolean());
                break;
            }
            case "chiseled_canopy_shelf": {
                this.putTrappableBookshelf(pos, level, registryAccess, random, dataRotation);
                break;
            }
            case "chest": {
                this.putChest(pos, level, random, parameters, dataRotation, Blocks.CHEST.defaultBlockState());
                break;
            }
            case "trapped_chest": {
                this.putChest(pos, level, random, parameters, dataRotation, Blocks.TRAPPED_CHEST.defaultBlockState());
                break;
            }
            case "candle": 
            case "candles": {
                this.putCandles(parameters, random, level, pos, Blocks.CANDLE.defaultBlockState());
                break;
            }
            case "white_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.WHITE_CANDLE.defaultBlockState());
                break;
            }
            case "orange_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.ORANGE_CANDLE.defaultBlockState());
                break;
            }
            case "magenta_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.MAGENTA_CANDLE.defaultBlockState());
                break;
            }
            case "light_blue_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.LIGHT_BLUE_CANDLE.defaultBlockState());
                break;
            }
            case "yellow_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.YELLOW_CANDLE.defaultBlockState());
                break;
            }
            case "lime_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.LIME_CANDLE.defaultBlockState());
                break;
            }
            case "pink_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.PINK_CANDLE.defaultBlockState());
                break;
            }
            case "gray_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.GRAY_CANDLE.defaultBlockState());
                break;
            }
            case "light_gray_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.LIGHT_GRAY_CANDLE.defaultBlockState());
                break;
            }
            case "cyan_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.CYAN_CANDLE.defaultBlockState());
                break;
            }
            case "purple_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.PURPLE_CANDLE.defaultBlockState());
                break;
            }
            case "blue_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.BLUE_CANDLE.defaultBlockState());
                break;
            }
            case "brown_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.BROWN_CANDLE.defaultBlockState());
                break;
            }
            case "green_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.GREEN_CANDLE.defaultBlockState());
                break;
            }
            case "red_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.RED_CANDLE.defaultBlockState());
                break;
            }
            case "black_candle": {
                this.putCandles(parameters, random, level, pos, Blocks.BLACK_CANDLE.defaultBlockState());
                break;
            }
            case "water_cauldron": {
                this.putWaterCauldron(parameters, random, level, pos);
                break;
            }
            case "zombie_trap": {
                this.putZombieTrap(random, level, pos);
                break;
            }
            case "wrought_iron_post": {
                level.setBlock(pos, (BlockState)((WroughtIronFenceBlock)((Object)TFBlocks.WROUGHT_IRON_FENCE.value())).defaultBlockState().setValue(WroughtIronFenceBlock.POST, (Comparable)((Object)WroughtIronFenceBlock.PostState.POST)), 2);
                level.getChunk(pos).markPosForPostprocessing(pos);
                break;
            }
            case "empty_lectern": {
                Rotation stateRotation = this.placeSettings.getRotation().getRotated(dataRotation);
                level.setBlock(pos, Blocks.LECTERN.defaultBlockState().rotate(stateRotation), 2);
                break;
            }
            case "candled_lectern": {
                if (random.nextInt(4) != 0) {
                    this.putCandles(parameters, random, level, pos.above(), Blocks.CANDLE.defaultBlockState());
                } else {
                    this.putHeadCandles(pos.above(), level, random, parameters, (Block)TFBlocks.SKELETON_SKULL_CANDLE.value(), dataRotation);
                }
                Rotation stateRotation = this.placeSettings.getRotation().getRotated(dataRotation);
                level.setBlock(pos, Blocks.LECTERN.defaultBlockState().rotate(stateRotation), 2);
                break;
            }
            default: {
                Rotation stateRotation = this.placeSettings.getRotation().getRotated(dataRotation);
                BlockState blockState = this.blockFromLabel(parameters[0]).rotate(stateRotation);
                if (!blockState.isAir()) {
                    level.setBlock(pos, blockState, 2);
                    break;
                }
                if (FMLLoader.isProduction()) break;
                TwilightForestMod.LOGGER.warn("Variation label {} ({}) obtained {} in {}", (Object)parameters[0], (Object)parameters, (Object)blockState, (Object)this.templateName);
            }
        }
    }

    private void putMasonJar(BlockPos pos, WorldGenLevel level, RandomSource random, String[] parameters) {
        BlockEntity blockEntity;
        BlockState jar = ((MasonJarBlock)((Object)TFBlocks.MASON_JAR.value())).defaultBlockState();
        level.setBlock(pos, jar, 2);
        if (parameters.length >= 2 && (blockEntity = level.getBlockEntity(pos)) instanceof MasonJarBlockEntity) {
            ResourceKey lootTableId;
            String label;
            MasonJarBlockEntity jarEntity = (MasonJarBlockEntity)blockEntity;
            switch (label = parameters[1]) {
                case "jar": {
                    ResourceKey resourceKey = TFLootTables.TOWER_JARS;
                    break;
                }
                case "room": {
                    ResourceKey resourceKey = TFLootTables.TOWER_ROOM;
                    break;
                }
                case "library": {
                    ResourceKey resourceKey = TFLootTables.TOWER_LIBRARY;
                    break;
                }
                case "potion": {
                    ResourceKey resourceKey = TFLootTables.TOWER_POTION;
                    break;
                }
                case "enchanting": {
                    ResourceKey resourceKey = TFLootTables.TOWER_ENCHANTING;
                    break;
                }
                default: {
                    ResourceKey resourceKey = lootTableId = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.bySeparator((String)label, (char)'.'));
                }
            }
            if (!jarEntity.fillFromLootTable((ResourceKey<LootTable>)lootTableId, random.nextLong(), level.getLevel())) {
                ResourceLocation itemId = ResourceLocation.bySeparator((String)label, (char)'.');
                jarEntity.getItemHandler().setItem(new ItemStack((ItemLike)level.registryAccess().registry(Registries.ITEM).map(reg -> arg_0 -> ((Registry)reg).get(arg_0)).orElse($ -> Items.AIR).apply(itemId)));
            }
            int itemRotation = this.placeSettings.getRotation().ordinal() * 4 + (parameters.length == 3 ? this.getHeadRotation(parameters[2], random) : 0);
            jarEntity.setItemRotation(Math.floorMod(itemRotation, 16));
        }
        if (level.getBlockState(pos.above()).is(TFBlocks.CANOPY_BOOKSHELF)) {
            level.setBlock(pos.above(), (BlockState)((Block)TFBlocks.CANOPY_SLAB.value()).defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP), 2);
        }
    }

    private void putBrewingStand(BlockPos pos, WorldGenLevel level, RandomSource random) {
        BlockState brewingStandBlock = (BlockState)((BlockState)((BlockState)Blocks.BREWING_STAND.defaultBlockState().setValue((Property)BrewingStandBlock.HAS_BOTTLE[0], (Comparable)Boolean.valueOf(true))).setValue((Property)BrewingStandBlock.HAS_BOTTLE[1], (Comparable)Boolean.valueOf(true))).setValue((Property)BrewingStandBlock.HAS_BOTTLE[2], (Comparable)Boolean.valueOf(true));
        level.setBlock(pos, brewingStandBlock, 2);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStandBE = (BrewingStandBlockEntity)blockEntity;
            ItemStack potionStack = new ItemStack((ItemLike)(random.nextInt(4) == 0 ? Items.SPLASH_POTION : Items.POTION));
            potionStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(switch (random.nextInt(7)) {
                case 6 -> Potions.STRONG_HEALING;
                case 4, 5 -> Potions.REGENERATION;
                case 1, 2, 3 -> Potions.HEALING;
                default -> Potions.WATER;
            }));
            for (int index = 0; index < 3; ++index) {
                brewingStandBE.setItem(index, potionStack.copy());
            }
            brewingStandBE.setItem(4, new ItemStack((ItemLike)Items.BLAZE_POWDER, random.nextIntBetweenInclusive(1, 5)));
            brewingStandBE.fuel = random.nextIntBetweenInclusive(10, 20);
        }
    }

    private void putSpawner(BlockPos pos, WorldGenLevel level, RandomSource random, String[] parameters) {
        level.setBlock(pos, Blocks.SPAWNER.defaultBlockState(), 2);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
            this.configureBaseSpawner(pos, random, parameters, spawner.getSpawner());
            if (parameters.length == 3 && StringUtils.isNumeric((CharSequence)parameters[2])) {
                spawner.getSpawner().spawnRange = Mth.clamp((int)Integer.parseInt(parameters[2]), (int)1, (int)16);
            }
        }
    }

    private void putSinisterSpawner(BlockPos pos, WorldGenLevel level, RandomSource random, String[] parameters) {
        level.setBlock(pos, ((Block)TFBlocks.SINISTER_SPAWNER.value()).defaultBlockState(), 2);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof SinisterSpawnerBlockEntity)) {
            return;
        }
        SinisterSpawnerBlockEntity spawner = (SinisterSpawnerBlockEntity)blockEntity;
        spawner.addParticle((ParticleOptions)TFParticleType.OMINOUS_FLAME.value(), false);
        spawner.setLootTable(TFLootTables.OMINOUS_SPAWNER_DROPS);
        this.configureBaseSpawner(pos, random, parameters, spawner.getSpawner());
        if (parameters.length >= 3 && StringUtils.isNumeric((CharSequence)parameters[2])) {
            spawner.getSpawner().spawnRange = Mth.clamp((int)Integer.parseInt(parameters[2]), (int)1, (int)16);
        }
        spawner.getSpawner().entityScanRange = parameters.length >= 4 && StringUtils.isNumeric((CharSequence)parameters[3]) ? Mth.clamp((int)Integer.parseInt(parameters[3]), (int)1, (int)32) : spawner.getSpawner().spawnRange;
    }

    private void configureBaseSpawner(BlockPos pos, RandomSource random, String[] parameters, BaseSpawner spawner) {
        EntityType<?> monster = this.pickRandomMob(random, parameters);
        CompoundTag entityToSpawn = new CompoundTag();
        entityToSpawn.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(monster).toString());
        SpawnData spawnData = new SpawnData(entityToSpawn, Optional.of(new SpawnData.CustomSpawnRules(new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(7)), new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(15)))), Optional.empty());
        spawner.setNextSpawnData(null, pos, spawnData);
    }

    private EntityType<?> pickRandomMob(RandomSource random, String[] parameters) {
        if (parameters.length >= 2) {
            String[] monsters = parameters[1].split(",");
            return monsters.length == 0 ? this.defaultRandomMob(random) : LichTowerWingRoom.randomMobFromParams(random, monsters);
        }
        return this.defaultRandomMob(random);
    }

    @NotNull
    private EntityType<?> defaultRandomMob(RandomSource random) {
        return switch (random.nextInt(10)) {
            case 7, 8, 9 -> EntityType.SKELETON;
            case 6 -> EntityType.SPIDER;
            case 5 -> EntityType.CAVE_SPIDER;
            case 4 -> (EntityType)TFEntities.HEDGE_SPIDER.value();
            case 3 -> (EntityType)TFEntities.SWARM_SPIDER.value();
            default -> EntityType.ZOMBIE;
        };
    }

    private static EntityType<?> randomMobFromParams(RandomSource random, String[] monsters) {
        String label;
        return switch (label = (String)Util.getRandom((Object[])monsters, (RandomSource)random)) {
            case "hedge_spider" -> (EntityType)TFEntities.HEDGE_SPIDER.value();
            case "swarm_spider" -> (EntityType)TFEntities.SWARM_SPIDER.value();
            default -> EntityType.byString((String)label).orElse(EntityType.ZOMBIE);
        };
    }

    private void putCandles(String[] parameters, RandomSource random, WorldGenLevel level, BlockPos pos, BlockState candle) {
        int amount = Math.min(4, parameters.length == 2 ? this.getCandleRanged(parameters[1], random) : random.nextIntBetweenInclusive(1, 3));
        if (amount <= 0) {
            return;
        }
        BlockState candles = (BlockState)((BlockState)candle.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(amount));
        level.setBlock(pos, candles, 2);
    }

    private void putWaterCauldron(String[] parameters, RandomSource random, WorldGenLevel level, BlockPos pos) {
        int amount = Math.min(3, parameters.length == 2 ? this.parseRange(parameters[1], random, 1, 3) : random.nextIntBetweenInclusive(1, 3));
        BlockState cauldron = amount <= 0 ? Blocks.CAULDRON.defaultBlockState() : (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)BlockStateProperties.LEVEL_CAULDRON, (Comparable)Integer.valueOf(amount));
        level.setBlock(pos, cauldron, 2);
    }

    private void putZombieTrap(RandomSource random, WorldGenLevel level, BlockPos pos) {
        WroughtIronFenceBlock.PostState postProperty = level.getBlockState(pos.above()).isAir() ? WroughtIronFenceBlock.PostState.CAPPED : WroughtIronFenceBlock.PostState.POST;
        BlockState fenceBlock = (BlockState)((WroughtIronFenceBlock)((Object)TFBlocks.WROUGHT_IRON_FENCE.value())).defaultBlockState().setValue(WroughtIronFenceBlock.POST, (Comparable)((Object)postProperty));
        level.setBlock(pos, fenceBlock, 2);
        level.getChunk(pos).markPosForPostprocessing(pos);
        Direction randomDirection = this.getRandomDirectionInsideChunk(level, random, pos);
        if (randomDirection.getAxis() == Direction.Axis.Y) {
            return;
        }
        BlockPos zombiePos = pos.relative(randomDirection, 1);
        LeashFenceKnotEntity knot = (LeashFenceKnotEntity)EntityUtil.createEntityIgnoreException((ServerLevelAccessor)level, EntityType.LEASH_KNOT);
        Zombie trapEntity = (Zombie)EntityUtil.createEntityIgnoreException((ServerLevelAccessor)level, EntityType.ZOMBIE);
        if (knot == null || trapEntity == null) {
            return;
        }
        knot.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        trapEntity.setPersistenceRequired();
        trapEntity.setLeashedTo((Entity)knot, false);
        trapEntity.moveTo((double)zombiePos.getX() + 0.5, (double)(zombiePos.getY() - 1), (double)zombiePos.getZ() + 0.5);
        trapEntity.setData(TFDataAttachments.LEASH_PATHFINDER_OVERRIDE, (Object)Unit.INSTANCE);
        level.addFreshEntity((Entity)trapEntity);
    }

    @NotNull
    private Direction getRandomDirectionInsideChunk(WorldGenLevel level, RandomSource random, BlockPos pos) {
        int xInChunk = SectionPos.sectionRelative((int)pos.getX());
        int zInChunk = SectionPos.sectionRelative((int)pos.getZ());
        List directions = Direction.Plane.HORIZONTAL.shuffledCopy(random);
        if (xInChunk == 0) {
            directions.remove(Direction.WEST);
        }
        if (zInChunk == 0) {
            directions.remove(Direction.NORTH);
        }
        if (xInChunk == 15) {
            directions.remove(Direction.EAST);
        }
        if (zInChunk == 15) {
            directions.remove(Direction.SOUTH);
        }
        if (directions.isEmpty()) {
            return Direction.UP;
        }
        Direction randomDirection = (Direction)Util.getRandom((List)directions, (RandomSource)random);
        return randomDirection;
    }

    private BlockState blockFromLabel(String label) {
        if (label.contains(".")) {
            return ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.bySeparator((String)label, (char)'.'))).defaultBlockState();
        }
        return ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)label))).defaultBlockState();
    }

    private void putChest(BlockPos pos, WorldGenLevel level, RandomSource random, String[] parameters, Rotation dataRotation, BlockState chestState) {
        BlockEntity blockEntity;
        Rotation stateRotation = this.placeSettings.getRotation().getRotated(dataRotation);
        BlockState chest = chestState.rotate(stateRotation);
        level.setBlock(pos, chest, 2);
        if (parameters.length == 2 && (blockEntity = level.getBlockEntity(pos)) instanceof RandomizableContainer) {
            RandomizableContainer lootBlock = (RandomizableContainer)blockEntity;
            ResourceKey lootTableId = switch (parameters[1]) {
                case "room" -> TFLootTables.TOWER_ROOM;
                case "library" -> TFLootTables.TOWER_LIBRARY;
                case "potion" -> TFLootTables.TOWER_POTION;
                case "enchanting" -> TFLootTables.TOWER_ENCHANTING;
                default -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.bySeparator((String)parameters[1], (char)'.'));
            };
            lootBlock.setLootTable(lootTableId, random.nextLong());
        }
        if (level.getBlockState(pos.above()).is(TFBlocks.CANOPY_BOOKSHELF)) {
            level.setBlock(pos.above(), (BlockState)((Block)TFBlocks.CANOPY_SLAB.value()).defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP), 2);
        }
    }

    private void putTrappableBookshelf(BlockPos pos, WorldGenLevel level, RegistryAccess registryAccess, RandomSource random, Rotation dataRotation) {
        boolean isHostile = random.nextInt(12) == 0;
        Rotation stateRotation = this.placeSettings.getRotation().getRotated(dataRotation);
        BlockState shelf = ((BlockState)((Block)TFBlocks.CHISELED_CANOPY_BOOKSHELF.value()).defaultBlockState().setValue((Property)ChiseledCanopyShelfBlock.SPAWNER, (Comparable)Boolean.valueOf(isHostile))).rotate(stateRotation);
        IntArrayList filledSlots = new IntArrayList();
        for (int index = 0; index < 6; ++index) {
            if (random.nextInt(3) == 0) continue;
            filledSlots.add(index);
            shelf = (BlockState)shelf.setValue((Property)ChiseledCanopyShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(index), (Comparable)Boolean.valueOf(true));
        }
        level.setBlock(pos, shelf, 2);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ChiseledCanopyShelfBlockEntity) {
            ChiseledCanopyShelfBlockEntity shelfBlockEntity = (ChiseledCanopyShelfBlockEntity)blockEntity;
            blockEntity = filledSlots.iterator();
            while (blockEntity.hasNext()) {
                int index = (Integer)blockEntity.next();
                ItemStack book = isHostile || random.nextInt(16) != 0 ? new ItemStack((ItemLike)Items.BOOK) : EnchantmentHelper.enchantItem((RandomSource)random, (ItemStack)new ItemStack((ItemLike)Items.BOOK), (int)random.nextIntBetweenInclusive(1, 40), (RegistryAccess)registryAccess, Optional.empty());
                shelfBlockEntity.items.set(index, (Object)book);
            }
            if (isHostile) {
                shelfBlockEntity.getSpawner().setEntityId((EntityType)TFEntities.DEATH_TOME.value(), null, random, pos);
            }
        }
    }

    private void putHead(BlockPos pos, WorldGenLevel level, RandomSource random, String[] parameters, Block headBlock, Rotation dataRotation) {
        int rotation = parameters.length >= 2 ? this.getHeadRotation(parameters[1], random) : random.nextIntBetweenInclusive(0, 15);
        Rotation stateRotation = this.placeSettings.getRotation().getRotated(dataRotation.getRotated(Rotation.CLOCKWISE_180));
        BlockState candledHeadState = ((BlockState)headBlock.defaultBlockState().setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rotation))).rotate(stateRotation);
        level.setBlock(pos, candledHeadState, 2);
    }

    private void putHeadCandles(BlockPos pos, WorldGenLevel level, RandomSource random, String[] parameters, Block candledHeadBlock, Rotation dataRotation) {
        int amount = Math.min(4, parameters.length >= 2 ? this.getCandleRanged(parameters[1], random) : random.nextIntBetweenInclusive(1, 3));
        if (amount <= 0) {
            return;
        }
        int rotation = parameters.length >= 3 ? this.getHeadRotation(parameters[2], random) : random.nextIntBetweenInclusive(0, 15);
        Rotation stateRotation = this.placeSettings.getRotation().getRotated(dataRotation.getRotated(Rotation.CLOCKWISE_180));
        BlockState candledHeadState = ((BlockState)((BlockState)((BlockState)candledHeadBlock.defaultBlockState().setValue((Property)SkullCandleBlock.LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NORMAL))).setValue((Property)BlockStateProperties.CANDLES, (Comparable)Integer.valueOf(amount))).setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rotation))).rotate(stateRotation);
        level.setBlock(pos, candledHeadState, 2);
    }

    private int getCandleRanged(String amountLabel, RandomSource random) {
        return this.parseRange(amountLabel, random, 1, 3);
    }

    private int parseRange(String amountLabel, RandomSource random, int defaultMin, int defaultMax) {
        String[] amountParams = amountLabel.split("-");
        if (amountParams.length == 1 && StringUtils.isNumeric((CharSequence)amountParams[0])) {
            return Integer.parseInt(amountParams[0]);
        }
        if (amountParams.length == 2 && StringUtils.isNumeric((CharSequence)amountParams[0]) && StringUtils.isNumeric((CharSequence)amountParams[1])) {
            return random.nextIntBetweenInclusive(Integer.parseInt(amountParams[0]), Integer.parseInt(amountParams[1]));
        }
        return random.nextIntBetweenInclusive(defaultMin, defaultMax);
    }

    private int getHeadRotation(String amountLabel, RandomSource random) {
        String[] amountParams = amountLabel.split("\\+");
        if (amountParams.length == 1 && StringUtils.isNumeric((CharSequence)amountParams[0])) {
            return Integer.parseInt(amountParams[0]);
        }
        if (amountParams.length == 2 && StringUtils.isNumeric((CharSequence)amountParams[0]) && StringUtils.isNumeric((CharSequence)amountParams[1])) {
            int src = Integer.parseInt(amountParams[0]);
            int extra = Integer.parseInt(amountParams[1]);
            return Math.floorMod(random.nextIntBetweenInclusive(src, src + extra), 16);
        }
        return random.nextIntBetweenInclusive(0, 15);
    }

    private void putTrappableLectern(BlockPos pos, WorldGenLevel level, Rotation dataRotation, boolean putMimic) {
        Rotation stateRotation = this.placeSettings.getRotation().getRotated(dataRotation);
        BlockState lectern = ((BlockState)Blocks.LECTERN.defaultBlockState().setValue((Property)LecternBlock.HAS_BOOK, (Comparable)Boolean.valueOf(!putMimic))).rotate(stateRotation);
        level.setBlock(pos, lectern, 2);
        if (putMimic) {
            DeathTome tomeMimic = (DeathTome)((EntityType)TFEntities.DEATH_TOME.value()).create((Level)level.getLevel());
            if (tomeMimic != null) {
                tomeMimic.setPersistenceRequired();
                tomeMimic.moveTo(pos, ((Direction)lectern.getValue((Property)HorizontalDirectionalBlock.FACING)).toYRot(), 0.0f);
                tomeMimic.setOnLectern(true);
                tomeMimic.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(tomeMimic.blockPosition()), MobSpawnType.STRUCTURE, null);
                level.addFreshEntityWithPassengers((Entity)tomeMimic);
            }
        } else {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof LecternBlockEntity) {
                LecternBlockEntity lecternBlockEntity = (LecternBlockEntity)blockEntity;
                lecternBlockEntity.setBook(new ItemStack((ItemLike)Items.WRITABLE_BOOK));
            }
        }
    }

    @Override
    public BoundingBox getBeardifierBox() {
        return this.boundingBox;
    }

    @Override
    public TerrainAdjustment getTerrainAdjustment() {
        return TerrainAdjustment.NONE;
    }

    @Override
    public int getGroundLevelDelta() {
        return 0;
    }

    @Override
    public int getSpawnIndex() {
        return 1;
    }
}

