/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BaseCakeBlock
extends Block {
    public final IntegerProperty bite;
    public final int maxBite;
    public final boolean plate;

    public BaseCakeBlock(BlockBehaviour.Properties properties, IntegerProperty bite, int max, boolean plate) {
        super(properties);
        this.bite = bite;
        this.maxBite = max;
        this.plate = plate;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)bite, (Comparable)Integer.valueOf(max))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected abstract void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var1);

    protected abstract void eat(Player var1);

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide && this.eat(level, pos, state, player).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        return this.eat(level, pos, state, player);
    }

    protected InteractionResult eat(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        int i = (Integer)state.getValue((Property)this.bite);
        if (i > 0) {
            this.eat(player);
            level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.bite, (Comparable)Integer.valueOf(i - 1)));
        } else {
            if (!this.plate) {
                this.eat(player);
                level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
            }
            level.playSound(null, pos, SoundEvents.WOOD_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.destroyBlock(pos, true);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState other, LevelAccessor level, BlockPos selfPos, BlockPos otherPos) {
        return direction == Direction.DOWN && !state.canSurvive((LevelReader)level, selfPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, other, level, selfPos, otherPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue((Property)this.bite) * 2;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

