/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import dev.xkmc.fruitsdelight.content.block.BaseBushBlock;
import dev.xkmc.fruitsdelight.init.plants.FDBushType;
import dev.xkmc.l2harvester.api.HarvestResult;
import dev.xkmc.l2harvester.api.HarvestableBlock;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FruitBushBlock
extends BaseBushBlock
implements HarvestableBlock {
    private static final VoxelShape SMALL = Shapes.or((VoxelShape)Block.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), (VoxelShape)Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0));
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), (VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)3.0, (double)10.0));
    private static final VoxelShape SAPLING_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape MID_GROWTH_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private final Supplier<Item> item;
    private final FDBushType type;

    public FruitBushBlock(BlockBehaviour.Properties properties, Supplier<Item> item, FDBushType type) {
        super(properties);
        this.item = item;
        this.type = type;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(2)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean flag;
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl = flag = i == 4;
        if (flag) {
            int j = 1 + level.random.nextInt(2);
            FruitBushBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.item.get(), j));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState blockstate = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2));
            level.setBlock(pos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        int age = (Integer)state.getValue((Property)AGE);
        if (this.type == FDBushType.CROSS) {
            return age <= 1 ? SAPLING_SHAPE : (age <= 3 ? MID_GROWTH_SHAPE : Shapes.block());
        }
        return age <= 1 ? SMALL : SHAPE;
    }

    @Nullable
    public HarvestResult getHarvestResult(Level level, BlockState state, BlockPos pos) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 4) {
            return null;
        }
        int j = 1 + level.random.nextInt(2);
        return new HarvestResult((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2)), List.of(new ItemStack((ItemLike)this.item.get(), j)));
    }
}

