/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.effects;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public abstract class RangeSearchEffect
extends MobEffect {
    public <T extends Entity> List<T> getEntitiesInRange(LivingEntity center, Class<T> cls) {
        Vec3 pos = center.position();
        return center.level().getEntitiesOfClass(cls, center.getBoundingBox().inflate((double)this.getRange()), e -> true).stream().sorted(Comparator.comparingDouble(entcnd -> entcnd.distanceToSqr(pos))).collect(Collectors.toList());
    }

    protected RangeSearchEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    protected abstract int getRange();

    protected int getPeriod() {
        return 10;
    }

    protected boolean applicable(LivingEntity entity) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity.level().isClientSide()) {
            return true;
        }
        if (entity.tickCount % this.getPeriod() == 0) {
            this.searchEntities(entity, amplifier);
        }
        return true;
    }

    protected void searchEntities(LivingEntity entity, int amplifier) {
        for (LivingEntity e : this.getEntitiesInRange(entity, LivingEntity.class)) {
            if (e == entity || !this.applicable(e)) continue;
            this.applyEffect(entity, e, amplifier);
        }
    }

    public boolean shouldApplyEffectTickThisTick(int tick, int amplifier) {
        return true;
    }

    protected abstract void applyEffect(LivingEntity var1, LivingEntity var2, int var3);
}

