/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.bandlands;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.duck.SurfaceSystemAccessor;
import dev.worldgen.lithostitched.worldgen.bandlands.band.Band;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceSystem;

public final class Bandlands {
    public static final Codec<Bandlands> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.CODEC.fieldOf("base").forGetter(Bandlands::base), (App)Band.CODEC.listOf().fieldOf("bands").forGetter(Bandlands::bands)).apply((Applicative)instance, Bandlands::new));
    private final BlockState base;
    private final List<Band> bands;
    private BlockState[] filledBandlands;

    public Bandlands(BlockState base, List<Band> bands) {
        this.base = base;
        this.bands = bands;
    }

    public BlockState base() {
        return this.base;
    }

    public List<Band> bands() {
        return this.bands;
    }

    public BlockState getBand(SurfaceSystem system, int x, int y, int z) {
        if (this.filledBandlands == null) {
            return this.base;
        }
        int i = (int)Math.round(((SurfaceSystemAccessor)system).getBandOffsetNoise().getValue((double)x, 0.0, (double)z) * 4.0);
        return this.filledBandlands[(y + i + this.filledBandlands.length) % this.filledBandlands.length];
    }

    public void fillBands(RandomSource random) {
        if (this.filledBandlands != null) {
            return;
        }
        Object[] states = new BlockState[192];
        Arrays.fill(states, this.base);
        for (Band band : this.bands) {
            band.fill((BlockState[])states, random);
        }
        this.filledBandlands = states;
    }
}

