/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.mojang.serialization.MapCodec;
import dev.worldgen.lithostitched.worldgen.structure.DelegatingConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;

public class DelegatingStructure
extends Structure {
    public static final MapCodec<DelegatingStructure> CODEC = DelegatingConfig.CODEC.xmap(DelegatingStructure::new, DelegatingStructure::config);
    public static final StructureType<DelegatingStructure> TYPE = () -> CODEC;
    private final DelegatingConfig config;

    public DelegatingStructure(DelegatingConfig config) {
        super(DelegatingStructure.createSettings(config));
        this.config = config;
    }

    public DelegatingConfig config() {
        return this.config;
    }

    public Structure delegate() {
        return (Structure)this.config.delegate().value();
    }

    public Optional<Structure.GenerationStub> findValidGenerationPoint(Structure.GenerationContext context) {
        return this.findGenerationPoint(context).filter(generationPoint -> this.isValid((Structure.GenerationStub)generationPoint, context));
    }

    private boolean isValid(Structure.GenerationStub stub, Structure.GenerationContext context) {
        BlockPos pos = stub.position();
        if (!context.validBiome().test(context.chunkGenerator().getBiomeSource().getNoiseBiome(QuartPos.fromBlock((int)pos.getX()), QuartPos.fromBlock((int)pos.getY()), QuartPos.fromBlock((int)pos.getZ()), context.randomState().sampler()))) {
            return false;
        }
        return this.config.spawnCondition().test(context, pos);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return this.delegate().findValidGenerationPoint(context);
    }

    public void afterPlace(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, PiecesContainer container) {
        this.delegate().afterPlace(level, structureManager, generator, random, box, chunkPos, container);
    }

    public StructureType<?> type() {
        return TYPE;
    }

    private static Structure.StructureSettings createSettings(DelegatingConfig config) {
        Structure delegate = (Structure)config.delegate().value();
        return new Structure.StructureSettings(delegate.biomes(), delegate.spawnOverrides(), delegate.step(), delegate.terrainAdaptation());
    }
}

