/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.registry.common.particle;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.particle.screen.LodestoneScreenParticleType;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleOptions;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;

public class LodestoneScreenParticleTypes {
    public static final ArrayList<ScreenParticleType<?>> PARTICLE_TYPES = new ArrayList();
    public static final ScreenParticleType<ScreenParticleOptions> WISP = LodestoneScreenParticleTypes.registerType(new LodestoneScreenParticleType());
    public static final ScreenParticleType<ScreenParticleOptions> SMOKE = LodestoneScreenParticleTypes.registerType(new LodestoneScreenParticleType());
    public static final ScreenParticleType<ScreenParticleOptions> SPARKLE = LodestoneScreenParticleTypes.registerType(new LodestoneScreenParticleType());
    public static final ScreenParticleType<ScreenParticleOptions> TWINKLE = LodestoneScreenParticleTypes.registerType(new LodestoneScreenParticleType());
    public static final ScreenParticleType<ScreenParticleOptions> STAR = LodestoneScreenParticleTypes.registerType(new LodestoneScreenParticleType());

    public static void registerParticleFactory(RegisterParticleProvidersEvent event) {
        LodestoneScreenParticleTypes.registerProvider(WISP, new LodestoneScreenParticleType.Factory(LodestoneScreenParticleTypes.getSpriteSet(LodestoneLib.lodestonePath("wisp"))));
        LodestoneScreenParticleTypes.registerProvider(SMOKE, new LodestoneScreenParticleType.Factory(LodestoneScreenParticleTypes.getSpriteSet(LodestoneLib.lodestonePath("smoke"))));
        LodestoneScreenParticleTypes.registerProvider(SPARKLE, new LodestoneScreenParticleType.Factory(LodestoneScreenParticleTypes.getSpriteSet(LodestoneLib.lodestonePath("sparkle"))));
        LodestoneScreenParticleTypes.registerProvider(TWINKLE, new LodestoneScreenParticleType.Factory(LodestoneScreenParticleTypes.getSpriteSet(LodestoneLib.lodestonePath("twinkle"))));
        LodestoneScreenParticleTypes.registerProvider(STAR, new LodestoneScreenParticleType.Factory(LodestoneScreenParticleTypes.getSpriteSet(LodestoneLib.lodestonePath("star"))));
    }

    public static <T extends ScreenParticleOptions> ScreenParticleType<T> registerType(ScreenParticleType<T> type) {
        PARTICLE_TYPES.add(type);
        return type;
    }

    public static <T extends ScreenParticleOptions> void registerProvider(ScreenParticleType<T> type, ScreenParticleType.ParticleProvider<T> provider) {
        type.provider = provider;
    }

    public static SpriteSet getSpriteSet(ResourceLocation resourceLocation) {
        return (SpriteSet)Minecraft.getInstance().particleEngine.spriteSets.get(resourceLocation);
    }
}

