/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.attribute;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.systems.attribute.LodestoneAttributeBuilder;

public class LodestoneAttribute
extends Attribute {
    private final ResourceLocation id;
    private final boolean isBase;
    private final boolean forcePercentage;

    public static LodestoneAttributeBuilder create(ResourceLocation id, double defaultValue) {
        return new LodestoneAttributeBuilder(id, defaultValue);
    }

    protected LodestoneAttribute(ResourceLocation id, double defaultValue, boolean isBase, boolean forcePercentage) {
        super("attribute.name." + id.getNamespace() + "." + id.getPath(), defaultValue);
        this.id = id;
        this.isBase = isBase;
        this.forcePercentage = forcePercentage;
    }

    @Nullable
    public ResourceLocation getBaseId() {
        return this.isBase ? this.id : null;
    }

    public MutableComponent toValueComponent(@Nullable AttributeModifier.Operation op, double value, TooltipFlag flag) {
        if (this.forcePercentage) {
            return Component.translatable((String)"neoforge.value.percent", (Object[])new Object[]{FORMAT.format(value * 100.0)});
        }
        return Component.translatable((String)"neoforge.value.flat", (Object[])new Object[]{FORMAT.format(value)});
    }
}

