/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.render_types;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import team.lodestar.lodestone.registry.client.LodestoneShaders;

public interface LodestoneScreenParticleRenderType {
    public static final LodestoneScreenParticleRenderType ADDITIVE = new LodestoneScreenParticleRenderType(){

        @Override
        public BufferBuilder begin(Tesselator tesselator, TextureManager manager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)1);
            RenderSystem.setShader(LodestoneShaders.SCREEN_PARTICLE.getInstance());
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        }

        @Override
        public void end(BufferBuilder builder) {
            MeshData meshdata = builder.build();
            if (meshdata != null) {
                BufferUploader.drawWithShader((MeshData)meshdata);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        }
    };
    public static final LodestoneScreenParticleRenderType TRANSPARENT = new LodestoneScreenParticleRenderType(){

        @Override
        public BufferBuilder begin(Tesselator tesselator, TextureManager manager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(LodestoneShaders.SCREEN_PARTICLE.getInstance());
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        }

        @Override
        public void end(BufferBuilder builder) {
            MeshData meshdata = builder.build();
            if (meshdata != null) {
                BufferUploader.drawWithShader((MeshData)meshdata);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        }
    };
    public static final LodestoneScreenParticleRenderType LUMITRANSPARENT = new LodestoneScreenParticleRenderType(){

        @Override
        public BufferBuilder begin(Tesselator tesselator, TextureManager manager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            Supplier<ShaderInstance> instance = LodestoneShaders.SCREEN_PARTICLE.getInstance();
            RenderSystem.setShader(instance);
            instance.get().safeGetUniform("LumiTransparency").set(1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        }

        @Override
        public void end(BufferBuilder builder) {
            MeshData meshdata = builder.build();
            if (meshdata != null) {
                BufferUploader.drawWithShader((MeshData)meshdata);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            Supplier<ShaderInstance> instance = LodestoneShaders.SCREEN_PARTICLE.getInstance();
            instance.get().safeGetUniform("LumiTransparency").set(0.0f);
        }
    };

    public BufferBuilder begin(Tesselator var1, TextureManager var2);

    public void end(BufferBuilder var1);
}

