/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.rendeertype;

import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.resources.ResourceLocation;

public class RenderTypeToken
implements Supplier<RenderStateShard.EmptyTextureStateShard> {
    private static final HashMap<ResourceLocation, RenderTypeToken> CACHED_TEXTURE_TOKENS = new HashMap();
    private static final HashMap<RenderStateShard.EmptyTextureStateShard, RenderTypeToken> CACHED_STATE_TOKENS = new HashMap();
    private final UUID identifier = UUID.randomUUID();
    private final RenderStateShard.EmptyTextureStateShard texture;

    protected RenderTypeToken(ResourceLocation texture) {
        this((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false));
    }

    protected RenderTypeToken(RenderStateShard.EmptyTextureStateShard texture) {
        this.texture = texture;
    }

    public static RenderTypeToken createToken(ResourceLocation texture) {
        return CACHED_TEXTURE_TOKENS.computeIfAbsent(texture, RenderTypeToken::new);
    }

    public static RenderTypeToken createToken(RenderStateShard.EmptyTextureStateShard texture) {
        return CACHED_STATE_TOKENS.computeIfAbsent(texture, RenderTypeToken::new);
    }

    @Deprecated(forRemoval=true)
    public static RenderTypeToken createCachedToken(ResourceLocation texture) {
        return RenderTypeToken.createToken(texture);
    }

    @Deprecated(forRemoval=true)
    public static RenderTypeToken createCachedToken(RenderStateShard.EmptyTextureStateShard texture) {
        return RenderTypeToken.createToken(texture);
    }

    @Override
    public RenderStateShard.EmptyTextureStateShard get() {
        return this.texture;
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.texture);
    }
}

