/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.rendering.shader.compute;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLCapabilities;

@EventBusSubscriber(value={Dist.CLIENT}, modid="lodestone", bus=EventBusSubscriber.Bus.MOD)
public class SystemDetails {
    private static String VENDOR;
    private static String RENDERER;
    private static String VERSION;
    private static String SHADING_LANGUAGE_VERSION;
    private static boolean COMPUTE_SUPPORTED;
    private static boolean SSBO_SUPPORTED;
    private static int MAX_SSBO_BINDINGS;
    private static int MAX_SHADER_STORAGE_BLOCK_SIZE;

    public static String getVendor() {
        return VENDOR;
    }

    public static String getRenderer() {
        return RENDERER;
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getShadingLanguageVersion() {
        return SHADING_LANGUAGE_VERSION;
    }

    public static boolean isComputeSupported() {
        return COMPUTE_SUPPORTED;
    }

    public static boolean isSsboSupported() {
        return SSBO_SUPPORTED;
    }

    public static int getMaxSsboBindings() {
        return MAX_SSBO_BINDINGS;
    }

    public static int getMaxShaderStorageBlockSize() {
        return MAX_SHADER_STORAGE_BLOCK_SIZE;
    }

    @SubscribeEvent
    public static void fetchDeviceData(RegisterShadersEvent event) {
        VENDOR = GL43.glGetString((int)7936);
        RENDERER = GL43.glGetString((int)7937);
        VERSION = GL43.glGetString((int)7938);
        SHADING_LANGUAGE_VERSION = GL43.glGetString((int)35724);
        GLCapabilities caps = GL.getCapabilities();
        COMPUTE_SUPPORTED = caps.OpenGL43 || caps.GL_ARB_compute_shader;
        SSBO_SUPPORTED = caps.OpenGL43 || caps.GL_ARB_shader_storage_buffer_object;
        MAX_SSBO_BINDINGS = SSBO_SUPPORTED ? GL43.glGetInteger((int)37085) : 0;
        MAX_SHADER_STORAGE_BLOCK_SIZE = SSBO_SUPPORTED ? GL43.glGetInteger((int)37086) : 0;
    }

    static {
        COMPUTE_SUPPORTED = false;
        SSBO_SUPPORTED = false;
        MAX_SSBO_BINDINGS = -1;
        MAX_SHADER_STORAGE_BLOCK_SIZE = -1;
    }
}

