/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.eternalnether.world.entity.monster.piglin.PiglinHunter;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;

public class PiglinHunterModel
extends PiglinModel<PiglinHunter> {
    private final ModelPart hoglinSkull;

    public PiglinHunterModel(ModelPart root) {
        super(root);
        this.hoglinSkull = root.getChild("hoglin_skull");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = PiglinModel.createMesh((CubeDeformation)CubeDeformation.NONE);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("hoglin_skull", CubeListBuilder.create().texOffs(61, 1).addBox(-7.0f, 16.5f, 0.0f, 14.0f, 6.0f, 19.0f, new CubeDeformation(-0.9f)).texOffs(61, 3).addBox(5.0f, 11.5f, 0.0f, 2.0f, 11.0f, 2.0f, CubeDeformation.NONE).texOffs(70, 3).addBox(-7.0f, 11.5f, 0.0f, 2.0f, 11.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)15.5f, (float)25.0f, (float)-1.6581f, (float)0.0f, (float)3.1416f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(PiglinHunter piglinHunter, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((Mob)piglinHunter, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.hoglinSkull.y = piglinHunter.isPassenger() ? 10.5f : 15.5f;
        if (piglinHunter.isAlive() && piglinHunter.isUsingShield()) {
            boolean flag = piglinHunter.getMainArm() == HumanoidArm.RIGHT;
            if (piglinHunter.getShieldHand() == InteractionHand.MAIN_HAND == flag) {
                this.poseRightArmShield();
            } else if (piglinHunter.getShieldHand() == InteractionHand.OFF_HAND == flag) {
                this.poseLeftArmShield();
            }
        }
    }

    private void poseRightArmShield() {
        this.rightArm.xRot = -0.9424779f;
        this.rightArm.yRot = -0.5235988f;
    }

    private void poseLeftArmShield() {
        this.leftArm.xRot = -0.9424779f;
        this.leftArm.yRot = 0.5235988f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        super.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
        this.hoglinSkull.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

