/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import fuzs.eternalnether.world.entity.monster.piglin.PiglinPrisoner;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class ModStopAdmiringIfItemTooFarAway<E extends PiglinPrisoner>
extends Behavior<E> {
    private final int maxDistanceToItem;

    public ModStopAdmiringIfItemTooFarAway(int maxDistanceToItem) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ADMIRING_ITEM, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)MemoryStatus.REGISTERED));
        this.maxDistanceToItem = maxDistanceToItem;
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, E piglinPrisoner) {
        if (!piglinPrisoner.getOffhandItem().isEmpty()) {
            return false;
        }
        Optional optional = ((PiglinPrisoner)((Object)piglinPrisoner)).getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM);
        return optional.map(itemEntity -> !itemEntity.closerThan((Entity)piglinPrisoner, (double)this.maxDistanceToItem)).orElse(true);
    }

    protected void start(ServerLevel serverLevel, E piglinPrisoner, long gameTime) {
        ((PiglinPrisoner)((Object)piglinPrisoner)).getBrain().eraseMemory(MemoryModuleType.ADMIRING_ITEM);
    }
}

