/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.level.levelgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.eternalnether.init.ModStructures;
import fuzs.eternalnether.util.ModStructureUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class CitadelStructure
extends Structure {
    public static final MapCodec<CitadelStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CitadelStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, CitadelStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public CitadelStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public GenerationStep.Decoration step() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static boolean checkLocation(Structure.GenerationContext context) {
        BlockPos blockpos = context.chunkPos().getMiddleBlockPosition(0);
        NoiseColumn blockReader = context.chunkGenerator().getBaseColumn(blockpos.getX(), blockpos.getZ(), context.heightAccessor(), context.randomState());
        return CitadelStructure.checkChunk(context) && !ModStructureUtils.isLavaLake(blockReader) && ModStructureUtils.verticalSpace(blockReader, 34, ModStructureUtils.getScaledNetherHeight(context, 72), 12);
    }

    private static boolean checkChunk(Structure.GenerationContext context) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.setLargeFeatureSeed(context.seed(), context.chunkPos().x, context.chunkPos().z);
        return context.validBiome().test(context.chunkGenerator().getBiomeSource().getNoiseBiome(QuartPos.fromBlock((int)context.chunkPos().getMiddleBlockX()), QuartPos.fromBlock((int)64), QuartPos.fromBlock((int)context.chunkPos().getMiddleBlockZ()), context.randomState().sampler()));
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (CitadelStructure.checkLocation(context)) {
            BlockPos blockPos = ModStructureUtils.getElevation(context, 48, ModStructureUtils.getScaledNetherHeight(context, 70));
            return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (PoolAliasLookup)PoolAliasLookup.create(List.of(), (BlockPos)blockPos, (long)context.seed()), (DimensionPadding)JigsawStructure.DEFAULT_DIMENSION_PADDING, (LiquidSettings)JigsawStructure.DEFAULT_LIQUID_SETTINGS);
        }
        return Optional.empty();
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.CITADEL_STRUCTURE_TYPE.value();
    }
}

