/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.protect_your_moa.item.combat;

import com.aetherteam.aether.entity.ai.attribute.AetherAttributes;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.protect_your_moa.item.combat.MoaArmorItem;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GravititeMoaArmorItem
extends MoaArmorItem {
    public static final ResourceLocation TEXTURE_JUMPS = ResourceLocation.fromNamespaceAndPath((String)"aether_protect_your_moa", (String)"hud/jumps_gravitite");
    public static final ResourceLocation BONUS_JUMPS_ID = ResourceLocation.fromNamespaceAndPath((String)"aether_protect_your_moa", (String)"gravitite_moa_jumps");

    public GravititeMoaArmorItem() {
        super(11, "gravitite", new Item.Properties().stacksTo(1));
    }

    @Override
    public void tick(Moa moa, ItemStack itemStack) {
        AttributeInstance jumps = moa.getAttribute((Holder)AetherAttributes.MOA_MAX_JUMPS);
        if (jumps != null && !jumps.hasModifier(this.getJumpsModifier().id())) {
            jumps.addTransientModifier(this.getJumpsModifier());
        }
        super.tick(moa, itemStack);
    }

    @Override
    public void onUnequip(Moa moa, ItemStack itemStack) {
        AttributeInstance jumps = moa.getAttribute((Holder)AetherAttributes.MOA_MAX_JUMPS);
        if (jumps != null && jumps.hasModifier(this.getJumpsModifier().id())) {
            jumps.removeModifier(this.getJumpsModifier().id());
        }
        if (moa.getRemainingJumps() > moa.getMaxJumps()) {
            moa.setRemainingJumps(moa.getMaxJumps());
        }
        super.onUnequip(moa, itemStack);
    }

    public AttributeModifier getJumpsModifier() {
        return new AttributeModifier(BONUS_JUMPS_ID, 3.0, AttributeModifier.Operation.ADD_VALUE);
    }
}

