/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.biome.builder;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.regions_unexplored.data.worldgen.RuBiomeDefaultFeatures;
import net.regions_unexplored.data.worldgen.placement.RuTreePlacements;
import net.regions_unexplored.data.worldgen.placement.RuVegetationPlacements;

public class CoastalBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.clamp((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static MobSpawnSettings.Builder baseCoastSpawning(boolean hasTurtle) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 12, 4, 4));
        if (hasTurtle) {
            spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.TURTLE, 5, 2, 5));
        }
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder);
        return spawnBuilder;
    }

    private static BiomeGenerationSettings.Builder baseCoastGeneration(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomeBuilder);
        return biomeBuilder;
    }

    public static Biome chalkCliffs(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().skyColor(CoastalBiomes.calculateSkyColor(0.8f)).fogColor(12638463).waterColor(4159204).waterFogColor(329011).foliageColorOverride(-8414642).grassColorOverride(-6044317).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_FOREST));
        BiomeGenerationSettings.Builder biomeBuilder = CoastalBiomes.baseCoastGeneration(featureGetter, carverGetter);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.DAISY);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TASSEL_SPARSE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.FLOWERING_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = CoastalBiomes.baseCoastSpawning(false);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.775f).downfall(0.7f).specialEffects(effectBuilder.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome grassyBeach(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().skyColor(CoastalBiomes.calculateSkyColor(0.8f)).fogColor(12638463).waterColor(4159204).waterFogColor(329011).foliageColorOverride(-8933043).grassColorOverride(-2697863).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_FOREST));
        BiomeGenerationSettings.Builder biomeBuilder = CoastalBiomes.baseCoastGeneration(featureGetter, carverGetter);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.SANDY_GRASS_VEGETATION);
        MobSpawnSettings.Builder spawnBuilder = CoastalBiomes.baseCoastSpawning(true);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.85f).downfall(0.75f).specialEffects(effectBuilder.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome gravelBeach(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().skyColor(CoastalBiomes.calculateSkyColor(0.8f)).fogColor(12638463).waterColor(4159204).waterFogColor(329011).foliageColorOverride(-8673714).grassColorOverride(-7819420).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_FOREST));
        BiomeGenerationSettings.Builder biomeBuilder = CoastalBiomes.baseCoastGeneration(featureGetter, carverGetter);
        MobSpawnSettings.Builder spawnBuilder = CoastalBiomes.baseCoastSpawning(false);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.6f).downfall(0.6f).specialEffects(effectBuilder.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }
}

