/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class SakuraTreeFeature
extends Feature<RuTreeConfiguration> {
    public SakuraTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.config();
        BlockPos pos = context.origin();
        RandomSource randomSource = context.random();
        WorldGenLevel level = context.level();
        int limbDirection = context.random().nextInt(12);
        int height_main = context.random().nextInt(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        BlockPos.MutableBlockPos checkPos = pos.mutable();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            if (check == height_main && !this.placeLimbsCheck((LevelAccessor)level, (BlockPos)checkPos, limbDirection)) {
                return false;
            }
            checkPos.move(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            if (placeCheck == 0) {
                this.placeBase((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == height_main) {
                this.placeLimbs((LevelAccessor)level, (BlockPos)placePos, limbDirection, randomSource, treeConfiguration);
            }
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            placePos.move(Direction.UP);
        }
        return true;
    }

    public boolean placeLimbs(LevelAccessor level, BlockPos pos, int limbDirection, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (limbDirection == 0) {
            this.placeLog(level, pos.north(), randomSource, treeConfiguration);
            this.placeLog(level, pos.north().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.north().above().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.north().above().above().north(), randomSource, treeConfiguration);
            this.placeLog(level, pos.north().above().above().north().above(), randomSource, treeConfiguration);
            this.placeLeavesBlobLeft(level, pos.north().above().above().north().above(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.above().south(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.above().south().south(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.above().south().south().above().south(), randomSource, treeConfiguration);
            this.placeBeehive(level, pos.above().south().south().south(), Direction.SOUTH);
            this.placeLeavesBlobRight(level, pos.above().south().south().above().south(), randomSource, treeConfiguration);
        }
        if (limbDirection == 1) {
            this.placeLog(level, pos.south(), randomSource, treeConfiguration);
            this.placeLog(level, pos.south().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.south().above().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.south().above().above().south(), randomSource, treeConfiguration);
            this.placeLog(level, pos.south().above().above().south().above(), randomSource, treeConfiguration);
            this.placeLeavesBlobLeft(level, pos.south().above().above().south().above(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.above().north(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.above().north().north(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.above().north().north().above().north(), randomSource, treeConfiguration);
            this.placeBeehive(level, pos.above().north().north().north(), Direction.NORTH);
            this.placeLeavesBlobRight(level, pos.above().north().north().above().north(), randomSource, treeConfiguration);
        }
        if (limbDirection == 2) {
            this.placeLog(level, pos.east(), randomSource, treeConfiguration);
            this.placeLog(level, pos.east().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.east().above().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.east().above().above().east(), randomSource, treeConfiguration);
            this.placeLog(level, pos.east().above().above().east().above(), randomSource, treeConfiguration);
            this.placeLeavesBlobLeft(level, pos.east().above().above().east().above(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.above().west(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.above().west().west(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.above().west().west().above().west(), randomSource, treeConfiguration);
            this.placeBeehive(level, pos.above().west().west().west(), Direction.WEST);
            this.placeLeavesBlobRight(level, pos.above().west().west().above().west(), randomSource, treeConfiguration);
        }
        if (limbDirection == 3) {
            this.placeLog(level, pos.west(), randomSource, treeConfiguration);
            this.placeLog(level, pos.west().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.west().above().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.west().above().above().west(), randomSource, treeConfiguration);
            this.placeLog(level, pos.west().above().above().west().above(), randomSource, treeConfiguration);
            this.placeLeavesBlobLeft(level, pos.west().above().above().west().above(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.above().east(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.above().east().east(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.above().east().east().above().east(), randomSource, treeConfiguration);
            this.placeBeehive(level, pos.above().east().east().east(), Direction.EAST);
            this.placeLeavesBlobRight(level, pos.above().east().east().above().east(), randomSource, treeConfiguration);
        }
        if (limbDirection == 4) {
            this.placeLog(level, pos.east().north(), randomSource, treeConfiguration);
            this.placeLog(level, pos.east().north().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.east().north().above().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.east().east().north().above().above().north(), randomSource, treeConfiguration);
            this.placeLog(level, pos.east().east().north().above().above().north().above(), randomSource, treeConfiguration);
            this.placeLeavesBlobLeft(level, pos.east().east().north().above().above().north().above(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.west().above().south(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.west().above().south().south(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.west().west().above().south().south().above().south(), randomSource, treeConfiguration);
            this.placeBeehive(level, pos.west().west().above().south().south().south(), Direction.SOUTH);
            this.placeLeavesBlobRight(level, pos.west().west().above().south().south().above().south(), randomSource, treeConfiguration);
        }
        if (limbDirection == 5) {
            this.placeLog(level, pos.west().north(), randomSource, treeConfiguration);
            this.placeLog(level, pos.west().north().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.west().north().above().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.west().west().north().above().above().north(), randomSource, treeConfiguration);
            this.placeLog(level, pos.west().west().north().above().above().north().above(), randomSource, treeConfiguration);
            this.placeLeavesBlobLeft(level, pos.west().west().north().above().above().north().above(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.east().above().south(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.east().above().south().south(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.east().east().above().south().south().above().south(), randomSource, treeConfiguration);
            this.placeBeehive(level, pos.east().east().above().south().south().south(), Direction.SOUTH);
            this.placeLeavesBlobRight(level, pos.east().east().above().south().south().above().south(), randomSource, treeConfiguration);
        }
        if (limbDirection == 6) {
            this.placeLog(level, pos.east().south(), randomSource, treeConfiguration);
            this.placeLog(level, pos.east().south().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.east().south().above().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.east().east().south().above().above().south(), randomSource, treeConfiguration);
            this.placeLog(level, pos.east().east().south().above().above().south().above(), randomSource, treeConfiguration);
            this.placeLeavesBlobLeft(level, pos.east().east().south().above().above().south().above(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.west().above().north(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.west().above().north().north(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.west().west().above().north().north().above().north(), randomSource, treeConfiguration);
            this.placeBeehive(level, pos.west().west().above().north().north().north(), Direction.NORTH);
            this.placeLeavesBlobRight(level, pos.west().west().above().north().north().above().north(), randomSource, treeConfiguration);
        }
        if (limbDirection == 7) {
            this.placeLog(level, pos.west().south(), randomSource, treeConfiguration);
            this.placeLog(level, pos.west().south().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.west().south().above().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.west().west().south().above().above().south(), randomSource, treeConfiguration);
            this.placeLog(level, pos.west().west().south().above().above().south().above(), randomSource, treeConfiguration);
            this.placeLeavesBlobLeft(level, pos.west().west().south().above().above().south().above(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.east().above().north(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.east().above().north().north(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.east().east().above().north().north().above().north(), randomSource, treeConfiguration);
            this.placeBeehive(level, pos.east().east().above().north().north().north(), Direction.NORTH);
            this.placeLeavesBlobRight(level, pos.east().east().above().north().north().above().north(), randomSource, treeConfiguration);
        }
        if (limbDirection == 8) {
            this.placeLog(level, pos.north().east(), randomSource, treeConfiguration);
            this.placeLog(level, pos.north().east().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.north().east().above().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.north().north().east().above().above().east(), randomSource, treeConfiguration);
            this.placeLog(level, pos.north().north().east().above().above().east().above(), randomSource, treeConfiguration);
            this.placeLeavesBlobLeft(level, pos.north().north().east().above().above().east().above(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.south().above().west(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.south().above().west().west(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.south().south().above().west().west().above().west(), randomSource, treeConfiguration);
            this.placeBeehive(level, pos.south().south().above().west().west().west(), Direction.WEST);
            this.placeLeavesBlobRight(level, pos.south().south().above().west().west().above().west(), randomSource, treeConfiguration);
        }
        if (limbDirection == 9) {
            this.placeLog(level, pos.north().west(), randomSource, treeConfiguration);
            this.placeLog(level, pos.north().west().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.north().west().above().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.north().north().west().above().above().west(), randomSource, treeConfiguration);
            this.placeLog(level, pos.north().north().west().above().above().west().above(), randomSource, treeConfiguration);
            this.placeLeavesBlobLeft(level, pos.north().north().west().above().above().west().above(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.south().above().east(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.south().above().east().east(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.south().south().above().east().east().above().east(), randomSource, treeConfiguration);
            this.placeBeehive(level, pos.south().south().above().east().east().east(), Direction.EAST);
            this.placeLeavesBlobRight(level, pos.south().south().above().east().east().above().east(), randomSource, treeConfiguration);
        }
        if (limbDirection == 10) {
            this.placeLog(level, pos.south().east(), randomSource, treeConfiguration);
            this.placeLog(level, pos.south().east().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.south().east().above().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.south().south().east().above().above().east(), randomSource, treeConfiguration);
            this.placeLog(level, pos.south().south().east().above().above().east().above(), randomSource, treeConfiguration);
            this.placeLeavesBlobLeft(level, pos.south().south().east().above().above().east().above(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.north().above().west(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.north().above().west().west(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.north().north().above().west().west().above().west(), randomSource, treeConfiguration);
            this.placeBeehive(level, pos.north().north().above().west().west().west(), Direction.WEST);
            this.placeLeavesBlobRight(level, pos.north().north().above().west().west().above().west(), randomSource, treeConfiguration);
        }
        if (limbDirection == 11) {
            this.placeLog(level, pos.south().west(), randomSource, treeConfiguration);
            this.placeLog(level, pos.south().west().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.south().west().above().above(), randomSource, treeConfiguration);
            this.placeLog(level, pos.south().south().west().above().above().west(), randomSource, treeConfiguration);
            this.placeLog(level, pos.south().south().west().above().above().west().above(), randomSource, treeConfiguration);
            this.placeLeavesBlobLeft(level, pos.south().south().west().above().above().west().above(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.north().above().east(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.north().above().east().east(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.north().north().above().east().east().above().east(), randomSource, treeConfiguration);
            this.placeBeehive(level, pos.north().north().above().east().east().east(), Direction.EAST);
            this.placeLeavesBlobRight(level, pos.north().north().above().east().east().above().east(), randomSource, treeConfiguration);
        }
        return true;
    }

    public boolean placeBase(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int rot = random.nextInt(8);
        if (rot == 0) {
            this.placeLog(level, pos.north().east(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.north().east(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.south(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.south(), randomSource, treeConfiguration);
        }
        if (rot == 1) {
            this.placeLog(level, pos.north().west(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.north().west(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.south(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.south(), randomSource, treeConfiguration);
        }
        if (rot == 2) {
            this.placeLog(level, pos.south().east(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.south().east(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.north(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.north(), randomSource, treeConfiguration);
        }
        if (rot == 3) {
            this.placeLog(level, pos.south().west(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.south().west(), randomSource, treeConfiguration);
            this.placeLogZ(level, pos.north(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.north(), randomSource, treeConfiguration);
        }
        if (rot == 4) {
            this.placeLog(level, pos.east().north(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.east().north(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.west(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.west(), randomSource, treeConfiguration);
        }
        if (rot == 5) {
            this.placeLog(level, pos.east().south(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.east().south(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.west(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.west(), randomSource, treeConfiguration);
        }
        if (rot == 6) {
            this.placeLog(level, pos.west().north(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.west().north(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.east(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.east(), randomSource, treeConfiguration);
        }
        if (rot == 7) {
            this.placeLog(level, pos.west().south(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.west().south(), randomSource, treeConfiguration);
            this.placeLogX(level, pos.east(), randomSource, treeConfiguration);
            this.placeRoot(level, pos.east(), randomSource, treeConfiguration);
        }
        return true;
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (SakuraTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, treeConfiguration.trunkProvider.getState(randomSource, pos), 2);
        } else {
            return true;
        }
        if (level.getBlockState(pos.below()).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        }
        return true;
    }

    public boolean placeLogX(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (SakuraTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, (BlockState)treeConfiguration.trunkProvider.getState(randomSource, pos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X), 2);
        } else {
            return true;
        }
        if (level.getBlockState(pos.below()).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        }
        return true;
    }

    public boolean placeLogZ(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (SakuraTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, (BlockState)treeConfiguration.trunkProvider.getState(randomSource, pos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z), 2);
        } else {
            return true;
        }
        if (level.getBlockState(pos.below()).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        }
        return true;
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        int rd = 2;
        BlockPos.MutableBlockPos placePos = pos.below().mutable();
        for (int i = 0; i <= rd; ++i) {
            if (level.getBlockState((BlockPos)placePos).canBeReplaced() && level.getBlockState(placePos.above()).is(BlockTags.DIRT)) {
                level.setBlock((BlockPos)placePos, Blocks.HANGING_ROOTS.defaultBlockState(), 2);
                break;
            }
            if (!level.getBlockState((BlockPos)placePos).is(BlockTags.DIRT) && !level.getBlockState((BlockPos)placePos).is(BlockTags.REPLACEABLE_BY_TREES) && !level.isEmptyBlock((BlockPos)placePos)) break;
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration);
            placePos.move(Direction.DOWN);
        }
    }

    public boolean placeLeavesBlobLeft(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        this.placeLeavesTopLeft(level, pos, randomSource, treeConfiguration);
        this.placeLeavesMiddle(level, pos.above(), randomSource, treeConfiguration);
        this.placeLeavesTopLeft(level, pos.above().above(), randomSource, treeConfiguration);
        return true;
    }

    public boolean placeLeavesBlobRight(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        this.placeLeavesTopRight(level, pos, randomSource, treeConfiguration);
        this.placeLeavesMiddle(level, pos.above(), randomSource, treeConfiguration);
        this.placeLeavesTopRight(level, pos.above().above(), randomSource, treeConfiguration);
        return true;
    }

    public boolean placeLeavesMiddle(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().east().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().west().west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north().east().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north().west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north().west().west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north().north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north().north().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north().north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north().north().west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().east().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().west().west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south().east().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south().west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south().west().west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south().south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south().south().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south().south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south().south().west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().west().west(), randomSource, treeConfiguration);
        return true;
    }

    public boolean placeLeavesTopLeft(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().east().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().west().south(), randomSource, treeConfiguration);
        return true;
    }

    public void placeLeavesTopRight(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().east().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().west().north(), randomSource, treeConfiguration);
    }

    public void placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.isOutsideBuildHeight(pos)) {
            return;
        }
        if (level.getBlockState(pos).canBeReplaced()) {
            level.setBlock(pos, (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public boolean placeLimbsCheck(LevelAccessor level, BlockPos pos, int limbDirection) {
        if (limbDirection == 0) {
            if (!this.checkReplaceable(level, pos.north())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().above().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().above().above().north())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().above().above().north().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.above().south())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.above().south().south())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.above().south().south().above().south())) {
                return false;
            }
        }
        if (limbDirection == 1) {
            if (!this.checkReplaceable(level, pos.south())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().above().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().above().above().south())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().above().above().south().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.above().north())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.above().north().north())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.above().north().north().above().north())) {
                return false;
            }
        }
        if (limbDirection == 2) {
            if (!this.checkReplaceable(level, pos.east())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().above().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().above().above().east())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().above().above().east().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.above().west())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.above().west().west())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.above().west().west().above().west())) {
                return false;
            }
        }
        if (limbDirection == 3) {
            if (!this.checkReplaceable(level, pos.west())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().above().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().above().above().west())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().above().above().west().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.above().east())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.above().east().east())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.above().east().east().above().east())) {
                return false;
            }
        }
        if (limbDirection == 4) {
            if (!this.checkReplaceable(level, pos.east().north())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().north().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().north().above().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().east().north().above().above().north())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().east().north().above().above().north().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().above().south())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().above().south().south())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().west().above().south().south().above().south())) {
                return false;
            }
        }
        if (limbDirection == 5) {
            if (!this.checkReplaceable(level, pos.west().north())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().north().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().north().above().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().west().north().above().above().north())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().west().north().above().above().north().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().above().south())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().above().south().south())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().east().above().south().south().above().south())) {
                return false;
            }
        }
        if (limbDirection == 6) {
            if (!this.checkReplaceable(level, pos.east().south())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().south().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().south().above().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().east().south().above().above().south())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().east().south().above().above().south().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().above().north())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().above().north().north())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().west().above().north().north().above().north())) {
                return false;
            }
        }
        if (limbDirection == 7) {
            if (!this.checkReplaceable(level, pos.west().south())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().south().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().south().above().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().west().south().above().above().south())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.west().west().south().above().above().south().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().above().north())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().above().north().north())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.east().east().above().north().north().above().north())) {
                return false;
            }
        }
        if (limbDirection == 8) {
            if (!this.checkReplaceable(level, pos.north().east())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().east().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().east().above().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().north().east().above().above().east())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().north().east().above().above().east().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().above().west())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().above().west().west())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().south().above().west().west().above().west())) {
                return false;
            }
        }
        if (limbDirection == 9) {
            if (!this.checkReplaceable(level, pos.north().west())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().west().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().west().above().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().north().west().above().above().west())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().north().west().above().above().west().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().above().east())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().above().east().east())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().south().above().east().east().above().east())) {
                return false;
            }
        }
        if (limbDirection == 10) {
            if (!this.checkReplaceable(level, pos.south().east())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().east().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().east().above().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().south().east().above().above().east())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().south().east().above().above().east().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().above().west())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().above().west().west())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().north().above().west().west().above().west())) {
                return false;
            }
        }
        if (limbDirection == 11) {
            if (!this.checkReplaceable(level, pos.south().west())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().west().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().west().above().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().south().west().above().above().west())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.south().south().west().above().above().west().above())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().above().east())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().above().east().east())) {
                return false;
            }
            if (!this.checkReplaceable(level, pos.north().north().above().east().east().above().east())) {
                return false;
            }
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return false;
        }
        return SakuraTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public boolean placeBeehive(LevelAccessor level, BlockPos pos, Direction direction) {
        Random random = new Random();
        int chance = random.nextInt(20);
        if (level.getBlockState(pos).isAir() && chance == 0) {
            level.setBlock(pos, (BlockState)Blocks.BEE_NEST.defaultBlockState().setValue((Property)BeehiveBlock.FACING, (Comparable)direction), 2);
            level.getBlockEntity(pos, BlockEntityType.BEEHIVE).ifPresent(addBee -> {
                int j = 2 + random.nextInt(2);
                for (int k = 0; k < j; ++k) {
                    addBee.storeBee(BeehiveBlockEntity.Occupant.create((int)k));
                }
            });
        }
        return true;
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.is(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, SakuraTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.is(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, SakuraTreeFeature::isReplaceableBlock);
    }
}

