/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jm;

import com.tom.createores.recipe.VeinRecipe;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.model.TextProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class OreDistanceInfo {
    private long time;
    private PolygonOverlay overlay;

    public OreDistanceInfo(ResourceKey<Level> dim, BlockPos center, int radius, VeinRecipe vein, long time) {
        this.time = time;
        BlockPos[] c = new BlockPos[36];
        int x = center.getX();
        int z = center.getZ();
        for (int i = 0; i < 36; ++i) {
            double r = Math.toRadians(i * 10);
            c[i] = new BlockPos(x + (int)(Math.cos(r) * (double)radius), 1, z + (int)(Math.sin(r) * (double)radius));
        }
        MapPolygon polygon = new MapPolygon(c);
        int color = -65536;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(radius > 50 ? 4.0f : 2.0f).setStrokeColor(color).setFillColor(color).setFillOpacity(0.1f);
        TextProperties textProps = new TextProperties().setColor(color).setOpacity(1.0f).setFontShadow(true);
        this.overlay = new PolygonOverlay("createoreexcavation", dim, shapeProps, polygon);
        this.overlay.setOverlayGroupName("COE Veins").setLabel(Component.translatable((String)"chat.coe.veinFinder.distance", (Object[])new Object[]{vein.getName(), radius}).getString()).setTextProperties(textProps);
    }

    public PolygonOverlay getOverlay() {
        return this.overlay;
    }

    public boolean timedOut(long time) {
        return this.time < time;
    }
}

