/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Pair;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.Registration;
import com.tom.createores.components.OreVeinAtlasDataComponent;
import com.tom.createores.jm.OreDistanceInfo;
import com.tom.createores.jm.OreNearbyInfo;
import com.tom.createores.jm.OreVeinInfo;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.DimChunkPos;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.fullscreen.IThemeButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public enum OreVeinsOverlay {
    INSTANCE;

    private static final Gson gson;
    private IClientAPI api;
    private Map<DimChunkPos, OreVeinInfo> chunkDataLegacy = new HashMap<DimChunkPos, OreVeinInfo>();
    private Map<DimChunkPos, OreVeinInfo> chunkDataAtlas = new HashMap<DimChunkPos, OreVeinInfo>();
    private Map<DimChunkPos, PolygonOverlay> chunkOverlays = new HashMap<DimChunkPos, PolygonOverlay>();
    private List<OreDistanceInfo> oreDistanceInfos = new ArrayList<OreDistanceInfo>();
    private List<OreNearbyInfo> oreNearbyInfos = new ArrayList<OreNearbyInfo>();
    private final Minecraft mc = Minecraft.getInstance();
    private boolean activated = true;

    public void setApi(IClientAPI api) {
        this.api = api;
    }

    public void onMappingStarted() {
        ClientLevel level = this.mc.level;
        if (level == null) {
            return;
        }
        File modFolder = this.api.getDataPath("createoreexcavation");
        File veins = new File(modFolder, "veins.json");
        if (veins.exists()) {
            RecipeManager mngr = Minecraft.getInstance().getConnection().getRecipeManager();
            try (FileReader rd = new FileReader(veins);){
                Map root = (Map)gson.fromJson((Reader)rd, Object.class);
                root.getOrDefault("veins", Collections.emptyList()).forEach(dimMap -> {
                    ResourceLocation dimKey = ResourceLocation.tryParse((String)((String)dimMap.get("dim")));
                    ResourceKey lvl = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimKey);
                    dimMap.getOrDefault("veins", Collections.emptyList()).forEach(vein -> {
                        int x = ((Number)vein.get("x")).intValue();
                        int z = ((Number)vein.get("z")).intValue();
                        ResourceLocation key = ResourceLocation.tryParse((String)((String)vein.get("id")));
                        RecipeHolder v = mngr.byKey(key).filter(r -> r.value() instanceof VeinRecipe).map(r -> r).orElse(null);
                        if (v != null) {
                            DimChunkPos p = new DimChunkPos((ResourceKey<Level>)lvl, x, z);
                            this.chunkDataLegacy.put(p, new OreVeinInfo(p, (RecipeHolder<VeinRecipe>)v, true));
                        }
                    });
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.chunkDataLegacy.forEach((k, data) -> {
            if (!k.dimension().equals((Object)level.dimension())) {
                return;
            }
            this.showOverlay((Displayable)data.getOverlay());
            this.chunkOverlays.put((DimChunkPos)k, data.getOverlay());
        });
    }

    public void showOverlay(Displayable overlay) {
        try {
            this.api.show(overlay);
        }
        catch (Throwable t) {
            CreateOreExcavation.LOGGER.error(String.valueOf(t));
        }
    }

    public void showOverlays(Collection<? extends Displayable> overlays) {
        overlays.forEach(this::showOverlay);
    }

    public void removeOverlays(Collection<? extends Displayable> overlays) {
        overlays.forEach(o -> this.api.remove(o));
    }

    public void onMappingStopped() {
        File modFolder = this.api.getDataPath("createoreexcavation");
        File veins = new File(modFolder, "veins.json");
        modFolder.mkdirs();
        try {
            HashMap<ResourceLocation, List> dimMap = new HashMap<ResourceLocation, List>();
            this.chunkDataLegacy.forEach((k, v) -> {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("x", k.x());
                m.put("z", k.z());
                m.put("id", v.id.toString());
                dimMap.computeIfAbsent(k.dimension().location(), __ -> new ArrayList()).add(m);
            });
            HashMap root = new HashMap();
            ArrayList vs = new ArrayList();
            root.put("veins", vs);
            dimMap.forEach((k, v) -> {
                HashMap<String, Object> d = new HashMap<String, Object>();
                vs.add(d);
                d.put("dim", k.toString());
                d.put("veins", v);
            });
            try (PrintWriter w = new PrintWriter(veins);){
                gson.toJson(root, (Appendable)w);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.chunkDataLegacy.clear();
        this.chunkDataAtlas.clear();
        this.chunkOverlays.clear();
        this.oreDistanceInfos.clear();
        this.oreNearbyInfos.clear();
    }

    private void toggleOverlay() {
        if (this.isActivated()) {
            this.removeOverlays(this.chunkOverlays.values());
            this.oreDistanceInfos.forEach(e -> this.api.remove((Displayable)e.getOverlay()));
            this.oreNearbyInfos.forEach(e -> this.api.remove((Displayable)e.getOverlay()));
        } else {
            this.showOverlays(this.chunkOverlays.values());
            this.oreDistanceInfos.forEach(e -> this.showOverlay((Displayable)e.getOverlay()));
            this.oreNearbyInfos.forEach(e -> this.showOverlay((Displayable)e.getOverlay()));
        }
        this.activated = !this.isActivated();
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void toggle(IThemeButton button) {
        this.toggleOverlay();
        button.setToggled(Boolean.valueOf(this.activated));
    }

    public void setVeinInfo(ChunkPos posIn, ResourceLocation id) {
        RecipeManager mngr;
        RecipeHolder vein;
        DimChunkPos pos = new DimChunkPos((Level)this.mc.level, posIn);
        if (this.chunkDataLegacy.containsKey(pos)) {
            PolygonOverlay ov = this.chunkOverlays.remove(pos);
            if (this.activated && ov != null) {
                this.api.remove((Displayable)ov);
            }
        }
        if ((vein = (RecipeHolder)(mngr = Minecraft.getInstance().getConnection().getRecipeManager()).byKey(id).filter(r -> r.value() instanceof VeinRecipe).map(r -> r).orElse(null)) != null) {
            OreVeinInfo info = new OreVeinInfo(pos, (RecipeHolder<VeinRecipe>)vein, true);
            this.chunkDataLegacy.put(pos, info);
            if (this.activated) {
                this.showOverlay((Displayable)info.getOverlay());
            }
            this.chunkOverlays.put(pos, info.getOverlay());
        }
    }

    public void addVeinNearbyInfo(ChunkPos center, ResourceLocation id) {
        if (this.oreDistanceInfos.size() > 2) {
            OreDistanceInfo ov = this.oreDistanceInfos.remove(0);
            if (this.activated && ov != null) {
                this.api.remove((Displayable)ov.getOverlay());
            }
        }
        long time = this.mc.level.getGameTime();
        RecipeManager mngr = Minecraft.getInstance().getConnection().getRecipeManager();
        VeinRecipe vein = mngr.byKey(id).filter(r -> r.value() instanceof VeinRecipe).map(r -> (VeinRecipe)r.value()).orElse(null);
        if (vein != null) {
            OreNearbyInfo v = new OreNearbyInfo((ResourceKey<Level>)this.mc.level.dimension(), center, vein, time + 600L);
            this.oreNearbyInfos.add(v);
            if (this.activated) {
                this.showOverlay((Displayable)v.getOverlay());
            }
        }
    }

    public void addVeinDistanceInfo(BlockPos center, int radius, ResourceLocation id) {
        if (this.oreDistanceInfos.size() > 2) {
            OreDistanceInfo ov = this.oreDistanceInfos.remove(0);
            if (this.activated && ov != null) {
                this.api.remove((Displayable)ov.getOverlay());
            }
        }
        long time = this.mc.level.getGameTime();
        RecipeManager mngr = Minecraft.getInstance().getConnection().getRecipeManager();
        VeinRecipe vein = mngr.byKey(id).filter(r -> r.value() instanceof VeinRecipe).map(r -> (VeinRecipe)r.value()).orElse(null);
        if (vein != null) {
            OreDistanceInfo v = new OreDistanceInfo((ResourceKey<Level>)this.mc.level.dimension(), center, radius, vein, time + 600L);
            this.oreDistanceInfos.add(v);
            if (this.activated) {
                this.showOverlay((Displayable)v.getOverlay());
            }
        }
    }

    public void tick() {
        if (this.mc.level == null) {
            return;
        }
        long time = this.mc.level.getGameTime();
        if (time % 20L == 0L && this.isActivated()) {
            ItemStack atlas = ItemStack.EMPTY;
            int c = this.mc.player.getInventory().getContainerSize();
            for (int i2 = 0; i2 < c; ++i2) {
                ItemStack is = this.mc.player.getInventory().getItem(i2);
                if (is.getItem() != Registration.VEIN_ATLAS_ITEM.get()) continue;
                atlas = is;
                break;
            }
            HashSet found = new HashSet();
            OreVeinAtlasDataComponent atlasData = (OreVeinAtlasDataComponent)atlas.get(CreateOreExcavation.ORE_VEIN_ATLAS_DATA_COMPONENT);
            if (!atlas.isEmpty() && atlasData != null) {
                for (Pair<DimChunkPos, OreVeinAtlasDataComponent.OreVeinData> e2 : atlasData.veins()) {
                    if (((OreVeinAtlasDataComponent.OreVeinData)e2.getSecond()).hide()) continue;
                    ResourceLocation vid = ((OreVeinAtlasDataComponent.OreVeinData)e2.getSecond()).id();
                    if (!((DimChunkPos)e2.getFirst()).dimension().equals((Object)this.mc.level.dimension())) continue;
                    DimChunkPos pos = (DimChunkPos)e2.getFirst();
                    Minecraft.getInstance().level.getRecipeManager().byKey(vid).ifPresent(vr -> {
                        if (vr.value() instanceof VeinRecipe) {
                            found.add(pos);
                            OreVeinInfo info = new OreVeinInfo(pos, (RecipeHolder<VeinRecipe>)vr, false);
                            if (this.chunkDataAtlas.containsKey(pos)) {
                                if (!this.chunkDataAtlas.get(pos).equals(info)) {
                                    PolygonOverlay ov = this.chunkOverlays.remove(pos);
                                    if (this.activated && ov != null) {
                                        this.api.remove((Displayable)ov);
                                    }
                                } else {
                                    return;
                                }
                            }
                            this.chunkDataAtlas.put(pos, info);
                            if (this.activated) {
                                this.showOverlay((Displayable)info.getOverlay());
                            }
                            this.chunkOverlays.put(pos, info.getOverlay());
                            this.chunkDataLegacy.remove(pos);
                        }
                    });
                }
            }
            this.chunkDataAtlas.keySet().removeIf(e -> {
                if (!found.contains(e)) {
                    PolygonOverlay ov = this.chunkOverlays.remove(e);
                    if (this.activated && ov != null) {
                        this.api.remove((Displayable)ov);
                    }
                    return true;
                }
                return false;
            });
        }
        if (!this.oreDistanceInfos.isEmpty()) {
            this.oreDistanceInfos.removeIf(i -> {
                boolean t = i.timedOut(time);
                if (t) {
                    this.api.remove((Displayable)i.getOverlay());
                }
                return t;
            });
        }
        if (!this.oreNearbyInfos.isEmpty()) {
            this.oreNearbyInfos.removeIf(i -> {
                boolean t = i.timedOut(time);
                if (t) {
                    this.api.remove((Displayable)i.getOverlay());
                }
                return t;
            });
        }
    }

    public static void addOreInfoToMap(CompoundTag tag) {
        ResourceLocation id;
        int x = tag.getInt("x");
        int z = tag.getInt("z");
        BlockPos pos = new BlockPos(x, 0, z);
        ChunkPos center = new ChunkPos(pos);
        if (tag.contains("found")) {
            id = ResourceLocation.tryParse((String)tag.getString("found"));
            INSTANCE.setVeinInfo(center, id);
        }
        if (tag.contains("nearby")) {
            id = ResourceLocation.tryParse((String)tag.getString("nearby"));
            INSTANCE.addVeinNearbyInfo(center, id);
        }
        if (tag.contains("far")) {
            id = ResourceLocation.tryParse((String)tag.getString("far"));
            int dist = tag.getInt("dist");
            INSTANCE.addVeinDistanceInfo(pos, dist, id);
        }
    }

    static {
        gson = new GsonBuilder().create();
    }
}

