/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.block.mechanicalfryer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.pyzpre.createbitterballen.block.mechanicalfryer.MechanicalFryerEntity;
import com.pyzpre.createbitterballen.index.PartialsRegistry;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MechanicalFryerRenderer
extends ShaftRenderer<MechanicalFryerEntity> {
    public MechanicalFryerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRenderOffScreen(@NotNull MechanicalFryerEntity fryerEntity) {
        return true;
    }

    protected void renderSafe(MechanicalFryerEntity fryerEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        RandomSource random = RandomSource.create();
        ItemStack inputStack = fryerEntity.inputInv.getStackInSlot(0);
        ItemStack outputStack = fryerEntity.outputInv.getStackInSlot(0);
        double inputPosX = 0.5;
        double inputPosZ = 0.5;
        double outputPosX = 0.5;
        double outputPosZ = 0.5;
        float inputRotation = 0.0f;
        float outputRotation = 0.0f;
        float headMovement = fryerEntity.getRenderedHeadOffset(partialTicks);
        double basePosY = 0.15;
        double inputPosY = basePosY - (double)headMovement;
        double outputPosY = basePosY - (double)headMovement;
        if (!inputStack.isEmpty() && !outputStack.isEmpty()) {
            inputPosZ = 0.7;
            outputPosZ = 0.3;
            inputRotation = 35.0f;
            outputRotation = -35.0f;
        } else if (!inputStack.isEmpty()) {
            basePosY = -0.05;
            inputPosY = basePosY - (double)headMovement;
            inputRotation = 90.0f;
        } else if (!outputStack.isEmpty()) {
            basePosY = -0.05;
            outputPosY = basePosY - (double)headMovement;
            outputRotation = 90.0f;
        }
        if (!inputStack.isEmpty()) {
            this.renderStack(inputStack, poseStack, bufferSource, light, overlay, itemRenderer, random, inputPosX, inputPosY, inputPosZ, inputRotation);
        }
        if (!outputStack.isEmpty()) {
            this.renderStack(outputStack, poseStack, bufferSource, light, overlay, itemRenderer, random, outputPosX, outputPosY, outputPosZ, outputRotation);
        }
        if (VisualizationManager.supportsVisualization((LevelAccessor)fryerEntity.getLevel())) {
            return;
        }
        super.renderSafe((KineticBlockEntity)fryerEntity, partialTicks, poseStack, bufferSource, light, overlay);
        BlockState blockState = fryerEntity.getBlockState();
        VertexConsumer vb = bufferSource.getBuffer(RenderType.solid());
        float renderedHeadOffset = fryerEntity.getRenderedHeadOffset(partialTicks);
        SuperByteBuffer poleRender = CachedBuffers.partialFacing((PartialModel)AllPartialModels.MECHANICAL_MIXER_POLE, (BlockState)blockState, (Direction)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        ((SuperByteBuffer)poleRender.translate(0.0f, -renderedHeadOffset, 0.0f)).light(light).renderInto(poseStack, vb);
        VertexConsumer vbCutout = bufferSource.getBuffer(RenderType.cutoutMipped());
        SuperByteBuffer headRender = CachedBuffers.partialFacing((PartialModel)PartialsRegistry.MECHANICAL_FRYER_HEAD, (BlockState)blockState, (Direction)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        ((SuperByteBuffer)headRender.translate(0.0f, -renderedHeadOffset, 0.0f)).light(light).renderInto(poseStack, vbCutout);
    }

    private void renderStack(ItemStack stack, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, ItemRenderer itemRenderer, RandomSource random, double posX, double posY, double posZ, float rotationAngle) {
        poseStack.pushPose();
        double offsetIncrement = 0.03;
        int renderCount = Math.min(stack.getCount(), 4);
        for (int i = 0; i < renderCount; ++i) {
            poseStack.pushPose();
            long seed = (long)stack.getCount() * 31L + (long)stack.getItem().hashCode() + (long)i;
            random.setSeed(seed);
            Vec3 position = new Vec3(posX, posY - (double)i * 0.03, posZ);
            double offsetX = (random.nextDouble() - 0.5) * 0.1;
            double offsetY = 0.0;
            double offsetZ = (random.nextDouble() - 0.5) * 0.1;
            poseStack.translate(position.x + offsetX, position.y + offsetY, position.z + offsetZ);
            poseStack.mulPose(Axis.XP.rotationDegrees(rotationAngle));
            float scale = 0.5f;
            poseStack.scale(scale, scale, scale);
            itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, light, overlay, poseStack, bufferSource, (Level)Minecraft.getInstance().level, 0);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

