/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.effect;

import java.util.Optional;
import java.util.Random;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class OiledUpEffect
extends MobEffect {
    private static final Random random = new Random();
    private static final double DROP_ITEM_CHANCE = 0.01;
    private static final double FALL_OFF_LADDER_CHANCE = 0.02;

    public OiledUpEffect(MobEffectCategory mobEffectCategory, int color) {
        super(mobEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level world = entity.getCommandSenderWorld();
        this.maybeFloatInWater(entity);
        if (amplifier >= 1) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.maybeDropHeldItem(player, amplifier);
            }
            this.maybeFallOffLadder(entity);
            if (world.isRaining()) {
                this.applyLevitationEffect(entity);
            }
        }
        return true;
    }

    private void maybeDropHeldItem(Player player, int amplifier) {
        ItemStack itemStack;
        double baseDivisor = 2.0;
        double adjustedDropChance = 0.01 / (baseDivisor + Math.sqrt(amplifier + 1));
        if (!player.level().isClientSide && random.nextDouble() < adjustedDropChance && !(itemStack = player.getMainHandItem()).isEmpty()) {
            player.drop(itemStack, false, false);
            player.setItemInHand(player.getUsedItemHand(), ItemStack.EMPTY);
        }
    }

    private void maybeFloatInWater(LivingEntity entity) {
        if (entity.isInWater() && !entity.level().getBlockState(entity.blockPosition().above()).isAir()) {
            double upwardForce = 0.1;
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, upwardForce, 0.0));
        }
    }

    private void applyLevitationEffect(LivingEntity entity) {
        MobEffectInstance levitation = new MobEffectInstance(MobEffects.LEVITATION, 20, 0);
        entity.addEffect(levitation);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            this.grantAdvancementCriterion(serverPlayer, "create_bic_bit:step_3", "got_levitation");
        }
    }

    private void grantAdvancementCriterion(ServerPlayer player, String advancementID, String criterionKey) {
        PlayerAdvancements playerAdvancements = player.getAdvancements();
        ResourceLocation id = ResourceLocation.parse((String)advancementID);
        Optional<AdvancementHolder> optionalHolder = Optional.ofNullable(player.server.getAdvancements().get(id));
        optionalHolder.ifPresent(holder -> {
            AdvancementProgress progress;
            if (holder.value().criteria().containsKey(criterionKey) && !(progress = playerAdvancements.getOrStartProgress(holder)).isDone()) {
                playerAdvancements.award(holder, criterionKey);
            }
        });
    }

    private void maybeFallOffLadder(LivingEntity entity) {
        boolean isOnLadder;
        boolean bl = isOnLadder = entity.level().getBlockState(entity.blockPosition()).is(BlockTags.CLIMBABLE) || entity.level().getBlockState(entity.blockPosition().above()).is(BlockTags.CLIMBABLE);
        if (isOnLadder && random.nextDouble() < 0.02) {
            Vec3 lookVector = entity.getLookAngle();
            Vec3 pushVector = new Vec3(-lookVector.x, 0.0, -lookVector.z).normalize().scale(0.15);
            entity.setDeltaMovement(entity.getDeltaMovement().add(pushVector));
        }
    }

    public boolean shouldApplyEffectTickThisTick(int tickCount, int amplifier) {
        return true;
    }

    public void onEffectAdded(LivingEntity entity, int amplifier) {
        super.onEffectAdded(entity, amplifier);
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
    }
}

