/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.registry;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.MapCodec;
import net.darkhax.bookshelf.common.api.PhysicalSide;
import net.darkhax.bookshelf.common.api.annotation.OnlyFor;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.registry.adapters.GameRegistryAdapter;
import net.darkhax.bookshelf.common.api.registry.adapters.GenericRegistryAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockEntityRendererAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRegistryAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRenderTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.CommandArgumentAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.CreativeModeTabAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.IngredientTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.LootDescriptionAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.LootEntryTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.LootPoolAdditionAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuScreenAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.PacketAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.PotPatternAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.RecipeTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.SoundEventAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.VillagerTradeAdapter;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public interface ContentProvider {
    default public void defineAttributes(GameRegistryAdapter<Attribute> registry) {
    }

    default public void defineBlocks(BlockRegistryAdapter registry) {
    }

    default public void defineBlockEntities(GameRegistryAdapter<BlockEntityType<?>> registry) {
    }

    default public void defineItems(GameRegistryAdapter<Item> registry) {
    }

    default public void defineRecipeTypes(RecipeTypeAdapter registry) {
    }

    default public void defineCreativeTabs(CreativeModeTabAdapter registry) {
    }

    default public void defineCommandArguments(CommandArgumentAdapter registry) {
    }

    default public void defineCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection selection) {
    }

    default public void defineIngredientTypes(IngredientTypeAdapter registry) {
    }

    default public void defineTrades(VillagerTradeAdapter registry) {
    }

    default public void defineMobEffects(GameRegistryAdapter<MobEffect> registry) {
    }

    default public void defineCriteriaTriggers(GameRegistryAdapter<CriterionTrigger<?>> registry) {
    }

    default public void defineItemSubPredicates(GameRegistryAdapter<ItemSubPredicate.Type<?>> registry) {
    }

    default public void defineEntities(GameRegistryAdapter<EntityType<?>> registry) {
    }

    default public void defineCatVariants(GameRegistryAdapter<CatVariant> registry) {
    }

    default public void definePotions(GameRegistryAdapter<Potion> registry) {
    }

    default public void defineBrews(PotionBrewing.Builder registry) {
    }

    default public void definePotPatterns(PotPatternAdapter registry) {
    }

    default public void defineItemComponents(GameRegistryAdapter<DataComponentType<?>> registry) {
    }

    default public void defineEnchantmentComponents(GameRegistryAdapter<DataComponentType<?>> registry) {
    }

    default public void defineLootConditions(GameRegistryAdapter<LootItemConditionType> registry) {
    }

    default public void defineLootFunctions(GameRegistryAdapter<LootItemFunctionType<?>> registry) {
    }

    default public void defineRecipeSerializers(GameRegistryAdapter<RecipeSerializer<?>> registry) {
    }

    default public void defineLootEntryTypes(LootEntryTypeAdapter registry) {
    }

    default public void defineLootPoolAdditions(LootPoolAdditionAdapter registry) {
    }

    default public void defineLootDescriptions(LootDescriptionAdapter registry) {
    }

    default public void defineLoadConditions(GenericRegistryAdapter<MapCodec<? extends ILoadCondition>> registry) {
    }

    default public void defineMenuType(MenuTypeAdapter registry) {
    }

    default public void definePackets(PacketAdapter registry) {
    }

    default public void defineSounds(SoundEventAdapter registry) {
    }

    @OnlyFor(value=PhysicalSide.CLIENT)
    default public void defineMenuScreens(MenuScreenAdapter registry) {
    }

    @OnlyFor(value=PhysicalSide.CLIENT)
    default public void defineBlockRenderTypes(BlockRenderTypeAdapter registry) {
    }

    @OnlyFor(value=PhysicalSide.CLIENT)
    default public void defineBlockRenderers(BlockEntityRendererAdapter registry) {
    }

    public String namespace();

    default public boolean canLoad() {
        return true;
    }
}

