/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.network.INetworkHandler;
import net.darkhax.bookshelf.common.api.registry.ContentProvider;
import net.darkhax.bookshelf.common.api.util.IGameplayHelper;
import net.darkhax.bookshelf.common.api.util.IPlatformHelper;
import net.darkhax.bookshelf.common.impl.Constants;

public class Services {
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    public static final CachedSupplier<List<ContentProvider>> CONTENT = CachedSupplier.cache(() -> Services.loadMany(ContentProvider.class));
    public static final IGameplayHelper GAMEPLAY = Services.load(IGameplayHelper.class);
    public static final INetworkHandler NETWORK = Services.load(INetworkHandler.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Constants.LOG.debug("Loaded {} for service {}.", loadedService, clazz);
        return loadedService;
    }

    public static <T> List<T> loadMany(Class<T> clazz) {
        List<Object> entries = ServiceLoader.load(clazz).stream().map(ServiceLoader.Provider::get).toList();
        Constants.LOG.debug("Loaded {} entries for {}. {}", new Object[]{entries.size(), clazz, entries.stream().map(entry -> entry.getClass().getCanonicalName()).collect(Collectors.joining())});
        return entries;
    }

    public static List<String> findServices(String name) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<String> matches = new ArrayList<String>();
        Enumeration<URL> candidates = classLoader.getResources("META-INF/services/" + name);
        while (candidates.hasMoreElements()) {
            InputStream input = candidates.nextElement().openStream();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                    matches.add(line);
                }
            }
            finally {
                if (input == null) continue;
                input.close();
            }
        }
        return matches;
    }
}

