/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling.util;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class NMSHelper {
    private static final Minecraft MC = Minecraft.getInstance();
    public static final float PI = (float)Math.PI;
    public static final float HALF_PI = 1.5707964f;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static Axis XN = f -> new Quaternionf().rotationX(-f);
    public static Axis XP = f -> new Quaternionf().rotationX(f);
    public static Axis YN = f -> new Quaternionf().rotationY(-f);
    public static Axis YP = f -> new Quaternionf().rotationY(f);
    public static Axis ZN = f -> new Quaternionf().rotationZ(-f);
    public static Axis ZP = f -> new Quaternionf().rotationZ(f);

    public static ResourceLocation getResourceLocation(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static ResourceLocation getResourceLocation(String key) {
        return ResourceLocation.parse((String)key);
    }

    public static Item getItem(ResourceLocation key) {
        return (Item)BuiltInRegistries.ITEM.get(key);
    }

    public static Set<Map.Entry<ResourceKey<Item>, Item>> getItems() {
        return BuiltInRegistries.ITEM.entrySet();
    }

    public static float getXRot(Entity ent) {
        return ent.getXRot();
    }

    public static float getYRot(Entity ent) {
        return ent.getYRot();
    }

    public static void setXRot(Entity ent, float xRot) {
        ent.setXRot(xRot);
    }

    public static void setYRot(Entity ent, float yRot) {
        ent.setYRot(yRot);
    }

    public static ResourceLocation getPlayerSkin(AbstractClientPlayer player) {
        return player.getSkin().texture();
    }

    public static ResourceLocation getPlayerSkin(GameProfile gameprofile) {
        PlayerSkin playerSkin = Minecraft.getInstance().getSkinManager().getInsecureSkin(gameprofile);
        if (playerSkin.textureUrl() == null) {
            return null;
        }
        return playerSkin.texture();
    }

    public static ResourceLocation getPlayerCape(AbstractClientPlayer player) {
        try {
            return player.getSkin().capeTexture();
        }
        catch (NullPointerException ignored) {
            return null;
        }
    }

    public static GameProfile getGameProfile(ItemStack itemStack) {
        if (itemStack.getComponents().has(DataComponents.CUSTOM_MODEL_DATA)) {
            return null;
        }
        if (itemStack.getComponents().has(DataComponents.PROFILE)) {
            ResolvableProfile resolvableProfile = (ResolvableProfile)itemStack.get(DataComponents.PROFILE);
            if (resolvableProfile != null && !resolvableProfile.isResolved()) {
                itemStack.remove(DataComponents.PROFILE);
                resolvableProfile.resolve().thenAcceptAsync(resolvableProfile2 -> itemStack.set(DataComponents.PROFILE, resolvableProfile2), (Executor)Minecraft.getInstance());
                resolvableProfile = null;
            }
            if (resolvableProfile != null) {
                return resolvableProfile.gameProfile();
            }
        }
        return null;
    }

    public static void addVertex(VertexConsumer cons, Matrix4f matrix4f, float x, float y, float z, float u, float v, int lightmapUV) {
        NMSHelper.addVertex(cons, matrix4f, x, y, z, u, v, lightmapUV & 0xFFFF, lightmapUV >> 16 & 0xFFFF);
    }

    public static void addVertex(VertexConsumer cons, Matrix4f matrix4f, float x, float y, float z, float u, float v, int u2, int v2) {
        cons.addVertex(matrix4f, x, y, z).setColor(255, 255, 255, 255).setUv(u, v).setUv2(u2, v2);
    }

    public static void addVertex(VertexConsumer cons, Matrix4f matrix4f, float x, float y, float z, float u, float v) {
        cons.addVertex(matrix4f, x, y, z).setColor(255, 255, 255, 255).setUv(u, v);
    }

    public static void addVertex(VertexConsumer cons, Matrix4f matrix4f, float x, float y, float z, float u, float v, int overlay, int lightmapUV, float nx, float ny, float nz) {
        NMSHelper.addVertex(cons, matrix4f, x, y, z, u, v, overlay, lightmapUV & 0xFFFF, lightmapUV >> 16 & 0xFFFF, nx, ny, nz);
    }

    public static void addVertex(VertexConsumer cons, Matrix4f matrix4f, float x, float y, float z, float u, float v, int overlay, int u2, int v2, float nx, float ny, float nz) {
        cons.addVertex(matrix4f, x, y, z).setColor(255, 255, 255, 255).setUv(u, v).setUv2(u2, v2).setOverlay(overlay).setNormal(nx, ny, nz);
    }

    public static void sendChatMessage(Component message) {
        if (NMSHelper.MC.player != null) {
            NMSHelper.MC.player.sendSystemMessage(message);
        }
    }

    public static boolean isSame(ItemStack a, ItemStack b) {
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }

    public static boolean hasCustomName(ItemStack stack) {
        return stack.has(DataComponents.CUSTOM_NAME);
    }
}

