/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.base.spark;

import com.drmangotea.tfmg.registry.TFMGParticleTypes;
import com.simibubi.create.content.equipment.bell.BasicParticleData;
import com.simibubi.create.content.equipment.bell.CustomRotationParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;

public class ElectricSparkParticle
extends CustomRotationParticle {
    private final SpriteSet animatedSprite;
    protected int startTicks;
    protected int endTicks;
    protected int numLoops;
    protected int startFrames = 17;
    protected int loopFrames = 16;
    protected int endFrames = 20;
    protected int totalFrames = 53;

    public ElectricSparkParticle(ClientLevel worldIn, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet, ParticleOptions data) {
        super(worldIn, x, y, z, spriteSet, 0.0f);
        this.animatedSprite = spriteSet;
        this.quadSize = 0.5f;
        this.setSize(this.quadSize, this.quadSize);
        this.loopLength = this.loopFrames + (int)(this.random.nextFloat() * 5.0f - 4.0f);
        this.startTicks = this.startFrames + (int)(this.random.nextFloat() * 5.0f - 4.0f);
        this.endTicks = this.endFrames + (int)(this.random.nextFloat() * 5.0f - 4.0f);
        this.numLoops = (int)(1.0f + this.random.nextFloat() * 2.0f);
        this.setFrame(0);
        this.mirror = this.random.nextBoolean();
    }

    public void setFrame(int frame) {
        if (frame >= 0 && frame < this.totalFrames) {
            this.setSprite(this.animatedSprite.get(frame, this.totalFrames));
        }
    }

    public static class Data
    extends BasicParticleData<ElectricSparkParticle> {
        public BasicParticleData.IBasicParticleFactory<ElectricSparkParticle> getBasicFactory() {
            return (worldIn, x, y, z, vx, vy, vz, spriteSet) -> new ElectricSparkParticle(worldIn, x, y, z, vx, vy, vz, spriteSet, (ParticleOptions)this);
        }

        public ParticleType<?> getType() {
            return TFMGParticleTypes.ELECTRIC_SPARK.get();
        }
    }
}

