/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.connection.diagonal;

import com.drmangotea.tfmg.base.TFMGShapes;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.connection.diagonal.DiagonalCableBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DiagonalCableBlock
extends DirectionalBlock
implements SimpleWaterloggedBlock,
IWrenchable,
IBE<DiagonalCableBlockEntity> {
    public static final MapCodec<DiagonalCableBlock> CODEC = DiagonalCableBlock.simpleCodec(DiagonalCableBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty FACING_UP = BooleanProperty.create((String)"facing_up");

    public DiagonalCableBlock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55125_) {
        p_55125_.add(new Property[]{WATERLOGGED, FACING, FACING_UP});
    }

    public FluidState getFluidState(BlockState p_51475_) {
        return (Boolean)p_51475_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_51475_);
    }

    public void onPlace(BlockState pState, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        this.withBlockEntityDo((BlockGetter)level, pos, IElectric::onPlaced);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_54562_, BlockPos p_54563_, CollisionContext p_54564_) {
        if (((Boolean)state.getValue((Property)FACING_UP)).booleanValue()) {
            return TFMGShapes.DIAGONAL_CABLE_BLOCK_UP.get((Direction)state.getValue((Property)FACING));
        }
        return TFMGShapes.DIAGONAL_CABLE_BLOCK_DOWN.get((Direction)state.getValue((Property)FACING));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult onWrenched = super.onWrenched(state, context);
        if (!onWrenched.consumesAction()) {
            return onWrenched;
        }
        context.getLevel().setBlock(context.getClickedPos(), (BlockState)state.setValue((Property)FACING_UP, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)FACING_UP) == false)), 2);
        this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), IElectric::onPlaced);
        IWrenchable.playRotateSound((Level)context.getLevel(), (BlockPos)context.getClickedPos());
        return onWrenched;
    }

    public BlockState updateShape(BlockState p_51461_, Direction p_51462_, BlockState p_51463_, LevelAccessor p_51464_, BlockPos p_51465_, BlockPos p_51466_) {
        if (((Boolean)p_51461_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_51464_.scheduleTick(p_51465_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_51464_));
        }
        return super.updateShape(p_51461_, p_51462_, p_51463_, p_51464_, p_51465_, p_51466_);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        Direction facing = Objects.requireNonNull(context.getPlayer()).getDirection();
        Direction clickedFace = context.getClickedFace();
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            if (clickedFace == Direction.DOWN) {
                return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing.getOpposite())).setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            }
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing.getOpposite())).setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        if (clickedFace == Direction.DOWN) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public Class<DiagonalCableBlockEntity> getBlockEntityClass() {
        return DiagonalCableBlockEntity.class;
    }

    public BlockEntityType<? extends DiagonalCableBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.DIAGONAL_CABLE_BLOCK.get();
    }
}

