/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.generators.large_generator;

import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.electricity.base.KineticElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.generators.large_generator.StatorBlock;
import com.drmangotea.tfmg.content.electricity.generators.large_generator.StatorBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class RotorBlockEntity
extends KineticElectricBlockEntity {
    LerpedFloat visualSpeed = LerpedFloat.linear();
    float angle;
    boolean findNextTick = false;
    List<BlockPos> stators = new ArrayList<BlockPos>();
    public static final Map<Direction.Axis, Map<StatorOffset, BlockState>> statorPosition = RotorBlockEntity.setStatorPositons();

    public RotorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(2.0);
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.visualSpeed.chase((double)this.getGeneratedSpeed(), 0.0078125, LerpedFloat.Chaser.EXP);
    }

    @Override
    public void tick() {
        super.tick();
        this.manageRotation();
        if (this.findNextTick) {
            this.findStators();
            this.findNextTick = false;
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.findStators();
    }

    @Override
    public void onPlaced() {
        super.onPlaced();
        this.findStators();
        this.updateNextTick();
    }

    @Override
    public int voltageGeneration() {
        return Math.min(3000, this.generation() * 3);
    }

    public int generation() {
        if (this.stators.size() != 8) {
            return 0;
        }
        float modifier = TFMGConfigs.common().machines.largeGeneratorModifier.getF();
        float maxSpeed = TFMGConfigs.common().machines.largeGeneratorMinSpeed.getF();
        return (int)Math.max(0.0f, (Math.abs(this.getSpeed()) - maxSpeed) * modifier);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        this.updateNextTick();
    }

    @Override
    public int powerGeneration() {
        return (int)((double)(this.generation() * 40) * 1.84563);
    }

    public void findStators() {
        Direction.Axis axis = (Direction.Axis)this.getBlockState().getValue((Property)RotatedPillarKineticBlock.AXIS);
        Map<StatorOffset, BlockState> position = statorPosition.get(axis);
        this.stators = new ArrayList<BlockPos>();
        position.forEach((offset, state) -> {
            BlockEntity patt0$temp;
            BlockPos pos = this.getBlockPos().relative(offset.direction1);
            if (offset.direction2.isPresent()) {
                pos = pos.relative(offset.direction2.get());
            }
            if ((patt0$temp = this.level.getBlockEntity(pos)) instanceof StatorBlockEntity) {
                StatorBlockEntity be = (StatorBlockEntity)patt0$temp;
                if (be.rotor == null || be.rotor == this.getBlockPos()) {
                    this.stators.add(pos);
                    this.level.setBlock(pos, state, 2);
                    be.rotor = this.getBlockPos();
                } else {
                    this.stators = new ArrayList<BlockPos>();
                }
            } else {
                this.stators = new ArrayList<BlockPos>();
            }
        });
    }

    public void manageRotation() {
        float targetSpeed = this.getSpeed();
        this.visualSpeed.updateChaseTarget(targetSpeed);
        this.visualSpeed.tickChaser();
        this.angle += this.visualSpeed.getValue() * 3.0f / 10.0f;
        this.angle %= 360.0f;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction.getAxis() != this.getBlockState().getValue((Property)RotatedPillarKineticBlock.AXIS);
    }

    public static Map<Direction.Axis, Map<StatorOffset, BlockState>> setStatorPositons() {
        HashMap<Direction.Axis, Map<StatorOffset, BlockState>> statorPositions = new HashMap<Direction.Axis, Map<StatorOffset, BlockState>>();
        BlockState defaultState = TFMGBlocks.STATOR.getDefaultState();
        BlockState cornerState = (BlockState)defaultState.setValue(StatorBlock.STATOR_STATE, (Comparable)((Object)StatorBlock.StatorState.CORNER));
        BlockState horizontal = (BlockState)defaultState.setValue(StatorBlock.STATOR_STATE, (Comparable)((Object)StatorBlock.StatorState.CORNER_HORIZONTAL));
        BlockState sideState = (BlockState)defaultState.setValue(StatorBlock.STATOR_STATE, (Comparable)((Object)StatorBlock.StatorState.SIDE));
        BlockState cornerFlipped = (BlockState)cornerState.setValue((Property)StatorBlock.VALUE, (Comparable)Boolean.valueOf(false));
        BlockState sideFlipped = (BlockState)sideState.setValue((Property)StatorBlock.VALUE, (Comparable)Boolean.valueOf(false));
        HashMap<StatorOffset, BlockState> xPos = new HashMap<StatorOffset, BlockState>();
        xPos.put(RotorBlockEntity.pos(Direction.UP), (BlockState)sideFlipped.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.DOWN));
        xPos.put(RotorBlockEntity.pos(Direction.DOWN), (BlockState)sideFlipped.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.UP));
        xPos.put(RotorBlockEntity.pos(Direction.NORTH), (BlockState)sideFlipped.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.SOUTH));
        xPos.put(RotorBlockEntity.pos(Direction.SOUTH), (BlockState)sideFlipped.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.NORTH));
        xPos.put(RotorBlockEntity.pos(Direction.UP, Direction.NORTH), (BlockState)cornerState.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.EAST));
        xPos.put(RotorBlockEntity.pos(Direction.UP, Direction.SOUTH), (BlockState)cornerState.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.WEST));
        xPos.put(RotorBlockEntity.pos(Direction.DOWN, Direction.NORTH), (BlockState)cornerFlipped.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.EAST));
        xPos.put(RotorBlockEntity.pos(Direction.DOWN, Direction.SOUTH), (BlockState)cornerFlipped.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.WEST));
        HashMap<StatorOffset, BlockState> yPos = new HashMap<StatorOffset, BlockState>();
        yPos.put(RotorBlockEntity.pos(Direction.EAST), (BlockState)sideState.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.WEST));
        yPos.put(RotorBlockEntity.pos(Direction.WEST), (BlockState)sideState.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.EAST));
        yPos.put(RotorBlockEntity.pos(Direction.SOUTH), (BlockState)sideState.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.NORTH));
        yPos.put(RotorBlockEntity.pos(Direction.NORTH), (BlockState)sideState.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.SOUTH));
        yPos.put(RotorBlockEntity.pos(Direction.NORTH, Direction.WEST), (BlockState)horizontal.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.NORTH));
        yPos.put(RotorBlockEntity.pos(Direction.SOUTH, Direction.EAST), (BlockState)horizontal.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.SOUTH));
        yPos.put(RotorBlockEntity.pos(Direction.SOUTH, Direction.WEST), (BlockState)horizontal.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.WEST));
        yPos.put(RotorBlockEntity.pos(Direction.NORTH, Direction.EAST), (BlockState)horizontal.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.EAST));
        HashMap<StatorOffset, BlockState> zPos = new HashMap<StatorOffset, BlockState>();
        zPos.put(RotorBlockEntity.pos(Direction.UP), (BlockState)sideState.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.DOWN));
        zPos.put(RotorBlockEntity.pos(Direction.DOWN), (BlockState)sideState.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.UP));
        zPos.put(RotorBlockEntity.pos(Direction.WEST), (BlockState)sideFlipped.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.EAST));
        zPos.put(RotorBlockEntity.pos(Direction.EAST), (BlockState)sideFlipped.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.WEST));
        zPos.put(RotorBlockEntity.pos(Direction.UP, Direction.WEST), (BlockState)cornerState.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.UP));
        zPos.put(RotorBlockEntity.pos(Direction.UP, Direction.EAST), (BlockState)cornerState.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.SOUTH));
        zPos.put(RotorBlockEntity.pos(Direction.DOWN, Direction.WEST), (BlockState)cornerFlipped.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.UP));
        zPos.put(RotorBlockEntity.pos(Direction.DOWN, Direction.EAST), (BlockState)cornerFlipped.setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.SOUTH));
        statorPositions.put(Direction.Axis.X, xPos);
        statorPositions.put(Direction.Axis.Y, yPos);
        statorPositions.put(Direction.Axis.Z, zPos);
        return statorPositions;
    }

    private static StatorOffset pos(Direction dir1) {
        return new StatorOffset(dir1, Optional.empty());
    }

    private static StatorOffset pos(Direction dir1, Direction dir2) {
        return new StatorOffset(dir1, Optional.of(dir2));
    }

    private static class StatorOffset {
        public final Direction direction1;
        public final Optional<Direction> direction2;

        public StatorOffset(Direction dir1, Optional<Direction> dir2) {
            this.direction1 = dir1;
            this.direction2 = dir2;
        }
    }
}

