/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.items.weapons.explosives.thermite_grenades;

import com.drmangotea.tfmg.content.items.weapons.explosives.thermite_grenades.ThermiteGrenade;
import com.drmangotea.tfmg.content.items.weapons.explosives.thermite_grenades.ThermiteGrenadeItem;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ThermiteGrenadeRenderer
extends EntityRenderer<ThermiteGrenade> {
    private final ItemRenderer itemRenderer;
    private ThermiteGrenade.ChemicalColor chemicalColor;

    public static ThermiteGrenadeRenderer regular(EntityRendererProvider.Context p_i48440_1_) {
        return new ThermiteGrenadeRenderer(p_i48440_1_, ThermiteGrenade.ChemicalColor.BASE);
    }

    public static ThermiteGrenadeRenderer green(EntityRendererProvider.Context p_i48440_1_) {
        return new ThermiteGrenadeRenderer(p_i48440_1_, ThermiteGrenade.ChemicalColor.GREEN);
    }

    public static ThermiteGrenadeRenderer blue(EntityRendererProvider.Context p_i48440_1_) {
        return new ThermiteGrenadeRenderer(p_i48440_1_, ThermiteGrenade.ChemicalColor.BLUE);
    }

    public ThermiteGrenadeRenderer(EntityRendererProvider.Context p_174114_, ThermiteGrenade.ChemicalColor color) {
        super(p_174114_);
        this.chemicalColor = color;
        this.itemRenderer = p_174114_.getItemRenderer();
    }

    public void render(ThermiteGrenade grenade, float p_114657_, float p_114658_, PoseStack p_114659_, MultiBufferSource p_114660_, int p_114661_) {
        p_114659_.pushPose();
        p_114659_.mulPose(this.entityRenderDispatcher.cameraOrientation());
        p_114659_.mulPose(Axis.YP.rotationDegrees(180.0f));
        if (this.chemicalColor == ThermiteGrenade.ChemicalColor.GREEN) {
            this.itemRenderer.renderStatic(((ThermiteGrenadeItem)((Object)TFMGItems.ZINC_GRENADE.get())).getDefaultInstance(), ItemDisplayContext.GROUND, p_114661_, OverlayTexture.NO_OVERLAY, p_114659_, p_114660_, grenade.level(), grenade.getId());
        } else if (this.chemicalColor == ThermiteGrenade.ChemicalColor.BLUE) {
            this.itemRenderer.renderStatic(((ThermiteGrenadeItem)((Object)TFMGItems.COPPER_GRENADE.get())).getDefaultInstance(), ItemDisplayContext.GROUND, p_114661_, OverlayTexture.NO_OVERLAY, p_114659_, p_114660_, grenade.level(), grenade.getId());
        } else {
            this.itemRenderer.renderStatic(((ThermiteGrenadeItem)((Object)TFMGItems.THERMITE_GRENADE.get())).getDefaultInstance(), ItemDisplayContext.GROUND, p_114661_, OverlayTexture.NO_OVERLAY, p_114659_, p_114660_, grenade.level(), grenade.getId());
        }
        p_114659_.popPose();
        super.render((Entity)grenade, p_114657_, p_114658_, p_114659_, p_114660_, p_114661_);
    }

    public ResourceLocation getTextureLocation(ThermiteGrenade p_114654_) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

