/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.vat.base;

import com.drmangotea.tfmg.base.lang.TFMGLang;
import com.drmangotea.tfmg.base.lang.TFMGTexts;
import com.drmangotea.tfmg.content.machinery.vat.base.IVatMachine;
import com.drmangotea.tfmg.content.machinery.vat.base.VatBlock;
import com.drmangotea.tfmg.content.machinery.vat.base.VatInventory;
import com.drmangotea.tfmg.mixin.accessor.TankSegmentAccessor;
import com.drmangotea.tfmg.recipes.VatMachineRecipe;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class VatBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid {
    private static final int MAX_SIZE = 3;
    public VatInventory inputInventory;
    public VatInventory outputInventory;
    public SmartFluidTankBehaviour inputTank;
    public SmartFluidTankBehaviour outputTank;
    private Couple<SmartFluidTankBehaviour> tanks;
    protected IFluidHandler fluidCapability;
    protected IItemHandlerModifiable itemCapability;
    protected boolean forceFluidLevelUpdate;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    protected boolean updateCapability;
    protected boolean window = false;
    protected int luminosity;
    protected int width;
    protected int height;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    public LerpedFloat[] fluidLevel = new LerpedFloat[8];
    public Map<BlockPos, String> machineMap = new HashMap<BlockPos, String>();
    public Map<BlockPos, Boolean> operationalMachinesMap = new HashMap<BlockPos, Boolean>();
    public boolean areMachinesValid = true;
    boolean evaluateNextTick = true;
    float efficiency = 1.0f;
    int timer = 0;
    public VatMachineRecipe recipe;
    int heatLevel = 0;
    HeatCondition heatCondition = HeatCondition.NONE;
    private static final Object vatRecipeKey = new Object();

    public VatBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        for (int i = 0; i < 8; ++i) {
            this.fluidLevel[i] = LerpedFloat.linear();
        }
        this.window = false;
        this.inputInventory = new VatInventory(4, this);
        this.outputInventory = new VatInventory(4, this);
        this.tanks = Couple.create((Object)this.inputTank, (Object)this.outputTank);
        this.itemCapability = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventory});
        this.forceFluidLevelUpdate = true;
        this.updateConnectivity = false;
        this.updateCapability = false;
        this.height = 1;
        this.width = 1;
        this.refreshCapability();
    }

    public Couple<SmartFluidTankBehaviour> getTanks() {
        return this.tanks;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.CHEMICAL_VAT.get(), (be, context) -> {
            if (be.fluidCapability == null) {
                be.refreshCapability();
            }
            return be.fluidCapability;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.CHEMICAL_VAT.get(), (be, context) -> {
            if (be.itemCapability == null) {
                be.refreshCapability();
            }
            return be.itemCapability;
        });
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 4, 4000, true).whenFluidUpdates(this::onInventoryChanged);
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 4, 4000, true).whenFluidUpdates(this::onInventoryChanged).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        behaviours.add((BlockEntityBehaviour)this.outputTank);
        this.fluidCapability = new CombinedTankWrapper(new IFluidHandler[]{this.inputTank.getCapability(), this.outputTank.getCapability()});
    }

    protected Object getRecipeCacheKey() {
        return vatRecipeKey;
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level.isClientSide) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.recipe == null && this.isController()) {
            this.recipe = this.getMatchingRecipe();
        }
        this.updateTemperature();
        if (this.level.isClientSide && !(this.level instanceof PonderLevel)) {
            int tankNumber = 0;
            for (int i = 0; i < 8; ++i) {
                IFluidHandler fluidHandler = this.fluidCapability;
                if (fluidHandler == null) continue;
                this.fluidLevel[i].chase((double)fluidHandler.getFluidInTank(tankNumber).getAmount() / (double)this.inputTank.getPrimaryHandler().getCapacity(), 0.5, LerpedFloat.Chaser.EXP);
                this.getFillState();
                ++tankNumber;
            }
        }
    }

    public void updateTemperature() {
        if (!this.isController()) {
            return;
        }
        int prevHeat = this.heatLevel;
        this.heatLevel = 0;
        this.heatCondition = HeatCondition.NONE;
        BlockPos pos1 = this.controller == null ? this.getBlockPos() : this.controller;
        VatBlockEntity be = this.getControllerBE() == null ? this : this.getControllerBE();
        for (int xOffset = 0; xOffset < be.width; ++xOffset) {
            for (int zOffset = 0; zOffset < be.width; ++zOffset) {
                BlockState blockState;
                BlockPos pos = pos1.offset(xOffset, -1, zOffset);
                float heat = BoilerHeater.findHeat((Level)this.level, (BlockPos)pos, (BlockState)(blockState = this.level.getBlockState(pos)));
                if (!(heat > 0.0f)) continue;
                this.heatLevel += (int)heat;
            }
        }
        if (this.heatLevel >= 2) {
            this.heatCondition = HeatCondition.HEATED;
        }
        if (this.heatLevel >= 4) {
            this.heatCondition = HeatCondition.SUPERHEATED;
        }
        if (this.heatLevel != prevHeat) {
            this.notifyUpdate();
        }
    }

    public VatMachineRecipe getMatchingRecipe() {
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.level, (Predicate)RecipeConditions.isOfType((RecipeType[])new RecipeType[]{TFMGRecipeTypes.VAT_MACHINE_RECIPE.getType()}));
        for (RecipeHolder recipe1 : list) {
            int i;
            VatMachineRecipe testedRecipe = (VatMachineRecipe)recipe1.value();
            if (this.getTotalTankSize() < testedRecipe.minSize) continue;
            boolean doesntMatch = false;
            if (!Objects.equals(testedRecipe.machines, this.machineMap.values().stream().toList()) || !this.areMachinesValid || !testedRecipe.allowedVatTypes.contains(((VatBlock)this.getBlockState().getBlock()).vatType)) continue;
            IFluidHandler fluidHandler = this.fluidCapability;
            IItemHandlerModifiable itemHandler = this.itemCapability;
            HashMap<Integer, Integer> isFluidFound = new HashMap<Integer, Integer>();
            for (int i2 = 0; i2 < testedRecipe.getFluidIngredients().size(); ++i2) {
                SizedFluidIngredient ingredient = (SizedFluidIngredient)testedRecipe.getFluidIngredients().get(i2);
                Integer foundAt = null;
                if (ingredient.getFluids().length == 0) break;
                for (int y = 0; y < fluidHandler.getTanks(); ++y) {
                    FluidStack stack;
                    if (isFluidFound.containsValue(y) || !ingredient.test(stack = fluidHandler.getFluidInTank(y))) continue;
                    foundAt = y;
                    break;
                }
                if (foundAt != null) {
                    isFluidFound.put(i2, foundAt);
                    continue;
                }
                doesntMatch = true;
            }
            SmartInventory testInventory = new SmartInventory(8, (SyncedBlockEntity)this);
            for (i = 0; i < 4; ++i) {
                testInventory.setStackInSlot(i, this.inputInventory.getStackInSlot(i).copy());
            }
            for (i = 0; i < 4; ++i) {
                testInventory.setStackInSlot(i + 4, this.outputInventory.getStackInSlot(i).copy());
            }
            for (i = 0; i < testedRecipe.getIngredients().size(); ++i) {
                Ingredient ingredient = (Ingredient)testedRecipe.getIngredients().get(i);
                boolean found = false;
                for (int y = 0; y < 8; ++y) {
                    ItemStack stack = testInventory.getStackInSlot(y).copy();
                    if (!ingredient.test(stack)) continue;
                    found = true;
                    testInventory.getItem(y).shrink(1);
                    break;
                }
                if (found) continue;
                doesntMatch = true;
                break;
            }
            if (doesntMatch) continue;
            HashMap<Fluid, Integer> fluids = new HashMap<Fluid, Integer>();
            ArrayList<FluidStack> totalFluidStacks = new ArrayList<FluidStack>();
            for (int i3 = 0; i3 < this.outputTank.getPrimaryHandler().getTanks(); ++i3) {
                totalFluidStacks.add(this.outputTank.getPrimaryHandler().getFluidInTank(i3));
            }
            totalFluidStacks.addAll((Collection<FluidStack>)testedRecipe.getFluidResults());
            for (FluidStack stack : totalFluidStacks) {
                if (stack.isEmpty()) continue;
                if (fluids.containsKey(stack.getFluid())) {
                    fluids.replace(stack.getFluid(), (Integer)fluids.get(stack.getFluid()) + stack.getAmount());
                    continue;
                }
                fluids.put(stack.getFluid(), stack.getAmount());
            }
            AtomicBoolean cantOutput = new AtomicBoolean(false);
            fluids.forEach((f, a) -> {
                if (a > 4000) {
                    cantOutput.set(true);
                }
            });
            HashMap<Item, Integer> items = new HashMap<Item, Integer>();
            ArrayList<ItemStack> totalItemStacks = new ArrayList<ItemStack>();
            for (int i4 = 0; i4 < this.outputInventory.getSlots(); ++i4) {
                totalItemStacks.add(this.outputInventory.getStackInSlot(i4));
            }
            totalItemStacks.addAll(testedRecipe.getRollableResultsAsItemStacks());
            for (ItemStack stack : totalItemStacks) {
                if (stack.isEmpty()) continue;
                if (items.containsKey(stack.getItem())) {
                    items.replace(stack.getItem(), (Integer)items.get(stack.getItem()) + stack.getCount());
                    continue;
                }
                items.put(stack.getItem(), stack.getCount());
            }
            items.forEach((f, a) -> {
                if (a > 64) {
                    cantOutput.set(true);
                }
            });
            if (cantOutput.get()) continue;
            return testedRecipe;
        }
        return null;
    }

    public void tick() {
        super.tick();
        this.handleRecipe();
        if (this.isController()) {
            Iterator<BlockPos> iter = this.machineMap.keySet().iterator();
            while (iter.hasNext()) {
                BlockPos machinePos = iter.next();
                BlockEntity blockEntity = this.level.getBlockEntity(machinePos);
                if (blockEntity != null) {
                    if (blockEntity instanceof IVatMachine) {
                        IVatMachine vatMachine = (IVatMachine)blockEntity;
                        boolean operational = vatMachine.canOperate(this);
                        this.operationalMachinesMap.put(machinePos, operational);
                        continue;
                    }
                    iter.remove();
                    this.operationalMachinesMap.remove(machinePos);
                    continue;
                }
                iter.remove();
                this.operationalMachinesMap.remove(machinePos);
            }
        }
        this.areMachinesValid = this.operationalMachinesMap.values().stream().allMatch(op -> op == true);
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.evaluateNextTick) {
            this.evaluate();
            this.sendData();
            this.evaluateNextTick = false;
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.getBlockPos();
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition) && this.worldPosition != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        for (int i = 0; i < 8; ++i) {
            this.fluidLevel[i].tickChaser();
        }
    }

    public void handleRecipe() {
        if (this.recipe == null) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        if (this.heatLevel < this.recipe.heatLevel) {
            return;
        }
        if (this.recipe.getRequiredHeat() == HeatCondition.HEATED && this.heatCondition == HeatCondition.NONE) {
            return;
        }
        if (this.recipe.getRequiredHeat() == HeatCondition.SUPERHEATED && this.heatCondition != HeatCondition.SUPERHEATED) {
            return;
        }
        if (this.timer >= this.recipe.getProcessingDuration()) {
            SmartFluidTank outputFluidHandler = this.outputTank.getPrimaryHandler();
            IFluidHandler fluidHandler = this.fluidCapability;
            IItemHandlerModifiable itemHandler = this.itemCapability;
            block0: for (SizedFluidIngredient ingredient : this.recipe.getFluidIngredients()) {
                for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                    FluidStack fluidInTank = fluidHandler.getFluidInTank(i);
                    if (!ingredient.test(new FluidStack(fluidInTank.getFluidHolder(), 4000))) continue;
                    fluidHandler.getFluidInTank(i).setAmount(fluidInTank.getAmount() - ingredient.amount());
                    continue block0;
                }
            }
            block2: for (ProcessingOutput output : this.recipe.getRollableResults()) {
                int i;
                ItemStack itemStack = output.rollOutput(this.level.random);
                boolean handled = false;
                for (i = 0; i < this.outputInventory.getSlots(); ++i) {
                    ItemStack stackInSlot = this.outputInventory.getStackInSlot(i);
                    if (stackInSlot.isEmpty() || !stackInSlot.is(itemStack.getItem())) continue;
                    this.outputInventory.getStackInSlot(i).setCount(stackInSlot.getCount() + itemStack.getCount());
                    handled = true;
                    break;
                }
                if (handled) break;
                for (i = 0; i < this.outputInventory.getSlots(); ++i) {
                    ItemStack itemInSlot = this.outputInventory.getStackInSlot(i);
                    if (!itemInSlot.isEmpty()) continue;
                    this.outputInventory.setStackInSlot(i, itemStack);
                    continue block2;
                }
            }
            if (this.recipe != null) {
                block5: for (SizedFluidIngredient ingredient : this.recipe.getIngredients()) {
                    for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                        ItemStack stackInInv = itemHandler.getStackInSlot(i);
                        if (!ingredient.test(new ItemStack((ItemLike)stackInInv.getItem(), 64))) continue;
                        stackInInv.setCount(stackInInv.getCount() - ingredient.getItems()[0].getCount());
                        continue block5;
                    }
                }
            }
            ArrayList handledFluidResults = new ArrayList();
            ArrayList<FluidStack> handledFluidStacks = new ArrayList<FluidStack>();
            List<SmartFluidTankBehaviour.TankSegment> tankSegments = List.of(this.outputTank.getTanks());
            if (this.recipe != null) {
                block7: for (FluidStack fluidStack : this.recipe.getFluidResults()) {
                    for (SmartFluidTankBehaviour.TankSegment tankSegment : tankSegments) {
                        SmartFluidTank tank = ((TankSegmentAccessor)tankSegment).tfmg$tank();
                        FluidStack fluidInTank = tank.getFluid();
                        if (handledFluidStacks.contains(fluidStack)) continue block7;
                        if (fluidInTank.getFluid().isSame(fluidStack.getFluid())) {
                            tank.fill(new FluidStack(fluidStack.getFluid(), fluidStack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
                            handledFluidStacks.add(fluidStack);
                            continue block7;
                        }
                        if (handledFluidStacks.contains(fluidStack) || !fluidInTank.isEmpty()) continue;
                        tank.fill(new FluidStack(fluidStack.getFluid(), fluidStack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
                        continue block7;
                    }
                }
            }
            this.recipe = null;
            this.timer = 0;
        } else {
            ++this.timer;
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.level.isClientSide) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.worldPosition;
    }

    protected void onInventoryChanged() {
        if (!this.hasLevel()) {
            return;
        }
        this.recipe = this.getMatchingRecipe();
        FluidStack newFluidStack = this.inputTank.getPrimaryHandler().getFluid();
        FluidType attributes = newFluidStack.getFluid().getFluidType();
        int luminosity = (int)((float)attributes.getLightLevel(newFluidStack) / 1.2f);
        boolean reversed = attributes.isLighterThanAir();
        int maxY = (int)(this.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.height - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    VatBlockEntity vatAt = (VatBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.getType(), (BlockGetter)this.level, (BlockPos)pos);
                    if (vatAt == null) continue;
                    this.level.updateNeighbourForOutputSignal(pos, vatAt.getBlockState().getBlock());
                    if (vatAt.luminosity == actualLuminosity) continue;
                    vatAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
    }

    protected void setLuminosity(int luminosity) {
        if (this.level.isClientSide) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public VatBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof VatBlockEntity) {
            return (VatBlockEntity)blockEntity;
        }
        return null;
    }

    public void evaluate() {
        if (!this.isController()) {
            if (this.getControllerBE() == null) {
                return;
            }
            this.getControllerBE().evaluate();
            return;
        }
        Map<BlockPos, String> oldMachineMap = this.machineMap;
        this.machineMap = new HashMap<BlockPos, String>();
        this.heatLevel = 0;
        this.heatCondition = HeatCondition.NONE;
        boolean superheatedCount = false;
        float speed = 1.0f;
        for (int xOffset = 0; xOffset < this.width; ++xOffset) {
            for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                for (int yOffset = 0; yOffset < this.getHeight() + 2; ++yOffset) {
                    IVatMachine be;
                    BlockEntity blockEntity;
                    BlockPos pos = this.getBlockPos().below().offset(xOffset, yOffset, zOffset);
                    BlockState blockState = this.level.getBlockState(pos);
                    if (VatBlock.isVat(blockState) || !((blockEntity = this.level.getBlockEntity(pos)) instanceof IVatMachine) || (be = (IVatMachine)blockEntity).getOperationId().isEmpty() || !this.isAtValidLocation(be.getPositionRequirement(), pos)) continue;
                    be.vatUpdated(this);
                    this.machineMap.put(pos, be.getOperationId());
                    this.efficiency *= (float)be.getWorkPercentage() / 100.0f;
                }
            }
        }
        this.efficiency = speed;
        if (oldMachineMap != this.machineMap) {
            this.recipe = null;
        }
        this.notifyUpdate();
    }

    public int getTotalCapacity() {
        int totalCapacity = 0;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                totalCapacity += ((TankSegmentAccessor)tankSegment).tfmg$tank().getCapacity();
            }
        }
        return totalCapacity;
    }

    public float getTotalFluidUnits(float partialTicks) {
        int renderedFluids = 0;
        float totalUnits = 0.0f;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                if (tankSegment.getRenderedFluid().isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                totalUnits += units;
                ++renderedFluids;
            }
        }
        if (renderedFluids == 0) {
            return 0.0f;
        }
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        return totalUnits;
    }

    public boolean isAtValidLocation(IVatMachine.PositionRequirement requirement, BlockPos pos) {
        return switch (requirement) {
            default -> throw new MatchException(null, null);
            case IVatMachine.PositionRequirement.ANY -> true;
            case IVatMachine.PositionRequirement.BOTTOM -> {
                if (pos.getY() == this.getController().getY() - 1) {
                    yield true;
                }
                yield false;
            }
            case IVatMachine.PositionRequirement.TOP -> {
                if (pos.getY() == this.getController().getY() + this.height) {
                    yield true;
                }
                yield false;
            }
            case IVatMachine.PositionRequirement.ANY_CENTER -> this.isAtCenter(pos);
            case IVatMachine.PositionRequirement.BOTTOM_CENTER -> {
                if (this.isAtCenter(pos) && pos.getY() == this.getController().getY() - 1) {
                    yield true;
                }
                yield false;
            }
            case IVatMachine.PositionRequirement.TOP_CENTER -> this.isAtCenter(pos) && pos.getY() == this.getController().getY() + this.height;
        };
    }

    public boolean isAtCenter(BlockPos pos) {
        return this.width < 3 || pos.getX() == this.getController().getX() + 1 && pos.getZ() == this.getController().getZ() + 1;
    }

    public void applyVatSize(int blocks) {
        this.inputTank.forEach(s -> {
            SmartFluidTank tank = ((TankSegmentAccessor)s).tfmg$tank();
            tank.setCapacity(blocks * VatBlockEntity.getCapacityMultiplier());
            int overflow = tank.getFluidAmount() - tank.getCapacity();
            if (overflow > 0) {
                tank.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
            }
        });
        this.outputTank.forEach(s -> {
            SmartFluidTank tank = ((TankSegmentAccessor)s).tfmg$tank();
            tank.setCapacity(blocks * VatBlockEntity.getCapacityMultiplier());
            int overflow = tank.getFluidAmount() - tank.getCapacity();
            if (overflow > 0) {
                tank.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
            }
        });
        this.forceFluidLevelUpdate = true;
        this.evaluateNextTick = true;
    }

    public void removeController(boolean keepFluids) {
        if (this.level.isClientSide) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyVatSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onInventoryChanged();
        BlockState state = this.getBlockState();
        if (VatBlock.isVat(state)) {
            state = (BlockState)state.setValue((Property)VatBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.setValue((Property)VatBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.setValue(VatBlock.SHAPE, (Comparable)((Object)(this.window ? VatBlock.Shape.WINDOW : VatBlock.Shape.PLAIN)));
            this.getLevel().setBlock(this.worldPosition, state, 22);
        }
        this.evaluateNextTick = true;
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    public void toggleWindows() {
        VatBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        if (((VatBlock)this.getBlockState().getBlock()).vatType == "tfmg:firebrick_lined_vat") {
            return;
        }
        be.setWindows(!be.window);
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setWindows(boolean window) {
        this.window = window;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    BlockState blockState = this.level.getBlockState(pos);
                    if (!VatBlock.isVat(blockState)) continue;
                    VatBlock.Shape shape = VatBlock.Shape.PLAIN;
                    if (window) {
                        if (this.width == 1) {
                            shape = VatBlock.Shape.WINDOW;
                        }
                        if (this.width == 2) {
                            VatBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? VatBlock.Shape.WINDOW_NW : VatBlock.Shape.WINDOW_SW) : (shape = zOffset == 0 ? VatBlock.Shape.WINDOW_NE : VatBlock.Shape.WINDOW_SE);
                        }
                        if (this.width == 3 && Math.abs(Math.abs(xOffset) - Math.abs(zOffset)) == 1) {
                            shape = VatBlock.Shape.WINDOW;
                        }
                    }
                    this.level.setBlock(pos, (BlockState)blockState.setValue(VatBlock.SHAPE, (Comparable)((Object)shape)), 22);
                    this.level.getChunkSource().getLightEngine().checkBlock(pos);
                }
            }
        }
    }

    public void updateState() {
        if (!this.isController()) {
            return;
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.offset(xOffset, yOffset, zOffset));
                    if (!(blockEntity instanceof VatBlockEntity)) continue;
                    VatBlockEntity fbe = (VatBlockEntity)blockEntity;
                    fbe.refreshCapability();
                }
            }
        }
    }

    public void setController(BlockPos controller) {
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    private void refreshCapability() {
        this.fluidCapability = this.getNewFluidCapability();
        this.itemCapability = this.getNewItemCapability();
        this.invalidateCapabilities();
    }

    private IFluidHandler getNewFluidCapability() {
        IFluidHandler inputHandler = this.inputTank.getCapability();
        IFluidHandler outputHandler = this.outputTank.getCapability();
        if (inputHandler == null || outputHandler == null) {
            return this.fluidCapability;
        }
        return this.isController() ? new CombinedTankWrapper(new IFluidHandler[]{inputHandler, outputHandler}) : (this.getControllerBE() != null ? this.getControllerBE().getNewFluidCapability() : this.fluidCapability);
    }

    private IItemHandlerModifiable getNewItemCapability() {
        return this.isController() ? new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventory}) : (this.getControllerBE() != null ? this.getControllerBE().getNewItemCapability() : this.itemCapability);
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().expandTowards((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    @Nullable
    public VatBlockEntity getOtherVatBE(Direction direction) {
        BlockEntity otherBE = this.level.getBlockEntity(this.worldPosition.relative(direction));
        if (otherBE instanceof VatBlockEntity) {
            return (VatBlockEntity)otherBE;
        }
        return null;
    }

    public void addMachineTooltip(String operationId, boolean isOperational, List<Component> tooltip) {
        LangBuilder operation = TFMGTexts.Vat.operation(operationId);
        if (!isOperational) {
            operation.add(TFMGTexts.Vat.notOperational());
        }
        operation.forGoggles(tooltip);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.getControllerBE() == null) {
            return false;
        }
        if (!this.isController()) {
            return this.getControllerBE().addToGoggleTooltip(tooltip, isPlayerSneaking);
        }
        TFMGTexts.header("vat").style(ChatFormatting.GRAY).forGoggles(tooltip);
        TFMGTexts.Vat.contents().forGoggles(tooltip);
        TFMGTexts.Vat.attachments().style(ChatFormatting.GRAY).forGoggles(tooltip);
        for (Map.Entry<BlockPos, String> machines : this.machineMap.entrySet()) {
            boolean operational = this.operationalMachinesMap.getOrDefault(machines.getKey(), true);
            this.addMachineTooltip(machines.getValue(), operational, tooltip);
        }
        TFMGTexts.heatStatus(this.heatCondition).forGoggles(tooltip);
        TFMGTexts.Vat.contents().forGoggles(tooltip);
        IItemHandlerModifiable items = this.itemCapability;
        IFluidHandler fluids = this.fluidCapability;
        boolean isEmpty = true;
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            TFMGLang.text("").add(Component.translatable((String)stackInSlot.getDescriptionId()).withStyle(ChatFormatting.GRAY)).add(TFMGLang.text(" x" + stackInSlot.getCount()).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        for (int i = 0; i < fluids.getTanks(); ++i) {
            FluidStack fluidStack = fluids.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            TFMGLang.text("").add(TFMGLang.fluidName(fluidStack).add(TFMGLang.text(" ")).style(ChatFormatting.GRAY).add(TFMGLang.number(fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (isEmpty) {
            tooltip.remove(0);
        }
        return true;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, registries, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.contains("Uninitialized");
        this.luminosity = compound.getInt("Luminosity");
        this.controller = null;
        this.lastKnownPos = null;
        if (NbtUtils.readBlockPos((CompoundTag)compound, (String)"LastKnownPos").isPresent()) {
            this.lastKnownPos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)compound, (String)"LastKnownPos").get();
        }
        if (NbtUtils.readBlockPos((CompoundTag)compound, (String)"Controller").isPresent()) {
            this.controller = (BlockPos)NbtUtils.readBlockPos((CompoundTag)compound, (String)"Controller").get();
        }
        if (this.isController()) {
            this.window = compound.getBoolean("Window");
            this.width = compound.getInt("Size");
            this.height = compound.getInt("Height");
            this.inputTank.forEach(s -> {
                SmartFluidTank tank = ((TankSegmentAccessor)s).tfmg$tank();
                tank.setCapacity(this.getTotalTankSize() * VatBlockEntity.getCapacityMultiplier());
                if (tank.getSpace() < 0) {
                    tank.drain(-tank.getSpace(), IFluidHandler.FluidAction.EXECUTE);
                }
            });
            this.outputTank.forEach(s -> {
                SmartFluidTank tank = ((TankSegmentAccessor)s).tfmg$tank();
                tank.setCapacity(this.getTotalTankSize() * VatBlockEntity.getCapacityMultiplier());
                if (tank.getSpace() < 0) {
                    tank.drain(-tank.getSpace(), IFluidHandler.FluidAction.EXECUTE);
                }
            });
            this.inputInventory.deserializeNBT(registries, compound.getCompound("InputItems"));
            this.outputInventory.deserializeNBT(registries, compound.getCompound("OutputItems"));
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.hasLevel()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            }
            if (this.isController()) {
                this.inputTank.forEach(s -> ((TankSegmentAccessor)s).tfmg$tank().setCapacity(VatBlockEntity.getCapacityMultiplier() * this.getTotalTankSize()));
                this.outputTank.forEach(s -> ((TankSegmentAccessor)s).tfmg$tank().setCapacity(VatBlockEntity.getCapacityMultiplier() * this.getTotalTankSize()));
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float f = this.getFillState();
        }
        if (this.luminosity != prevLum && this.hasLevel()) {
            this.level.getChunkSource().getLightEngine().checkBlock(this.worldPosition);
        }
    }

    public float getFillState() {
        IFluidHandler fluidHandler = this.fluidCapability;
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            if (fluidHandler.getFluidInTank(i).isEmpty()) continue;
            return (float)fluidHandler.getFluidInTank(i).getAmount() / (float)fluidHandler.getTankCapacity(0);
        }
        return 0.0f;
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.putBoolean("Window", this.window);
            compound.putInt("Size", this.width);
            compound.putInt("Height", this.height);
            compound.put("InputItems", (Tag)this.inputInventory.serializeNBT(registries));
            compound.put("OutputItems", (Tag)this.outputInventory.serializeNBT(registries));
        }
        compound.putInt("Luminosity", this.luminosity);
        super.write(compound, registries, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.putBoolean("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.putBoolean("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public void invalidate() {
        super.invalidate();
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public static int getMaxHeight() {
        return 3;
    }

    public LerpedFloat[] getFluidLevel() {
        return this.fluidLevel;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.getBlockState();
        if (VatBlock.isVat(state)) {
            state = (BlockState)state.setValue((Property)VatBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().getY() == this.getBlockPos().getY()));
            state = (BlockState)state.setValue((Property)VatBlock.TOP, (Comparable)Boolean.valueOf(this.getController().getY() + this.height - 1 == this.getBlockPos().getY()));
            this.level.setBlock(this.getBlockPos(), state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.evaluateNextTick = true;
        this.onInventoryChanged();
        this.setChanged();
    }

    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean) {
            this.window = (Boolean)data;
        }
    }

    @Nullable
    public Object getExtraData() {
        return this.window;
    }

    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return VatBlockEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public int getTankSize(int tank) {
        return VatBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyVatSize(blocks);
    }

    public IFluidTank getTank(int tank) {
        return new FluidTank(1);
    }

    public FluidStack getFluid(int tank) {
        return this.inputTank.getPrimaryHandler().getFluid();
    }
}

